/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.flask.codeInsight;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlaskTemplateManager {
    public static boolean isTemplateReference(PyStringLiteralExpression expr) {
        return FlaskTemplateManager.isFirstCallArgument(expr, "render_template", "templating.py");
    }

    public static boolean isFirstCallArgument(@Nullable PyStringLiteralExpression expr, @NotNull String expectedCalleeName, @NotNull String expectedCalleeFile) {
        PyCallExpression call;
        if (expectedCalleeName == null) {
            FlaskTemplateManager.$$$reportNull$$$0(0);
        }
        if (expectedCalleeFile == null) {
            FlaskTemplateManager.$$$reportNull$$$0(1);
        }
        if ((call = (PyCallExpression)PsiTreeUtil.getParentOfType((PsiElement)expr, PyCallExpression.class)) != null) {
            int actualArgumentIndex = PyPsiUtils.findArgumentIndex(call, expr);
            Condition callableIsInExpectedFile = callable -> {
                PsiFile containingFile = callable.getContainingFile();
                return containingFile != null && containingFile.getName().equals(expectedCalleeFile);
            };
            if (actualArgumentIndex == 0 && call.isCalleeText(expectedCalleeName) && ContainerUtil.exists(call.multiResolveCalleeFunction(PyResolveContext.defaultContext()), (Condition)callableIsInExpectedFile)) {
                return true;
            }
        }
        return false;
    }

    public static List<PyStringLiteralExpression> collectTemplateReferences(PyFunction function) {
        final ArrayList<PyStringLiteralExpression> result = new ArrayList<PyStringLiteralExpression>();
        function.acceptChildren(new PyRecursiveElementVisitor(){

            @Override
            public void visitPyStringLiteralExpression(PyStringLiteralExpression node) {
                if (FlaskTemplateManager.isTemplateReference(node)) {
                    result.add(node);
                }
            }
        });
        return result;
    }

    public static List<PyStringLiteralExpression> findTemplateReferences(PsiFile element) {
        ArrayList<PyStringLiteralExpression> references2 = new ArrayList<PyStringLiteralExpression>();
        GlobalSearchScope scope = GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)GlobalSearchScope.projectScope((Project)element.getProject()), (FileType[])new FileType[]{PythonFileType.INSTANCE});
        ReferencesSearch.search((PsiElement)element, (SearchScope)scope).forEach(reference -> {
            PyStringLiteralExpression literal;
            if (reference.getElement() instanceof PyStringLiteralExpression && FlaskTemplateManager.isTemplateReference(literal = (PyStringLiteralExpression)reference.getElement())) {
                references2.add(literal);
            }
            return true;
        });
        return references2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "expectedCalleeName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "expectedCalleeFile";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/flask/codeInsight/FlaskTemplateManager";
        objectArray[2] = "isFirstCallArgument";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

