/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.flask.codeInsight;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.jetbrains.extensions.FQNamesProviderExtKt;
import com.jetbrains.flask.FlaskFQNamesProvider;
import com.jetbrains.flask.codeInsight.references.FlaskViewMethodReference;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyPsiFacade;
import com.jetbrains.python.psi.impl.PyKeywordArgumentProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FlaskKeywordArgumentProvider
implements PyKeywordArgumentProvider {
    @Override
    @NotNull
    public List<String> getKeywordArguments(PyFunction function, PyCallExpression callExpr) {
        PyClass aClass;
        if ("url_for".equals(function.getName()) && function.getContainingFile().getName().equals("helpers.py")) {
            List<String> list = FlaskKeywordArgumentProvider.getUrlForKeywordArguments(callExpr);
            if (list == null) {
                FlaskKeywordArgumentProvider.$$$reportNull$$$0(0);
            }
            return list;
        }
        if ("route".equals(function.getName()) && (aClass = function.getContainingClass()) != null && FQNamesProviderExtKt.isNameMatches(FlaskFQNamesProvider.FLASK_CLASS, aClass)) {
            List<String> list = FlaskKeywordArgumentProvider.getRouteKeywordArguments(function.getProject());
            if (list == null) {
                FlaskKeywordArgumentProvider.$$$reportNull$$$0(1);
            }
            return list;
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            FlaskKeywordArgumentProvider.$$$reportNull$$$0(2);
        }
        return list;
    }

    public static List<String> getRouteKeywordArguments(Project project) {
        PyFunction initMethod;
        PyClass ruleClass = PyPsiFacade.getInstance(project).findClass("werkzeug.routing.Rule");
        if (ruleClass != null && (initMethod = ruleClass.findMethodByName("__init__", false, null)) != null) {
            ArrayList<String> defaults = new ArrayList<String>();
            for (PyParameter parameter : initMethod.getParameterList().getParameters()) {
                if (parameter.getDefaultValue() == null) continue;
                defaults.add(parameter.getName());
            }
            return defaults;
        }
        return Collections.emptyList();
    }

    private static List<String> getUrlForKeywordArguments(PyCallExpression callExpr) {
        PyExpression[] arguments = callExpr.getArguments();
        if (arguments.length > 0) {
            PsiReference[] references2;
            for (PsiReference reference : references2 = arguments[0].getReferences()) {
                PsiElement result;
                if (!(reference instanceof FlaskViewMethodReference) || !((result = reference.resolve()) instanceof PyFunction)) continue;
                PyFunction viewFunction = (PyFunction)result;
                ArrayList<String> args2 = new ArrayList<String>();
                for (PyParameter parameter : viewFunction.getParameterList().getParameters()) {
                    if (!(parameter instanceof PyNamedParameter)) continue;
                    args2.add(parameter.getName());
                }
                return args2;
            }
        }
        return Collections.emptyList();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/flask/codeInsight/FlaskKeywordArgumentProvider", "getKeywordArguments"));
    }
}

