/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.util;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.jetbrains.django.DjangoFQNamesProvider;
import com.jetbrains.django.lang.template.DjangoTemplateFileViewProvider;
import com.jetbrains.django.lang.template.psi.impl.DjangoTagElementImpl;
import com.jetbrains.django.lang.template.tags.DjangoBlockTag;
import com.jetbrains.extensions.FQNamesProviderExtKt;
import com.jetbrains.extensions.python.PyCallExpressionExtKt;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonDialectsTokenSetProvider;
import com.jetbrains.python.nameResolver.NameResolverTools;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyAugAssignmentStatement;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyKeyValueExpression;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyQualifiedNameOwner;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PySequenceExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.PyResolveImportUtil;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DjangoPsiUtil {
    private static final String[] TYPICAL_SETTINGS_PY_ATTRIBUTES = new String[]{"INSTALLED_APPS", "TEMPLATES", "TEMPLATE_DIRS", "DATABASES"};

    private DjangoPsiUtil() {
    }

    public static PsiFile getFile(@NotNull PsiElement element) {
        PsiFile containingFile;
        if (element == null) {
            DjangoPsiUtil.$$$reportNull$$$0(0);
        }
        if ((containingFile = element.getContainingFile()) == null) {
            return element.getOriginalElement().getContainingFile();
        }
        return containingFile.getOriginalFile();
    }

    @Nullable
    public static PsiFile findFileInRoots(@NotNull String path, @NotNull PsiElement context) {
        QualifiedName qName;
        List<PsiElement> results;
        PsiFile file2;
        if (path == null) {
            DjangoPsiUtil.$$$reportNull$$$0(1);
        }
        if (context == null) {
            DjangoPsiUtil.$$$reportNull$$$0(2);
        }
        PsiFile psiFile = file2 = !(results = PyResolveImportUtil.resolveQualifiedName(qName = QualifiedName.fromDottedString((String)path), PyResolveImportUtil.fromFoothold(context))).isEmpty() ? PyUtil.as(results.get(0), PsiFile.class) : null;
        if (file2 != null && "__init__.py".equals(file2.getName()) && !"__init__.py".equals(qName.getLastComponent())) {
            file2 = null;
        }
        return file2;
    }

    @Nullable
    public static PsiFile findChild(PsiDirectory folder, String path) {
        List pathElements = StringUtil.split((String)path, (String)"/");
        for (int i = 0; i < pathElements.size(); ++i) {
            if (folder == null) {
                return null;
            }
            if (i >= pathElements.size() - 1) {
                return folder.findFile((String)pathElements.get(i));
            }
            folder = folder.findSubdirectory((String)pathElements.get(i));
        }
        return null;
    }

    @Nullable
    public static PsiDirectory findFolder(PsiDirectory folder, String path) {
        List pathElements = StringUtil.split((String)path, (String)"/");
        for (int i = 0; i < pathElements.size(); ++i) {
            if (folder == null) {
                return null;
            }
            if (i >= pathElements.size()) continue;
            folder = folder.findSubdirectory((String)pathElements.get(i));
        }
        return folder;
    }

    public static boolean isElementOfListAssignedTo(PsiElement element, String ... assignedTo) {
        String referencedName;
        PyAugAssignmentStatement statement;
        PyExpression target;
        if (assignedTo == null) {
            DjangoPsiUtil.$$$reportNull$$$0(3);
        }
        PyElement assignment = (PyElement)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PyAssignmentStatement.class, PyCallExpression.class, PyAugAssignmentStatement.class});
        Stream<String> stream = Arrays.stream(assignedTo);
        if (assignment instanceof PyAssignmentStatement) {
            PyAssignmentStatement assignmentStatement = (PyAssignmentStatement)assignment;
            PyExpression lhs = assignmentStatement.getLeftHandSideExpression();
            if (lhs instanceof PyTargetExpression && lhs.getName() != null && stream.anyMatch(o -> lhs.getName().matches((String)o))) {
                PyExpression assignedValue = assignmentStatement.getAssignedValue();
                return PsiTreeUtil.isAncestor((PsiElement)assignedValue, (PsiElement)element, (boolean)true) && PsiTreeUtil.getParentOfType((PsiElement)element, PySequenceExpression.class, (boolean)true, (Class[])new Class[]{PyAssignmentStatement.class}) != null;
            }
        } else if (assignment instanceof PyAugAssignmentStatement && (target = (statement = (PyAugAssignmentStatement)assignment).getTarget()) instanceof PyReferenceExpression && (referencedName = ((PyReferenceExpression)target).getReferencedName()) != null && stream.anyMatch(o -> referencedName.matches((String)o))) {
            return PsiTreeUtil.isAncestor((PsiElement)statement.getValue(), (PsiElement)element, (boolean)true) && PsiTreeUtil.getParentOfType((PsiElement)element, PySequenceExpression.class, (boolean)true, (Class[])new Class[]{PyAugAssignmentStatement.class}) != null;
        }
        return false;
    }

    public static boolean isElementOfListArgumentToCall(PsiElement element, String qualifier, String callName) {
        PyQualifiedExpression expr;
        PyCallExpression call;
        ASTNode elementNode = element.getNode();
        if (elementNode == null) {
            return false;
        }
        ASTNode node = elementNode.getTreeParent();
        if (node != null && node.getElementType() == PyElementTypes.TUPLE_EXPRESSION) {
            node = node.getTreeParent();
        }
        return node != null && (node.getElementType() == PyElementTypes.PARENTHESIZED_EXPRESSION || node.getElementType() == PyElementTypes.LIST_LITERAL_EXPRESSION) && (call = (PyCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PyCallExpression.class)) != null && call.getCallee() instanceof PyQualifiedExpression && (expr = (PyQualifiedExpression)call.getCallee()) != null && expr.getQualifier() != null && callName.equals(expr.getReferencedName()) && qualifier.equals(expr.getQualifier().getName());
    }

    public static boolean isAssignedTo(ASTNode node, String targetName) {
        ASTNode _node = node.getTreeParent();
        if (!(_node == null || _node.getElementType() != PyElementTypes.ASSIGNMENT_STATEMENT && _node.getElementType() != PyElementTypes.AUG_ASSIGNMENT_STATEMENT || (_node = _node.getFirstChildNode()).getElementType() != PyElementTypes.TARGET_EXPRESSION && !PythonDialectsTokenSetProvider.INSTANCE.getReferenceExpressionTokens().contains(_node.getElementType()))) {
            String name = _node.getFirstChildNode().getText();
            return name.matches(targetName);
        }
        return false;
    }

    public static boolean isSettingsPy(PsiElement element) {
        PyFile file2 = (PyFile)ObjectUtils.tryCast((Object)element.getContainingFile(), PyFile.class);
        if (file2 == null) {
            return false;
        }
        return Arrays.stream(TYPICAL_SETTINGS_PY_ATTRIBUTES).anyMatch(s -> !file2.multiResolveName((String)s).isEmpty());
    }

    public static PsiElementPattern.Capture<PsiElement> valueInsideDictPattern(String key, String dictName) {
        return (PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withParent((ElementPattern)PlatformPatterns.psiElement(PyStringLiteralExpression.class).withParent((ElementPattern)PlatformPatterns.psiElement(PyKeyValueExpression.class).withFirstChild((ElementPattern)PlatformPatterns.psiElement(PyStringLiteralExpression.class).withText((ElementPattern)StandardPatterns.string().contains(key)))))).inside((ElementPattern)PlatformPatterns.psiElement(PyAssignmentStatement.class).withFirstChild((ElementPattern)PlatformPatterns.psiElement(PyTargetExpression.class).withText(dictName)))).afterLeafSkipping((ElementPattern)PlatformPatterns.psiElement(PsiWhiteSpace.class), (ElementPattern)PlatformPatterns.psiElement((IElementType)PyTokenTypes.COLON));
    }

    public static boolean isTemplateResponseClass(PyClass cls) {
        return cls.isSubclass("django.views.generic.base.TemplateResponseMixin", null) || cls.isSubclass("django.forms.widgets.Widget", null);
    }

    public static boolean isWhitespace(IElementType tokenType1) {
        return tokenType1 == TokenType.WHITE_SPACE;
    }

    @Nullable
    public static PyCallExpression getUrlCall(PsiElement element) {
        PyCallExpression call = (PyCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PyCallExpression.class);
        if (call == null) {
            return null;
        }
        PyExpression callee = call.getCallee();
        if (callee == null) {
            return null;
        }
        String calleeName = callee.getName();
        if (calleeName == null) {
            return null;
        }
        if (NameResolverTools.isCalleeShortCut(call, DjangoFQNamesProvider.URL_OR_RE_PATH_FUNCTION)) {
            return call;
        }
        if (call.isCalleeText("include")) {
            return DjangoPsiUtil.getUrlCall((PsiElement)call);
        }
        return null;
    }

    @Nullable
    public static PyCallExpression getIncludeCall(PsiElement element) {
        PyCallExpression call = (PyCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PyCallExpression.class);
        if (call != null && DjangoPsiUtil.isIncludeCall(call)) {
            return call;
        }
        return null;
    }

    private static boolean isIncludeCall(@NotNull PyCallExpression call) {
        PyExpression callee;
        if (call == null) {
            DjangoPsiUtil.$$$reportNull$$$0(4);
        }
        if ((callee = call.getCallee()) == null) {
            return false;
        }
        if (!FQNamesProviderExtKt.shortNameMatches(DjangoFQNamesProvider.INCLUDE_FUNCTION, (NavigationItem)callee)) {
            return false;
        }
        return call.multiResolveCalleeFunction(PyResolveContext.defaultContext()).stream().map(PyQualifiedNameOwner::getQualifiedName).anyMatch(qName -> ArrayUtil.contains((String)qName, (String[])DjangoFQNamesProvider.INCLUDE_FUNCTION.getNames()));
    }

    @Nullable
    public static PyCallExpression getPatternCall(PsiElement element) {
        PyCallExpression call = (PyCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PyCallExpression.class);
        if (call != null) {
            if (DjangoPsiUtil.isPatternsCall(call)) {
                return call;
            }
            if (PyCallExpressionExtKt.isCalleeName(call, DjangoFQNamesProvider.URL_OR_RE_PATH_FUNCTION) || call.isCalleeText("include")) {
                return DjangoPsiUtil.getPatternCall((PsiElement)call);
            }
        }
        return null;
    }

    public static boolean isPatternsCall(@NotNull PyCallExpression call) {
        if (call == null) {
            DjangoPsiUtil.$$$reportNull$$$0(5);
        }
        return PyCallExpressionExtKt.isCalleeName(call, DjangoFQNamesProvider.URL_PATTERNS_FUNCTION);
    }

    @Nullable
    public static PyTupleExpression getTuple(PsiElement element) {
        PyTupleExpression tuple = (PyTupleExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PyTupleExpression.class);
        if (tuple != null) {
            return tuple;
        }
        return null;
    }

    @Nullable
    public static PsiElement findContainingElementInBaseLanguage(PsiElement element) {
        DjangoTemplateFileViewProvider vProvider;
        PsiFile psi;
        if (element.getContainingFile().getViewProvider() instanceof DjangoTemplateFileViewProvider && (psi = (vProvider = (DjangoTemplateFileViewProvider)element.getContainingFile().getViewProvider()).getPsi(vProvider.getBaseLanguage())) != null) {
            return vProvider.findElementAt(element.getTextRange().getStartOffset(), vProvider.getBaseLanguage());
        }
        return null;
    }

    @Nullable
    public static PsiElement findContainingElementInTemplateDataLanguage(PsiElement element) {
        DjangoTemplateFileViewProvider vProvider;
        PsiFile psi;
        if (element.getContainingFile().getViewProvider() instanceof DjangoTemplateFileViewProvider && (psi = (vProvider = (DjangoTemplateFileViewProvider)element.getContainingFile().getViewProvider()).getPsi(vProvider.getTemplateDataLanguage())) != null) {
            return vProvider.findElementAt(element.getTextRange().getStartOffset(), vProvider.getTemplateDataLanguage());
        }
        return null;
    }

    public static DjangoBlockTag findOpeningBlock(PsiElement tag) {
        while (tag != null) {
            DjangoBlockTag block;
            if (PsiTreeUtil.getParentOfType((PsiElement)tag, DjangoTagElementImpl.class) != null) {
                tag = PsiTreeUtil.getParentOfType((PsiElement)tag, DjangoTagElementImpl.class);
            }
            if (tag instanceof DjangoTagElementImpl && (block = (DjangoBlockTag)PsiTreeUtil.getChildOfType((PsiElement)tag, DjangoBlockTag.class)) != null) {
                return block;
            }
            tag = tag.getPrevSibling();
        }
        return null;
    }

    @Nullable
    public static PsiElement prevFromTag(PsiElement el) {
        DjangoTagElementImpl element = (DjangoTagElementImpl)PsiTreeUtil.getParentOfType((PsiElement)el, DjangoTagElementImpl.class);
        if (element != null) {
            return element.getPrevSibling();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignedTo";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/django/util/DjangoPsiUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getFile";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findFileInRoots";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isElementOfListAssignedTo";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isIncludeCall";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isPatternsCall";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

