/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.testRunner;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.Location;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.WriteExternalException;
import com.jetbrains.django.DjangoRunnerUtilsKt;
import com.jetbrains.django.facet.DjangoFacet;
import com.jetbrains.django.testRunner.DjangoTestUtil;
import com.jetbrains.django.testRunner.DjangoTestsCommandLineState;
import com.jetbrains.django.testRunner.DjangoTestsConfigurationEditor;
import com.jetbrains.django.util.DjangoUtil;
import com.jetbrains.python.testing.AbstractPythonTestRunConfiguration;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class DjangoTestsRunConfiguration
extends AbstractPythonTestRunConfiguration<DjangoTestsRunConfiguration> {
    private String myTarget;
    private String mySettingsFile;
    private boolean useCustomSettings;
    private boolean useOptions;
    private String myOptions;
    @NonNls
    private static final String TARGET_FIELD = "TARGET";
    @NonNls
    private static final String SETTINGS_FILE_FIELD = "SETTINGS_FILE";
    @NonNls
    private static final String CUSTOM_SETTINGS = "CUSTOM_SETTINGS";
    @NonNls
    private static final String OPTIONS = "OPTIONS";
    @NonNls
    private static final String USE_OPTIONS = "USE_OPTIONS";

    public String getDjangoOptions() {
        return this.myOptions;
    }

    public void setDjangoOptions(String options) {
        this.myOptions = options;
    }

    public DjangoTestsRunConfiguration(Project project, ConfigurationFactory factory) {
        super(project, factory);
        this.setUnbufferedEnv();
    }

    @Override
    protected SettingsEditor<DjangoTestsRunConfiguration> createConfigurationEditor() {
        return new DjangoTestsConfigurationEditor(this);
    }

    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        Module module;
        if (executor == null) {
            DjangoTestsRunConfiguration.$$$reportNull$$$0(0);
        }
        if (env == null) {
            DjangoTestsRunConfiguration.$$$reportNull$$$0(1);
        }
        if ((module = this.getModule()) == null) {
            throw new ExecutionException("No module provided");
        }
        if (this.useCustomSettings() && DjangoUtil.getCustomTestSettingsFile(module, this) == null) {
            throw new ExecutionException(String.format("Custom settings enabled but can't resolve %s", this.mySettingsFile));
        }
        return new DjangoTestsCommandLineState(this, env);
    }

    public boolean isUseOptions() {
        return this.useOptions;
    }

    public void setUseOptions(boolean useOptions) {
        this.useOptions = useOptions;
    }

    @Override
    public void checkConfiguration() throws RuntimeConfigurationException {
        Module module = this.getConfigurationModule().getModule();
        if (module == null || !DjangoFacet.isPresent(module)) {
            DjangoRunnerUtilsKt.reportNoDjangoOnModule(this.getProject());
            return;
        }
        if (!DjangoUtil.isDjangoAvailable(module, this.getInterpreterPath())) {
            throw new RuntimeConfigurationError("Django is not importable in this environment");
        }
    }

    @Override
    public void readExternal(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            DjangoTestsRunConfiguration.$$$reportNull$$$0(2);
        }
        super.readExternal(element);
        this.myTarget = JDOMExternalizerUtil.readField((Element)element, (String)TARGET_FIELD);
        this.mySettingsFile = JDOMExternalizerUtil.readField((Element)element, (String)SETTINGS_FILE_FIELD);
        this.useCustomSettings = Boolean.parseBoolean(JDOMExternalizerUtil.readField((Element)element, (String)CUSTOM_SETTINGS));
        this.myOptions = JDOMExternalizerUtil.readField((Element)element, (String)OPTIONS);
        this.useOptions = Boolean.parseBoolean(JDOMExternalizerUtil.readField((Element)element, (String)USE_OPTIONS));
    }

    @Override
    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            DjangoTestsRunConfiguration.$$$reportNull$$$0(3);
        }
        super.writeExternal(element);
        JDOMExternalizerUtil.writeField((Element)element, (String)TARGET_FIELD, (String)this.myTarget);
        JDOMExternalizerUtil.writeField((Element)element, (String)SETTINGS_FILE_FIELD, (String)this.mySettingsFile);
        JDOMExternalizerUtil.writeField((Element)element, (String)CUSTOM_SETTINGS, (String)String.valueOf(this.useCustomSettings));
        JDOMExternalizerUtil.writeField((Element)element, (String)USE_OPTIONS, (String)String.valueOf(this.useOptions));
        JDOMExternalizerUtil.writeField((Element)element, (String)OPTIONS, (String)this.myOptions);
    }

    public boolean useCustomSettings() {
        return this.useCustomSettings;
    }

    public void useCustomSettings(boolean useCustomSettings) {
        this.useCustomSettings = useCustomSettings;
    }

    public String getTarget() {
        return this.myTarget;
    }

    public void setTarget(String target) {
        this.myTarget = target;
    }

    public String getSettingsFile() {
        return this.mySettingsFile;
    }

    public void setSettingsFile(String settingsFile) {
        this.mySettingsFile = settingsFile;
    }

    @Override
    public String getTestSpec(@NotNull Location<?> location, @NotNull AbstractTestProxy failedTest) {
        if (location == null) {
            DjangoTestsRunConfiguration.$$$reportNull$$$0(4);
        }
        if (failedTest == null) {
            DjangoTestsRunConfiguration.$$$reportNull$$$0(5);
        }
        Module module = location.getModule();
        String appName = DjangoTestUtil.getAppNameForLocation(module, location.getPsiElement());
        return DjangoTestUtil.buildTargetFromLocation(module, appName, location.getPsiElement());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "failedTest";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/django/testRunner/DjangoTestsRunConfiguration";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getState";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "readExternal";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "writeExternal";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getTestSpec";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

