/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.refactoring;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.django.model.TemplateParametersEvaluator;
import com.jetbrains.django.util.PythonDataflowUtil;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyDictLiteralExpression;
import com.jetbrains.python.psi.PyKeyValueExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.impl.PyStringLiteralExpressionImpl;
import com.jetbrains.python.psi.impl.PyStringLiteralExpressionManipulator;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenameDjangoParameterProcessor
extends RenamePsiElementProcessor {
    private final PyStringLiteralExpressionManipulator manipulator = new PyStringLiteralExpressionManipulator();

    public boolean canProcessElement(@NotNull PsiElement element) {
        if (element == null) {
            RenameDjangoParameterProcessor.$$$reportNull$$$0(0);
        }
        return RenameDjangoParameterProcessor.isDjangoTemplateParameter(element);
    }

    public void renameElement(@NotNull PsiElement element, @NotNull String newName, UsageInfo @NotNull [] usages, RefactoringElementListener listener2) throws IncorrectOperationException {
        if (element == null) {
            RenameDjangoParameterProcessor.$$$reportNull$$$0(1);
        }
        if (newName == null) {
            RenameDjangoParameterProcessor.$$$reportNull$$$0(2);
        }
        if (usages == null) {
            RenameDjangoParameterProcessor.$$$reportNull$$$0(3);
        }
        PyStringLiteralExpressionImpl e = (PyStringLiteralExpressionImpl)element;
        PsiElement newEl = e.replace(this.manipulator.handleContentChange(e, newName));
        for (UsageInfo usage : usages) {
            RenameUtil.rename((UsageInfo)usage, (String)newName);
        }
        if (listener2 != null) {
            listener2.elementRenamed(newEl);
        }
    }

    public static boolean isDjangoTemplateParameter(PsiElement element) {
        return RenameDjangoParameterProcessor.getRenderCall(element) != null || RenameDjangoParameterProcessor.isContextObjectName(element);
    }

    private static boolean isContextObjectName(PsiElement element) {
        PyAssignmentStatement assignmentStatement;
        return element instanceof PyStringLiteralExpression && (assignmentStatement = (PyAssignmentStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PyAssignmentStatement.class)) != null && assignmentStatement.isAssignmentTo("context_object_name") && element == assignmentStatement.getAssignedValue();
    }

    @Nullable
    public static PyCallExpression getRenderCall(PsiElement element) {
        if (element instanceof PyStringLiteralExpression && element.getParent() instanceof PyKeyValueExpression && element.getParent().getParent() instanceof PyDictLiteralExpression) {
            Set<PyCallExpression> calls = PythonDataflowUtil.getCalls((PyDictLiteralExpression)element.getParent().getParent());
            for (PyCallExpression call : calls) {
                if (!TemplateParametersEvaluator.isRenderMethod(call)) continue;
                return call;
            }
        }
        return null;
    }

    public boolean forcesShowPreview() {
        return true;
    }

    public boolean isToSearchInComments(@NotNull PsiElement element) {
        if (element == null) {
            RenameDjangoParameterProcessor.$$$reportNull$$$0(4);
        }
        return false;
    }

    public void setToSearchInComments(@NotNull PsiElement element, boolean enabled) {
        if (element == null) {
            RenameDjangoParameterProcessor.$$$reportNull$$$0(5);
        }
    }

    public boolean isToSearchForTextOccurrences(@NotNull PsiElement element) {
        if (element == null) {
            RenameDjangoParameterProcessor.$$$reportNull$$$0(6);
        }
        return false;
    }

    public void setToSearchForTextOccurrences(@NotNull PsiElement element, boolean enabled) {
        if (element == null) {
            RenameDjangoParameterProcessor.$$$reportNull$$$0(7);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/django/refactoring/RenameDjangoParameterProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canProcessElement";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "renameElement";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isToSearchInComments";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "setToSearchInComments";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isToSearchForTextOccurrences";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "setToSearchForTextOccurrences";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

