/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.ref;

import com.google.common.collect.Lists;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.django.lang.template.psi.impl.DjangoBlockNameImpl;
import com.jetbrains.django.lang.template.psi.impl.DjangoTagElementImpl;
import com.jetbrains.python.BaseReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DjangoBlockNameReference
extends BaseReference {
    public DjangoBlockNameReference(@NotNull PsiElement element) {
        if (element == null) {
            DjangoBlockNameReference.$$$reportNull$$$0(0);
        }
        super(element);
    }

    public PsiElement resolve() {
        FindOpenBlockProcessor processor2 = new FindOpenBlockProcessor(this.getElement().getText());
        DjangoBlockNameReference.processPrecedingBlockTags(this.getElement(), processor2);
        if (processor2.getOpenBlock() != null) {
            return PsiTreeUtil.findChildOfType((PsiElement)processor2.getOpenBlock(), DjangoBlockNameImpl.class);
        }
        return processor2.getOpenBlock();
    }

    public Object @NotNull [] getVariants() {
        FindPrecedingBlocksProcessor processor2 = new FindPrecedingBlocksProcessor();
        DjangoBlockNameReference.processPrecedingBlockTags(this.getElement(), processor2);
        ArrayList result = Lists.newArrayList();
        for (DjangoBlockNameImpl tag : processor2.getOpenBlocks()) {
            result.add(LookupElementBuilder.create((String)tag.getName()));
        }
        Object[] objectArray = result.toArray();
        if (objectArray == null) {
            DjangoBlockNameReference.$$$reportNull$$$0(1);
        }
        return objectArray;
    }

    public static void processPrecedingBlockTags(PsiElement element, BlockProcessor blockProcessor) {
        DjangoTagElementImpl parent = (DjangoTagElementImpl)PsiTreeUtil.getParentOfType((PsiElement)element, DjangoTagElementImpl.class);
        while ((parent = (DjangoTagElementImpl)PsiTreeUtil.getPrevSiblingOfType((PsiElement)parent, DjangoTagElementImpl.class)) == null || !(!"block".equals(parent.getName()) ? "endblock".equals(parent.getName()) && !blockProcessor.endBlock(parent) : !blockProcessor.block(parent))) {
            if (parent != null) continue;
        }
    }

    @Nullable
    public String getOpenBlockCandidateName() {
        DjangoBlockNameImpl blockName;
        FindMatchingOpenBlock processor2 = new FindMatchingOpenBlock();
        DjangoBlockNameReference.processPrecedingBlockTags(this.getElement(), processor2);
        if (processor2.getMatchingOpenBlock() != null && (blockName = (DjangoBlockNameImpl)PsiTreeUtil.findChildOfType((PsiElement)processor2.getMatchingOpenBlock(), DjangoBlockNameImpl.class)) != null) {
            return blockName.getName();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/django/ref/DjangoBlockNameReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/django/ref/DjangoBlockNameReference";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FindOpenBlockProcessor
    implements BlockProcessor {
        private final String name;
        private DjangoTagElementImpl openBlock;

        private FindOpenBlockProcessor(@NotNull String name) {
            if (name == null) {
                FindOpenBlockProcessor.$$$reportNull$$$0(0);
            }
            this.openBlock = null;
            this.name = name;
        }

        @Nullable
        public DjangoTagElementImpl getOpenBlock() {
            return this.openBlock;
        }

        @Override
        public boolean block(DjangoTagElementImpl block) {
            DjangoBlockNameImpl blockName = (DjangoBlockNameImpl)PsiTreeUtil.findChildOfType((PsiElement)block, DjangoBlockNameImpl.class);
            if (blockName != null && this.name.equals(blockName.getName())) {
                this.openBlock = block;
                return false;
            }
            return true;
        }

        @Override
        public boolean endBlock(DjangoTagElementImpl endBlock) {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/django/ref/DjangoBlockNameReference$FindOpenBlockProcessor", "<init>"));
        }
    }

    private static class FindMatchingOpenBlock
    extends FindPrecedingBlocksProcessor {
        private DjangoTagElementImpl myOpenBlock = null;

        private FindMatchingOpenBlock() {
        }

        @Override
        protected boolean foundNotMatchingBlock(DjangoTagElementImpl block) {
            this.myOpenBlock = block;
            return false;
        }

        public DjangoTagElementImpl getMatchingOpenBlock() {
            return this.myOpenBlock;
        }
    }

    private static class FindPrecedingBlocksProcessor
    implements BlockProcessor {
        private final Stack<DjangoTagElementImpl> closeTags = new Stack();
        private final List<DjangoBlockNameImpl> openBlocks = Lists.newArrayList();

        private FindPrecedingBlocksProcessor() {
        }

        @Override
        public boolean block(DjangoTagElementImpl block) {
            if (this.closeTags.empty()) {
                return this.foundNotMatchingBlock(block);
            }
            this.closeTags.pop();
            return true;
        }

        protected boolean foundNotMatchingBlock(DjangoTagElementImpl block) {
            DjangoBlockNameImpl blockName = (DjangoBlockNameImpl)PsiTreeUtil.findChildOfType((PsiElement)block, DjangoBlockNameImpl.class);
            if (blockName != null) {
                this.openBlocks.add(blockName);
            }
            return true;
        }

        @Override
        public boolean endBlock(DjangoTagElementImpl endBlock) {
            this.closeTags.push(endBlock);
            return true;
        }

        public List<DjangoBlockNameImpl> getOpenBlocks() {
            return this.openBlocks;
        }
    }

    private static interface BlockProcessor {
        public boolean block(DjangoTagElementImpl var1);

        public boolean endBlock(DjangoTagElementImpl var1);
    }
}

