/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.model.applications;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.QualifiedName;
import com.jetbrains.django.model.applications.DjangoUnnamedApplicationModel;
import com.jetbrains.django.model.modelApi.DjangoModelApi;
import com.jetbrains.django.model.modelApi.NoSuchApplicationException;
import com.jetbrains.django.util.DjangoUtil;
import com.jetbrains.extensions.ModuleBasedContextAnchor;
import com.jetbrains.extensions.QNameResolveContext;
import com.jetbrains.extensions.QualifiedNameExtKt;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@NonNls
public final class DjangoApplicationModel
extends DjangoUnnamedApplicationModel {
    @NotNull
    private final String myName;

    public DjangoApplicationModel(@NotNull String name, @NotNull Module djangoModule, @NotNull VirtualFile djangoProjectRoot) throws NoSuchApplicationException {
        if (name == null) {
            DjangoApplicationModel.$$$reportNull$$$0(0);
        }
        if (djangoModule == null) {
            DjangoApplicationModel.$$$reportNull$$$0(1);
        }
        if (djangoProjectRoot == null) {
            DjangoApplicationModel.$$$reportNull$$$0(2);
        }
        super(DjangoApplicationModel.getAppDirectoryByName(name, djangoModule, djangoProjectRoot));
        this.myName = name;
    }

    @NotNull
    public static List<VirtualFile> getFoldersUnderEachApp(@NotNull String folderName, @NotNull DjangoModelApi djangoModelApi) {
        if (folderName == null) {
            DjangoApplicationModel.$$$reportNull$$$0(3);
        }
        if (djangoModelApi == null) {
            DjangoApplicationModel.$$$reportNull$$$0(4);
        }
        ArrayList<VirtualFile> folders = new ArrayList<VirtualFile>();
        for (DjangoApplicationModel application : djangoModelApi.getApplications()) {
            VirtualFile folder = application.myApplicationRootFolder.getVirtualFile().findChild(folderName);
            if (folder == null) continue;
            folders.add(folder);
        }
        ArrayList<VirtualFile> arrayList = folders;
        if (arrayList == null) {
            DjangoApplicationModel.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            DjangoApplicationModel.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public String getLabel() {
        String string = DjangoUtil.getAppLabelByName(this.myName);
        if (string == null) {
            DjangoApplicationModel.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    private static PsiDirectory getAppDirectoryByName(@NotNull String name, @NotNull Module djangoModule, @NotNull VirtualFile djangoProjectRoot) throws NoSuchApplicationException {
        PsiFile file2;
        if (name == null) {
            DjangoApplicationModel.$$$reportNull$$$0(8);
        }
        if (djangoModule == null) {
            DjangoApplicationModel.$$$reportNull$$$0(9);
        }
        if (djangoProjectRoot == null) {
            DjangoApplicationModel.$$$reportNull$$$0(10);
        }
        TypeEvalContext evalContext = TypeEvalContext.codeAnalysis(djangoModule.getProject(), null);
        QualifiedName qName = QualifiedName.fromDottedString((String)name);
        QNameResolveContext context = new QNameResolveContext(new ModuleBasedContextAnchor(djangoModule), null, evalContext, djangoProjectRoot, false);
        PsiElement element = QualifiedNameExtKt.resolveToElement(qName, context, false);
        PsiDirectory dir = null;
        if (element instanceof PyFile) {
            dir = ((PsiFile)element).getParent();
        } else if (element instanceof PsiDirectory) {
            dir = (PsiDirectory)element;
        } else if (element instanceof PyElement && (file2 = element.getContainingFile()) != null) {
            dir = file2.getParent();
        }
        if (dir == null) {
            throw new NoSuchApplicationException("No application named " + name);
        }
        PsiDirectory psiDirectory = dir;
        if (psiDirectory == null) {
            DjangoApplicationModel.$$$reportNull$$$0(11);
        }
        return psiDirectory;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "djangoModule";
                break;
            }
            case 2: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "djangoProjectRoot";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folderName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "djangoModelApi";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/django/model/applications/DjangoApplicationModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/django/model/applications/DjangoApplicationModel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFoldersUnderEachApp";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getLabel";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getAppDirectoryByName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getFoldersUnderEachApp";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 11: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getAppDirectoryByName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

