/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.model;

import com.google.common.collect.Sets;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.django.codeInsight.DjangoSettingsPy;
import com.jetbrains.django.facet.DjangoFacet;
import com.jetbrains.django.facet.DjangoFacetConfiguration;
import com.jetbrains.django.facet.DjangoFacetType;
import com.jetbrains.django.facet.DjangoWizardSettingsHolder;
import com.jetbrains.django.lang.template.DjangoTemplateLanguage;
import com.jetbrains.django.templateFSLoader.PyDjangoTemplateFSLoader;
import com.jetbrains.django.ui.DjangoBundle;
import com.jetbrains.django.util.VirtualFileUtil;
import com.jetbrains.jinja2.Jinja2Language;
import com.jetbrains.mako.MakoLanguage;
import com.jetbrains.pyramid.templates.ChameleonLanguage;
import com.jetbrains.python.PythonFunctionParameters;
import com.jetbrains.python.PythonHelpersLocator;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyQualifiedNameOwner;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyEvaluator;
import com.jetbrains.python.psi.resolve.PyResolveImportUtil;
import com.jetbrains.python.run.PythonTask;
import com.jetbrains.python.sdk.PyRemoteSdkWithoutSudo;
import com.jetbrains.python.templateLanguages.PythonTemplateLanguage;
import com.jetbrains.python.templateLanguages.TemplatesService;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DjangoProjectCreatorAndConfigurator {
    private static final Map<PythonTemplateLanguage, String> LANGUAGE_TRACKS = new HashMap<PythonTemplateLanguage, String>();

    private DjangoProjectCreatorAndConfigurator() {
    }

    public static void createProject(@NotNull VirtualFile contentRoot, @Nullable Sdk sdk, @NotNull DjangoWizardSettingsHolder settings, @NotNull Module module, @Nullable Consumer<Consumer<Boolean>> syncCallBack) throws ExecutionException {
        if (contentRoot == null) {
            DjangoProjectCreatorAndConfigurator.$$$reportNull$$$0(0);
        }
        if (settings == null) {
            DjangoProjectCreatorAndConfigurator.$$$reportNull$$$0(1);
        }
        if (module == null) {
            DjangoProjectCreatorAndConfigurator.$$$reportNull$$$0(2);
        }
        assert (!ApplicationManager.getApplication().isWriteAccessAllowed()) : "This method can't run under write action";
        Sdk projectCreationSdk = PyRemoteSdkWithoutSudo.wrapNullable(sdk);
        PythonTask generateProjectTask = new PythonTask(module, "Generate", projectCreationSdk);
        generateProjectTask.setRunnerScript(PythonHelpersLocator.getHelperPath("pycharm/_jb_django_project_creator.py"));
        String projectDir = contentRoot.getCanonicalPath();
        List<String> parameters = Arrays.asList(settings.getProjectName(), projectDir);
        assert (!parameters.contains(null)) : "Null parameter";
        generateProjectTask.setParameters(parameters);
        generateProjectTask.runNoConsole();
        contentRoot.refresh(false, true);
        String applicationName = settings.getApplicationName();
        if (!StringUtil.isEmpty((String)applicationName)) {
            PythonTask createApplicationTask = new PythonTask(module, "Creating application", projectCreationSdk);
            createApplicationTask.setRunnerScript("manage.py");
            createApplicationTask.setWorkingDirectory(projectDir);
            createApplicationTask.setParameters(Arrays.asList("startapp", applicationName));
            createApplicationTask.runNoConsole();
            contentRoot.refresh(false, true);
        }
        if (projectCreationSdk != null) {
            ApplicationManager.getApplication().invokeAndWait(() -> ApplicationManager.getApplication().runWriteAction(() -> {
                ModifiableRootModel model = ModuleRootManager.getInstance((Module)module).getModifiableModel();
                model.setSdk(projectCreationSdk);
                model.commit();
            }));
        }
        if (syncCallBack == null) {
            DumbService.getInstance((Project)module.getProject()).runWhenSmart(() -> DjangoProjectCreatorAndConfigurator.configureSettingsAndFacet(module, contentRoot, settings, applicationName));
            return;
        }
        syncCallBack.accept(success -> {
            if (success.booleanValue()) {
                DumbService.getInstance((Project)module.getProject()).runWhenSmart(() -> DjangoProjectCreatorAndConfigurator.configureSettingsAndFacet(module, contentRoot, settings, applicationName));
            } else {
                Messages.showWarningDialog((Project)module.getProject(), (String)DjangoBundle.message("django.remote.project.not.synchronized", new Object[0]), (String)DjangoBundle.message("django.cant.patch.created.project", new Object[0]));
            }
        });
    }

    private static void configureTemplates(@NotNull Module module, @NotNull VirtualFile contentRoot, @NotNull DjangoWizardSettingsHolder settings, @NotNull VirtualFile settingsFile) {
        if (module == null) {
            DjangoProjectCreatorAndConfigurator.$$$reportNull$$$0(3);
        }
        if (contentRoot == null) {
            DjangoProjectCreatorAndConfigurator.$$$reportNull$$$0(4);
        }
        if (settings == null) {
            DjangoProjectCreatorAndConfigurator.$$$reportNull$$$0(5);
        }
        if (settingsFile == null) {
            DjangoProjectCreatorAndConfigurator.$$$reportNull$$$0(6);
        }
        TemplatesService service = TemplatesService.getInstance(module);
        service.generateTemplates(settings, contentRoot);
        ApplicationManager.getApplication().assertIsDispatchThread();
        String templatesFolderPath = settings.getTemplatesFolder();
        try {
            if (!StringUtil.isEmptyOrSpaces((String)templatesFolderPath)) {
                VirtualFile templatesFolder;
                File templatesFolderPathFile = new File(templatesFolderPath);
                if (!templatesFolderPathFile.isAbsolute()) {
                    templatesFolderPathFile = new File(contentRoot.getPath(), templatesFolderPath);
                }
                if ((templatesFolder = VfsUtil.createDirectoryIfMissing((String)(templatesFolderPath = templatesFolderPathFile.getAbsolutePath()))) == null) {
                    DjangoProjectCreatorAndConfigurator.createTemplatesFolderError(templatesFolderPath);
                    return;
                }
                DjangoProjectCreatorAndConfigurator.setTemplatesFolderInSettings(contentRoot.getPath(), module.getProject(), templatesFolder, settingsFile);
            }
        }
        catch (IOException e) {
            DjangoProjectCreatorAndConfigurator.createTemplatesFolderError(templatesFolderPath);
        }
        contentRoot.refresh(false, true);
        String templateLanguage = settings.getTemplateLanguage();
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        PyFile settingsPy = DjangoSettingsPy.getSettingsFile(module);
        if (settingsPy != null && templateLanguage != null) {
            PyDjangoTemplateFSLoader templatesLoader = PyDjangoTemplateFSLoader.getForSettings(settingsPy);
            PsiDocumentManager.getInstance((Project)module.getProject()).commitAllDocuments();
            templatesLoader.setLanguage(templateLanguage);
        }
        String middleware = null;
        if ("Mako".equals(templateLanguage)) {
            middleware = "djangomako.middleware.MakoMiddleware";
        }
        settingsFile.refresh(false, false);
        Document document = fileDocumentManager.getDocument(settingsFile);
        if (document == null) {
            return;
        }
        boolean doneMiddleware = false;
        boolean inMiddleware = false;
        for (int line2 = 0; line2 < document.getLineCount(); ++line2) {
            int lineStart = document.getLineStartOffset(line2);
            int lineEnd = document.getLineEndOffset(line2);
            String lineText = document.getCharsSequence().subSequence(lineStart, lineEnd).toString();
            if (lineText.startsWith("MIDDLEWARE_CLASSES =")) {
                inMiddleware = true;
            }
            if (!inMiddleware || doneMiddleware || !lineText.startsWith("]") || StringUtil.isEmptyOrSpaces((String)middleware)) continue;
            document.insertString(lineStart, (CharSequence)("    '" + middleware + "',\n"));
            doneMiddleware = true;
        }
    }

    private static void configureSettingsAndFacet(@NotNull Module module, @NotNull VirtualFile projectRoot, @NotNull DjangoWizardSettingsHolder settingsHolder, @Nullable String appName) {
        VirtualFile root;
        VirtualFile urlsFile;
        if (module == null) {
            DjangoProjectCreatorAndConfigurator.$$$reportNull$$$0(7);
        }
        if (projectRoot == null) {
            DjangoProjectCreatorAndConfigurator.$$$reportNull$$$0(8);
        }
        if (settingsHolder == null) {
            DjangoProjectCreatorAndConfigurator.$$$reportNull$$$0(9);
        }
        Application application = ApplicationManager.getApplication();
        assert (application.isDispatchThread()) : "To be called on AWT only";
        assert (!DumbService.getInstance((Project)module.getProject()).isDumb()) : "Can only be called under smart mode";
        boolean enableAdmin = settingsHolder.isEnableAdmin();
        Project project = module.getProject();
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        VirtualFile settingsFile = DjangoProjectCreatorAndConfigurator.findSettings(projectRoot, project);
        if (settingsFile != null) {
            settingsFile.refresh(false, true);
            Document settings = fileDocumentManager.getDocument(settingsFile);
            if (settings != null) {
                HashSet<String> appsToAdd = new HashSet<String>();
                if (appName != null) {
                    String fullAppName = DjangoProjectCreatorAndConfigurator.getFullAppName(appName, module);
                    appsToAdd.add(fullAppName != null ? fullAppName : appName);
                }
                WriteCommandAction.writeCommandAction((Project)project).run(() -> DjangoProjectCreatorAndConfigurator.modifyInstalledApps(settings, appsToAdd, Sets.newHashSet((Object[])new String[]{!enableAdmin ? "django.contrib.admin" : null})));
                fileDocumentManager.saveDocument(settings);
            }
        }
        if (!enableAdmin && (urlsFile = (root = settingsFile != null ? settingsFile.getParent() : projectRoot).findChild("urls.py")) != null) {
            urlsFile.refresh(false, false);
            Document urls = fileDocumentManager.getDocument(urlsFile);
            if (urls != null) {
                DjangoProjectCreatorAndConfigurator.commentAdminUrls(urls, project);
                fileDocumentManager.saveDocument(urls);
            }
        }
        DjangoProjectCreatorAndConfigurator.configureDjangoFacet(module, projectRoot);
        if (settingsFile != null) {
            DjangoProjectCreatorAndConfigurator.configureTemplates(module, projectRoot, settingsHolder, settingsFile);
        }
        fileDocumentManager.saveAllDocuments();
    }

    @Nullable
    private static String getFullAppName(@NotNull String appName, @NotNull Module module) {
        List<PsiElement> apps;
        PyFile appsPy;
        if (appName == null) {
            DjangoProjectCreatorAndConfigurator.$$$reportNull$$$0(10);
        }
        if (module == null) {
            DjangoProjectCreatorAndConfigurator.$$$reportNull$$$0(11);
        }
        if ((appsPy = PyUtil.as(ContainerUtil.getFirstItem(apps = PyResolveImportUtil.resolveQualifiedName(QualifiedName.fromComponents((String[])new String[]{appName, "apps"}), PyResolveImportUtil.fromModule(module))), PyFile.class)) == null) {
            return null;
        }
        return appsPy.getTopLevelClasses().stream().findFirst().map(PyQualifiedNameOwner::getQualifiedName).orElse(null);
    }

    @Nullable
    private static VirtualFile findSettings(@NotNull VirtualFile projectRoot, @NotNull Project project) {
        VirtualFile website;
        VirtualFile settingsFile;
        if (projectRoot == null) {
            DjangoProjectCreatorAndConfigurator.$$$reportNull$$$0(12);
        }
        if (project == null) {
            DjangoProjectCreatorAndConfigurator.$$$reportNull$$$0(13);
        }
        if ((settingsFile = DjangoProjectCreatorAndConfigurator.fetchSettingsFromManagePy(project, projectRoot)) != null) {
            return settingsFile;
        }
        settingsFile = projectRoot.findChild("settings.py");
        if (settingsFile == null && (website = projectRoot.findChild(projectRoot.getName())) != null) {
            settingsFile = website.findChild("settings.py");
        }
        return settingsFile;
    }

    public static void configureDjangoFacet(@NotNull Module module, @NotNull VirtualFile baseDir) {
        DjangoFacet facet;
        if (module == null) {
            DjangoProjectCreatorAndConfigurator.$$$reportNull$$$0(14);
        }
        if (baseDir == null) {
            DjangoProjectCreatorAndConfigurator.$$$reportNull$$$0(15);
        }
        if ((facet = DjangoFacet.getInstance(module)) == null) {
            DjangoFacetConfiguration configuration = DjangoFacetType.createDefaultConfiguration(module.getProject());
            DjangoFacetType.createDjangoFacet(module, configuration);
        }
        if ((facet = DjangoFacet.getInstance(module)) != null) {
            VirtualFile managePy;
            VirtualFile settings = DjangoProjectCreatorAndConfigurator.findSettings(baseDir, module.getProject());
            if (settings != null) {
                ((DjangoFacetConfiguration)facet.getConfiguration()).setSettingsFilePath(VirtualFileUtil.getRelativePath(baseDir, settings));
            }
            if (((DjangoFacetConfiguration)facet.getConfiguration()).getProjectRootPath() == null) {
                ((DjangoFacetConfiguration)facet.getConfiguration()).setProjectRootFolderFile(baseDir);
            }
            if ((managePy = baseDir.findChild("manage.py")) != null) {
                ((DjangoFacetConfiguration)facet.getConfiguration()).setManageFilePath(managePy.getPath());
            }
        }
        TemplatesService templatesService = TemplatesService.getInstance(module);
        PyFile settingsFile = DjangoSettingsPy.getSettingsFile(module);
        if (settingsFile != null) {
            templatesService.setTemplateLanguage(DjangoProjectCreatorAndConfigurator.chooseTemplateLanguage(settingsFile).getTemplateLanguageName());
        }
    }

    @NotNull
    private static PythonTemplateLanguage chooseTemplateLanguage(@NotNull PyFile settingsFile) {
        if (settingsFile == null) {
            DjangoProjectCreatorAndConfigurator.$$$reportNull$$$0(16);
        }
        String settingsFileText = settingsFile.getText();
        for (Map.Entry<PythonTemplateLanguage, String> entry : LANGUAGE_TRACKS.entrySet()) {
            if (!settingsFileText.contains(entry.getValue())) continue;
            PythonTemplateLanguage pythonTemplateLanguage = entry.getKey();
            if (pythonTemplateLanguage == null) {
                DjangoProjectCreatorAndConfigurator.$$$reportNull$$$0(17);
            }
            return pythonTemplateLanguage;
        }
        DjangoTemplateLanguage djangoTemplateLanguage = DjangoTemplateLanguage.INSTANCE;
        if (djangoTemplateLanguage == null) {
            DjangoProjectCreatorAndConfigurator.$$$reportNull$$$0(18);
        }
        return djangoTemplateLanguage;
    }

    private static void modifyInstalledApps(@NotNull Document document, Set<String> appsToAdd, Set<String> appsToRemove) {
        if (document == null) {
            DjangoProjectCreatorAndConfigurator.$$$reportNull$$$0(19);
        }
        boolean inInstalledApps = false;
        for (int line2 = 0; line2 < document.getLineCount(); ++line2) {
            int lineStart = document.getLineStartOffset(line2);
            int lineEnd = document.getLineEndOffset(line2);
            String lineText = document.getCharsSequence().subSequence(lineStart, lineEnd).toString();
            for (String app : appsToRemove) {
                if (StringUtil.isEmpty((String)app) || !lineText.contains(app)) continue;
                document.deleteString(lineStart, lineEnd + 1);
            }
            if (lineText.startsWith("INSTALLED_APPS =")) {
                inInstalledApps = true;
                continue;
            }
            if (inInstalledApps && lineText.startsWith(")") || lineText.startsWith("]")) {
                for (String app : appsToAdd) {
                    if (StringUtil.isEmpty((String)app)) continue;
                    document.insertString(lineStart, (CharSequence)("    '" + app + "',\n"));
                }
                break;
            }
            if (!inInstalledApps) continue;
            Iterator<String> it = appsToAdd.iterator();
            while (it.hasNext()) {
                String app;
                app = it.next();
                if (StringUtil.isEmpty((String)app) || !lineText.startsWith("    # '" + app)) continue;
                document.replaceString(lineStart + 4, lineStart + 6, (CharSequence)"");
                it.remove();
            }
        }
    }

    private static void commentAdminUrls(@NotNull Document document, @NotNull Project project) {
        if (document == null) {
            DjangoProjectCreatorAndConfigurator.$$$reportNull$$$0(20);
        }
        if (project == null) {
            DjangoProjectCreatorAndConfigurator.$$$reportNull$$$0(21);
        }
        Application application = ApplicationManager.getApplication();
        assert (application.isDispatchThread());
        WriteCommandAction.writeCommandAction((Project)project).run(() -> {
            for (int line2 = 0; line2 < document.getLineCount(); ++line2) {
                int lineStart = document.getLineStartOffset(line2);
                String lineText = document.getCharsSequence().subSequence(lineStart, document.getLineEndOffset(line2)).toString();
                if (lineText.startsWith("from django.contrib import admin") || lineText.startsWith("admin.autodiscover")) {
                    document.insertString(lineStart, (CharSequence)"# ");
                    continue;
                }
                if (!lineText.contains("admin.site.urls")) continue;
                document.insertString(lineStart, (CharSequence)"    #");
            }
        });
    }

    private static void createTemplatesFolderError(String templatesFolderPath) {
        Messages.showErrorDialog((String)DjangoBundle.message("create-folder-error", templatesFolderPath), (String)DjangoBundle.message("project-create-error", new Object[0]));
    }

    private static void setTemplatesFolderInSettings(@NotNull String projectRoot, @NotNull Project project, @NotNull VirtualFile templatesFolder, @NotNull VirtualFile settingsVirtualFile) {
        VirtualFile rootFolder;
        if (projectRoot == null) {
            DjangoProjectCreatorAndConfigurator.$$$reportNull$$$0(22);
        }
        if (project == null) {
            DjangoProjectCreatorAndConfigurator.$$$reportNull$$$0(23);
        }
        if (templatesFolder == null) {
            DjangoProjectCreatorAndConfigurator.$$$reportNull$$$0(24);
        }
        if (settingsVirtualFile == null) {
            DjangoProjectCreatorAndConfigurator.$$$reportNull$$$0(25);
        }
        if ((rootFolder = VirtualFileUtil.findFile(projectRoot)) == null) {
            return;
        }
        VirtualFile settings = DjangoProjectCreatorAndConfigurator.findSettings(rootFolder, project);
        if (settings == null) {
            return;
        }
        VirtualFile baseDir = settings.getParent();
        String relativePath = DjangoProjectCreatorAndConfigurator.findRelativePath(baseDir, templatesFolder);
        PsiManagerEx managerEx = PsiManagerEx.getInstanceEx((Project)project);
        PyFile settingsFile = PyUtil.as(managerEx.getFileManager().findFile(settingsVirtualFile), PyFile.class);
        if (settingsFile == null) {
            return;
        }
        PyDjangoTemplateFSLoader loader = PyDjangoTemplateFSLoader.getForSettings(settingsFile);
        String templateDirs = "os.path.join(BASE_DIR,  '" + relativePath + "')";
        loader.setFolder(templateDirs);
    }

    private static String findRelativePath(VirtualFile settings, VirtualFile templatesFolder) {
        settings = settings.getParent();
        StringBuilder up = new StringBuilder();
        while (VirtualFileUtil.getRelativePath(settings, templatesFolder) == null) {
            settings = settings.getParent();
            up.append("../");
        }
        String rel = VirtualFileUtil.getRelativePath(settings, templatesFolder);
        if (rel != null) {
            return up.append(rel).toString();
        }
        return null;
    }

    @Nullable
    private static VirtualFile fetchSettingsFromManagePy(@NotNull Project project, final @NotNull VirtualFile projectRoot) {
        VirtualFile managePy;
        if (project == null) {
            DjangoProjectCreatorAndConfigurator.$$$reportNull$$$0(26);
        }
        if (projectRoot == null) {
            DjangoProjectCreatorAndConfigurator.$$$reportNull$$$0(27);
        }
        if ((managePy = projectRoot.findChild("manage.py")) == null) {
            return null;
        }
        PsiFile managePyPsi = PsiManager.getInstance((Project)project).findFile(managePy);
        if (managePyPsi == null) {
            return null;
        }
        final Ref result = new Ref();
        managePyPsi.accept((PsiElementVisitor)new PyRecursiveElementVisitor(){

            @Override
            public void visitPyCallExpression(PyCallExpression node) {
                if (node.isCalleeText("setdefault")) {
                    PyExpression key = node.getArgument(PythonFunctionParameters.ENV_SET_DEFAULT_KEY, PyExpression.class);
                    PyExpression value2 = node.getArgument(PythonFunctionParameters.ENV_SET_DEFAULT_FAILOBJ, PyExpression.class);
                    if (key == null || value2 == null) {
                        super.visitPyCallExpression(node);
                        return;
                    }
                    String keyString = PyEvaluator.evaluate(key, String.class);
                    String valueString = PyEvaluator.evaluate(value2, String.class);
                    if (keyString == null || valueString == null) {
                        super.visitPyCallExpression(node);
                        return;
                    }
                    if (keyString.equals("DJANGO_SETTINGS_MODULE")) {
                        result.set((Object)projectRoot.findFileByRelativePath(String.format("%s.py", StringUtil.replace((String)valueString, (String)".", (String)"/"))));
                    }
                }
                super.visitPyCallExpression(node);
            }
        });
        return (VirtualFile)result.get();
    }

    static {
        LANGUAGE_TRACKS.put(MakoLanguage.INSTANCE, "MakoMiddleware");
        LANGUAGE_TRACKS.put(ChameleonLanguage.INSTANCE, "chameleon.context_processors.theme");
        LANGUAGE_TRACKS.put(Jinja2Language.INSTANCE, "django_jinja");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 17: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 17: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentRoot";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 6: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsFile";
                break;
            }
            case 8: 
            case 12: 
            case 22: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectRoot";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsHolder";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appName";
                break;
            }
            case 13: 
            case 21: 
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/django/model/DjangoProjectCreatorAndConfigurator";
                break;
            }
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templatesFolder";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsVirtualFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/django/model/DjangoProjectCreatorAndConfigurator";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "chooseTemplateLanguage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createProject";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "configureTemplates";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "configureSettingsAndFacet";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getFullAppName";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findSettings";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "configureDjangoFacet";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "chooseTemplateLanguage";
                break;
            }
            case 17: 
            case 18: {
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "modifyInstalledApps";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "commentAdminUrls";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "setTemplatesFolderInSettings";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "fetchSettingsFromManagePy";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 17: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

