/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.model;

import com.google.common.collect.Lists;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.jetbrains.django.DjangoFQNamesProvider;
import com.jetbrains.django.DjangoFunctionParams;
import com.jetbrains.django.codeInsight.DjangoTypeProvider;
import com.jetbrains.django.model.DjangoMeta;
import com.jetbrains.django.model.applications.DjangoApplicationModel;
import com.jetbrains.django.model.modelApi.DjangoModelApi;
import com.jetbrains.django.model.modelApi.DjangoModelClass;
import com.jetbrains.django.model.relationalKeys.DjangoKeyRelationInfo;
import com.jetbrains.django.model.relationalKeys.DjangoRelationType;
import com.jetbrains.django.model.stubs.DjangoForeignKeyIndex;
import com.jetbrains.django.util.DjangoUtil;
import com.jetbrains.extensions.python.PyCallExpressionExtKt;
import com.jetbrains.python.PyNames;
import com.jetbrains.python.codeInsight.PyCustomMember;
import com.jetbrains.python.nameResolver.NameResolverTools;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStringLiteralUtil;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyCallExpressionHelper;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.search.PyClassInheritorsSearch;
import com.jetbrains.python.psi.types.PyCallableParameter;
import com.jetbrains.python.psi.types.PyCallableParameterImpl;
import com.jetbrains.python.psi.types.PyCallableTypeImpl;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyClassTypeImpl;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeUtil;
import com.jetbrains.python.psi.types.PyUnionType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DjangoModel {
    public static final String SET_POSTFIX = "_set";
    public static final String ID_POSTFIX = "_id";
    private final PyClass myClass;
    private static final Key<ParameterizedCachedValue<Set<PyCustomMember>, TypeEvalContext>> DJANGO_DYNAMIC_MEMBERS = Key.create((String)"DJANGO_DYNAMIC_MEMBERS");
    private static final Key<Trinity<DjangoRelationType, String, Boolean>> RELATION_INFO = Key.create((String)"RELATION_INFO");
    private static final Function<PsiElement, PyType> OBJECTS_TYPE_PROVIDER = context -> {
        PyClass modelClass = (PyClass)context;
        PyClassTypeImpl type = PyClassTypeImpl.createTypeByQName((PsiElement)modelClass, "django.db.models.manager.Manager", false);
        if (type != null) {
            type.putUserData(DjangoTypeProvider.MODEL_CLASS_KEY, modelClass);
        }
        return type;
    };
    private static final PyCustomMember OBJECTS = new PyCustomMember("objects", "django.db.models.manager.Manager", OBJECTS_TYPE_PROVIDER).resolvesTo("django.db.models.manager").toFunction("ensure_default_manager").toCall("add_to_class", "objects");
    private static final PyCustomMember ID = new PyCustomMember("id", "django.db.models.fields.AutoField", (Function<? super PsiElement, ? extends PyType>)((Function)element -> PyBuiltinCache.getInstance(element).getIntType())).resolvesTo("django.db.models.options").toClass("Options").toFunction("_prepare").toCall("add_to_class", "id");
    public static final PyCustomMember META = new PyCustomMember("_meta", "django.db.models.options.Options", true).resolvesTo("django.db.models.base").toClass("ModelBase").toFunction("__new__").toCall("add_to_class", "_meta");
    private static final PyCustomMember DOES_NO_EXIST = new PyCustomMember("DoesNotExist", "django.db.models.base.ModelBase", true).resolvesTo("django.db.models.base").toClass("ModelBase").toFunction("__new__").toCall("add_to_class", "DoesNotExist");
    private static final PyCustomMember MULTIPLE_OBJECTS_RETURNED = new PyCustomMember("MultipleObjectsReturned", "django.db.models.base.ModelBase", true).resolvesTo("django.db.models.base").toClass("ModelBase").toFunction("__new__").toCall("add_to_class", "MultipleObjectsReturned");

    private DjangoModel(PyClass clazz) {
        this.myClass = clazz;
    }

    @Nullable
    public static DjangoModel createFromClass(@NotNull PyClass clazz, TypeEvalContext typeEvalContext) {
        if (clazz == null) {
            DjangoModel.$$$reportNull$$$0(0);
        }
        if (DjangoModel.isDjangoModelDescendant(clazz, typeEvalContext)) {
            return new DjangoModel(clazz);
        }
        return null;
    }

    public static Collection<PyCustomMember> getClassMembers() {
        ArrayList<PyCustomMember> result = new ArrayList<PyCustomMember>();
        result.add(OBJECTS);
        result.add(MULTIPLE_OBJECTS_RETURNED);
        result.add(DOES_NO_EXIST);
        result.add(META);
        return result;
    }

    public Collection<PyCustomMember> getInstanceMembers(@Nullable TypeEvalContext context) {
        Project project = this.myClass.getProject();
        return (Collection)CachedValuesManager.getManager((Project)project).getParameterizedCachedValue((UserDataHolder)this.myClass, DJANGO_DYNAMIC_MEMBERS, param -> {
            Set<PyCustomMember> result = DjangoModel.collectMembers(this.myClass, param);
            return CachedValueProvider.Result.create(result, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, ProjectRootManager.getInstance((Project)this.myClass.getProject())});
        }, false, (Object)context);
    }

    @NotNull
    private static Set<PyCustomMember> collectMembers(@NotNull PyClass aClass, @NotNull TypeEvalContext context) {
        if (aClass == null) {
            DjangoModel.$$$reportNull$$$0(1);
        }
        if (context == null) {
            DjangoModel.$$$reportNull$$$0(2);
        }
        DjangoModel model = new DjangoModel(aClass);
        HashSet<PyCustomMember> result = new HashSet<PyCustomMember>();
        result.addAll(model.getMembersFast());
        result.addAll(model.getFieldDerivedAttributes());
        result.addAll(DjangoModel.getAttributesFromReverseForeignRelations(aClass, context));
        result.addAll(DjangoModel.getFooDisplayFunctions(aClass));
        result.addAll(DjangoModel.getNextAndPreviousByFoo(aClass));
        HashSet<PyCustomMember> hashSet = result;
        if (hashSet == null) {
            DjangoModel.$$$reportNull$$$0(3);
        }
        return hashSet;
    }

    private static Collection<? extends PyCustomMember> getNextAndPreviousByFoo(PyClass aClass) {
        ArrayList res = Lists.newArrayList();
        DjangoModel.iterateClassAttributesAssignedCalls(aClass, (attr, value2) -> {
            PyKeywordArgument pk;
            PyArgumentList argumentList;
            String name;
            String string = name = value2.getCallee() != null ? value2.getCallee().getName() : null;
            if (name != null && (name.endsWith("DateTimeField") || name.endsWith("DateField")) && (argumentList = value2.getArgumentList()) != null && ((pk = argumentList.getKeywordArgument("null")) == null || "False".equals(PyStringLiteralUtil.getText(pk.getValueExpression())))) {
                res.add(new PyCustomMember("get_next_by_" + attr.getReferencedName()).toPsiElement(attr).asFunction());
                res.add(new PyCustomMember("get_previous_by_" + attr.getReferencedName()).toPsiElement(attr).asFunction());
            }
            return true;
        });
        return res;
    }

    private static Collection<? extends PyCustomMember> getFooDisplayFunctions(PyClass aClass) {
        ArrayList displayFoos = Lists.newArrayList();
        DjangoModel.iterateClassAttributesAssignedCalls(aClass, (attr, value2) -> {
            PyKeywordArgument pk;
            PyArgumentList argumentList = value2.getArgumentList();
            if (argumentList != null && (pk = argumentList.getKeywordArgument("choices")) != null) {
                displayFoos.add(new PyCustomMember("get_" + attr.getReferencedName() + "_display").toPsiElement(attr).asFunction());
            }
            return true;
        });
        return displayFoos;
    }

    private Collection<PyCustomMember> getMembersFast() {
        ArrayList<PyCustomMember> result = new ArrayList<PyCustomMember>();
        if (!this.hasPrimaryKey()) {
            result.add(ID);
        }
        result.addAll(DjangoModel.getClassMembers());
        return result;
    }

    private boolean hasPrimaryKey() {
        Ref res = Ref.create((Object)false);
        DjangoModel.iterateClassAttributesAssignedCalls(this.myClass, (attr, value2) -> {
            PyExpression pkValue;
            PyKeywordArgument pk;
            PyArgumentList argumentList = value2.getArgumentList();
            if (argumentList != null && (pk = argumentList.getKeywordArgument("primary_key")) != null && (pkValue = pk.getValueExpression()) != null && pkValue.getText().equals("True")) {
                res.set((Object)true);
                return false;
            }
            return true;
        });
        return (Boolean)res.get();
    }

    private static void iterateClassAttributesAssignedCalls(PyClass aClass, AssignedCallsProcessor processor2) {
        List<PyTargetExpression> attrs = aClass.getClassAttributes();
        for (PyTargetExpression attr : attrs) {
            PyExpression value2;
            if (attr.getCalleeName() == null || !((value2 = attr.findAssignedValue()) instanceof PyCallExpression) || processor2.process(attr, (PyCallExpression)value2)) continue;
            return;
        }
    }

    @Nullable
    public PsiElement resolveClassMember(String name, @NotNull PyResolveContext resolveContext) {
        if (resolveContext == null) {
            DjangoModel.$$$reportNull$$$0(4);
        }
        for (PyCustomMember member : DjangoModel.getClassMembers()) {
            if (!member.getName().equals(name)) continue;
            return member.resolve((PsiElement)this.myClass, resolveContext);
        }
        return null;
    }

    @Nullable
    public PsiElement resolveInstanceMember(String name, @NotNull PyResolveContext resolveContext) {
        if (resolveContext == null) {
            DjangoModel.$$$reportNull$$$0(5);
        }
        for (PyCustomMember member : this.getMembersFast()) {
            if (!member.getName().equals(name)) continue;
            return member.resolve((PsiElement)this.myClass, resolveContext);
        }
        for (PyCustomMember member : this.getInstanceMembers(resolveContext.getTypeEvalContext())) {
            if (!member.getName().equals(name)) continue;
            return member.resolve((PsiElement)this.myClass, resolveContext);
        }
        return null;
    }

    public Collection<PyCustomMember> getFieldDerivedAttributes() {
        ArrayList<PyCustomMember> result = new ArrayList<PyCustomMember>();
        for (PyTargetExpression e : this.myClass.getClassAttributes()) {
            String typeName;
            PyClass fieldClass;
            PyCallExpression initCall = PyUtil.as(e.findAssignedValue(), PyCallExpression.class);
            if (initCall == null || !PyCallExpressionExtKt.isCalleeName(initCall, DjangoFQNamesProvider.RELATION_ONE_TO_ONE_KEY, DjangoFQNamesProvider.RELATION_FOREIGN_KEY) || (fieldClass = PyCallExpressionHelper.resolveCalleeClass(initCall)) == null || !NameResolverTools.isName(fieldClass, DjangoFQNamesProvider.RELATION_ONE_TO_ONE_KEY, DjangoFQNamesProvider.RELATION_FOREIGN_KEY)) continue;
            String fieldName = e.getName() + ID_POSTFIX;
            PyClassType type = PyBuiltinCache.getInstance((PsiElement)this.myClass).getIntType();
            String string = typeName = type != null ? type.getClassQName() : null;
            String qualifiedName = this.myClass.getQualifiedName();
            if (qualifiedName == null) continue;
            result.add(new PyCustomMember(fieldName, typeName, false).resolvesToClass(qualifiedName).toClassAttribute(e.getName()));
        }
        return result;
    }

    @NotNull
    public static Collection<PyCustomMember> getAttributesFromReverseForeignRelations(@NotNull PyClass refToClass, @Nullable TypeEvalContext context) {
        if (refToClass == null) {
            DjangoModel.$$$reportNull$$$0(6);
        }
        HashSet<PyCustomMember> res = new HashSet<PyCustomMember>();
        DjangoModel.findForeignKeyAttributes(refToClass, res, context);
        for (PyClass cls : refToClass.getAncestorClasses(context)) {
            if ("django.db.models.base.Model".equals(cls.getQualifiedName())) break;
            DjangoModel.findForeignKeyAttributes(cls, res, context);
        }
        HashSet<PyCustomMember> hashSet = res;
        if (hashSet == null) {
            DjangoModel.$$$reportNull$$$0(7);
        }
        return hashSet;
    }

    private static void findForeignKeyAttributes(PyClass toClass, Set<PyCustomMember> res, TypeEvalContext context) {
        String className = toClass.getName();
        if (className == null) {
            return;
        }
        Project project = toClass.getProject();
        HashSet<PyClass> visited = new HashSet<PyClass>();
        Collection fields = StubIndex.getElements(DjangoForeignKeyIndex.KEY, (Object)className, (Project)project, (GlobalSearchScope)ProjectScope.getAllScope((Project)project), PyTargetExpression.class);
        for (PyTargetExpression field : fields) {
            PyClass fromClass = (PyClass)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)field, PyClass.class);
            if (fromClass == null || visited.contains(fromClass)) continue;
            visited.add(fromClass);
            DjangoMeta meta = DjangoMeta.fromModelClass(fromClass);
            if (meta != null && meta.isAbstract()) {
                PyClassInheritorsSearch.search(fromClass, true).forEach(aClass -> {
                    DjangoMeta m = DjangoMeta.fromModelClass(aClass);
                    if (m == null || !m.isAbstract()) {
                        DjangoModel.getForeignKeyAttributes(aClass, toClass, res, fromClass.getClassAttributes(), context);
                    }
                    return true;
                });
                continue;
            }
            DjangoModel.getForeignKeyAttributes(fromClass, toClass, res, context);
        }
        if (!visited.contains(toClass)) {
            DjangoModel.getForeignKeyAttributes(toClass, toClass, res, context);
        }
    }

    public static void getForeignKeyAttributes(@NotNull PyClass refFromClass, @NotNull PyClass refToClass, @NotNull Collection<PyCustomMember> res, @Nullable TypeEvalContext context) {
        if (refFromClass == null) {
            DjangoModel.$$$reportNull$$$0(8);
        }
        if (refToClass == null) {
            DjangoModel.$$$reportNull$$$0(9);
        }
        if (res == null) {
            DjangoModel.$$$reportNull$$$0(10);
        }
        List<PyTargetExpression> attributes = refFromClass.getClassAttributes();
        DjangoModel.getForeignKeyAttributes(refFromClass, refToClass, res, attributes, context);
    }

    private static void getForeignKeyAttributes(PyClass refFromClass, PyClass refToClass, Collection<PyCustomMember> res, List<PyTargetExpression> attributes, @Nullable TypeEvalContext context) {
        for (PyTargetExpression targetExpression : attributes) {
            DjangoKeyRelationInfo info = DjangoKeyRelationInfo.create(targetExpression, context);
            String forwardName = targetExpression.getName();
            if (info == null || forwardName == null || !info.getUnqualifiedDestClassName().equals(refToClass.getName())) continue;
            DjangoModel.addForeignKeyAttribute(refFromClass, res, info.getInitCall(), forwardName, info.getRelationType());
        }
    }

    @Nullable
    public static String getAppNameByModelClass(@NotNull PyClass modelClass) {
        if (modelClass == null) {
            DjangoModel.$$$reportNull$$$0(11);
        }
        return (String)CachedValuesManager.getCachedValue((PsiElement)modelClass, () -> CachedValueProvider.Result.create((Object)DjangoModel.getAppNameByModelClassInt(modelClass), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    @Nullable
    private static String getAppNameByModelClassInt(@NotNull PyClass modelClass) {
        DjangoModelApi api;
        if (modelClass == null) {
            DjangoModel.$$$reportNull$$$0(12);
        }
        if ((api = DjangoModelApi.create(modelClass).getSuccessOrNull()) == null) {
            return null;
        }
        PyFile pyFile = (PyFile)ObjectUtils.tryCast((Object)modelClass.getContainingFile(), PyFile.class);
        if (pyFile == null) {
            return null;
        }
        Optional<DjangoApplicationModel> appWithModel = api.getApplications().stream().filter(app -> PsiTreeUtil.isAncestor((PsiElement)app.getApplicationRootFolder(), (PsiElement)pyFile, (boolean)false)).findFirst();
        if (appWithModel.isPresent()) {
            return appWithModel.get().getLabel();
        }
        PsiDirectory parent = pyFile.getParent();
        if (parent != null) {
            return parent.getName();
        }
        return null;
    }

    public static String getAppModelName(PsiFile modelsFile, String className) {
        PsiDirectory parentDir = modelsFile.getParent();
        if (parentDir == null) {
            return className;
        }
        return parentDir.getName() + "." + className;
    }

    private static void addForeignKeyAttribute(@NotNull PyClass refFromClass, @NotNull Collection<PyCustomMember> res, @NotNull PyCallExpression fieldInitCall, @NotNull String forwardName, @NotNull DjangoRelationType relationType) {
        String refFromClassName;
        if (refFromClass == null) {
            DjangoModel.$$$reportNull$$$0(13);
        }
        if (res == null) {
            DjangoModel.$$$reportNull$$$0(14);
        }
        if (fieldInitCall == null) {
            DjangoModel.$$$reportNull$$$0(15);
        }
        if (forwardName == null) {
            DjangoModel.$$$reportNull$$$0(16);
        }
        if (relationType == null) {
            DjangoModel.$$$reportNull$$$0(17);
        }
        if ((refFromClassName = refFromClass.getName()) != null) {
            boolean relatedNameProvided;
            String relatedName = PyUtil.getKeywordArgumentString(fieldInitCall, "related_name");
            boolean bl = relatedNameProvided = relatedName != null;
            if (relatedNameProvided) {
                relatedName = relatedName.replace("%(class)s", StringUtil.toLowerCase((String)refFromClassName));
                PsiDirectory app = refFromClass.getContainingFile().getParent();
                if (app != null) {
                    relatedName = relatedName.replace("%(app_label)s", app.getName());
                }
            }
            String qualifiedName = refFromClass.getQualifiedName();
            Trinity relationInfo = Trinity.create((Object)((Object)relationType), (Object)forwardName, (Object)relatedNameProvided);
            if (qualifiedName != null && (relatedName == null || PyNames.isIdentifierString(relatedName))) {
                if (relationType == DjangoRelationType.ONE_TO_ONE) {
                    res.add(new PyCustomMember(relatedNameProvided ? relatedName : StringUtil.toLowerCase((String)refFromClassName), qualifiedName, (Function<? super PsiElement, ? extends PyType>)((Function)psiElement -> {
                        PyClassTypeImpl type = new PyClassTypeImpl(refFromClass, false);
                        return type.withUserData(RELATION_INFO, relationInfo);
                    })).resolvesToClass(qualifiedName));
                } else {
                    res.add(DjangoModel.createForeignRelatedDynamicMember(relatedNameProvided ? relatedName : StringUtil.toLowerCase((String)refFromClassName) + SET_POSTFIX, refFromClass, fieldInitCall, qualifiedName, (Trinity<DjangoRelationType, String, Boolean>)relationInfo));
                }
            }
        }
    }

    private static PyCustomMember createForeignRelatedDynamicMember(@NotNull String name, @NotNull PyClass refFromClass, @NotNull PyCallExpression fieldInitCall, @NotNull String qualifiedName, @NotNull Trinity<DjangoRelationType, String, Boolean> relationInfo) {
        if (name == null) {
            DjangoModel.$$$reportNull$$$0(18);
        }
        if (refFromClass == null) {
            DjangoModel.$$$reportNull$$$0(19);
        }
        if (fieldInitCall == null) {
            DjangoModel.$$$reportNull$$$0(20);
        }
        if (qualifiedName == null) {
            DjangoModel.$$$reportNull$$$0(21);
        }
        if (relationInfo == null) {
            DjangoModel.$$$reportNull$$$0(22);
        }
        return new PyCustomMember(name, qualifiedName, (Function<? super PsiElement, ? extends PyType>)((Function)param -> {
            PyClassTypeImpl classType = PyClassTypeImpl.createTypeByQName((PsiElement)refFromClass, "django.db.models.manager.Manager", false);
            if (classType == null) {
                return null;
            }
            PyClassTypeImpl managerClassType = classType.withUserData(DjangoTypeProvider.MODEL_CLASS_KEY, refFromClass).withUserData(DjangoTypeProvider.RELATED_KEY, fieldInitCall).withUserData(RELATION_INFO, relationInfo);
            DjangoModelApi api = DjangoModelApi.create(fieldInitCall).getSuccessOrNull();
            if (api != null && api.isDjangoPackageMatches(DjangoUtil.createRequirementAtLeast(1, 7), false)) {
                PyType strType = PyBuiltinCache.getInstance((PsiElement)fieldInitCall).getStringType(LanguageLevel.forElement((PsiElement)fieldInitCall));
                PyCallableParameter managerParam = PyCallableParameterImpl.nonPsi("manager", strType);
                PyCallableTypeImpl managerCallableType = new PyCallableTypeImpl(Collections.singletonList(managerParam), PyUnionType.union(managerClassType, null));
                return PyUnionType.union(Arrays.asList(managerCallableType, managerClassType, null));
            }
            return managerClassType;
        })).resolvesToClass(qualifiedName);
    }

    @Nullable
    public static Trinity<DjangoRelationType, String, Boolean> getRelatedInfo(@NotNull PyCustomMember member, @NotNull PsiElement anchor, @NotNull PyResolveContext resolveContext) {
        PyTypedElement typedElement;
        if (member == null) {
            DjangoModel.$$$reportNull$$$0(23);
        }
        if (anchor == null) {
            DjangoModel.$$$reportNull$$$0(24);
        }
        if (resolveContext == null) {
            DjangoModel.$$$reportNull$$$0(25);
        }
        if ((typedElement = PyUtil.as(member.resolve(anchor, resolveContext), PyTypedElement.class)) == null) {
            return null;
        }
        PyType type = resolveContext.getTypeEvalContext().getType(typedElement);
        return type == null ? null : DjangoModel.getRelatedInfo(type);
    }

    @Nullable
    public static Trinity<DjangoRelationType, String, Boolean> getRelatedInfo(@NotNull PyType classType) {
        if (classType == null) {
            DjangoModel.$$$reportNull$$$0(26);
        }
        return PyTypeUtil.findData(classType, RELATION_INFO);
    }

    @Nullable
    public static PyClassType createMultiRelationType(@Nullable PyClassType elementType, PyCallExpression fieldInitCall) {
        PyExpression value2;
        PyTargetExpression attr;
        PyClass manager;
        PyExpression assignedValue;
        PyTargetExpression objects;
        PsiElement throughModel;
        PyExpression through = fieldInitCall.getArgument(DjangoFunctionParams.MANY_TO_MANY_THROUGH, PyExpression.class);
        if (through instanceof PyReferenceExpression && (throughModel = ((PyReferenceExpression)through).getReference().resolve()) instanceof PyClass && (objects = ((PyClass)throughModel).findClassAttribute("objects", false, null)) != null && (assignedValue = objects.findAssignedValue()) instanceof PyCallExpression && (manager = PyCallExpressionHelper.resolveCalleeClass((PyCallExpression)assignedValue)) != null && (attr = manager.findClassAttribute("use_for_related_fields", false, null)) != null && (value2 = attr.findAssignedValue()) != null && value2.getText().equals("True")) {
            return new PyClassTypeImpl(manager, false).withUserData(DjangoTypeProvider.RELATED_KEY, fieldInitCall);
        }
        PyClassTypeImpl type = PyClassTypeImpl.createTypeByQName((PsiElement)fieldInitCall, DjangoModel.getMultiRelationTypeName(), false);
        if (type == null || elementType == null) {
            return null;
        }
        PyClassTypeImpl result = type.withUserData(DjangoTypeProvider.RELATED_KEY, fieldInitCall);
        PyClass possibleModel = elementType.getPyClass();
        if (DjangoModelClass.isModelClass(possibleModel, null)) {
            result.putUserData(DjangoTypeProvider.MODEL_CLASS_KEY, possibleModel);
        }
        return result;
    }

    public static String getMultiRelationTypeName() {
        return "django.db.models.manager.Manager";
    }

    public static boolean isDjangoModelDescendant(@Nullable PyClass clazz, TypeEvalContext typeEvalContext) {
        return clazz != null && clazz.isSubclass("django.db.models.base.Model", typeEvalContext);
    }

    public static boolean isDjangoFieldDescendant(@Nullable PyClass clazz, TypeEvalContext typeEvalContext) {
        return clazz != null && clazz.isSubclass("django.db.models.fields.Field", typeEvalContext);
    }

    public static Map<String, String> getFields(@NotNull PyClass pyClass) {
        if (pyClass == null) {
            DjangoModel.$$$reportNull$$$0(27);
        }
        HashMap<String, String> result = new HashMap<String, String>();
        List<PyTargetExpression> classAttributes = pyClass.getClassAttributes();
        for (PyTargetExpression expression : classAttributes) {
            String fieldName = expression.getName();
            QualifiedName calleeName = expression.getCalleeName();
            if (fieldName == null || calleeName == null) continue;
            String typeName = calleeName.getLastComponent();
            result.put(fieldName, typeName);
        }
        return result;
    }

    public static String getNameNoPostfix(@NotNull String relationName) {
        if (relationName == null) {
            DjangoModel.$$$reportNull$$$0(28);
        }
        if (!relationName.endsWith(SET_POSTFIX)) {
            return relationName;
        }
        return relationName.substring(0, relationName.length() - SET_POSTFIX.length());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/django/model/DjangoModel";
                break;
            }
            case 4: 
            case 5: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveContext";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refToClass";
                break;
            }
            case 8: 
            case 13: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refFromClass";
                break;
            }
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "res";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelClass";
                break;
            }
            case 15: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldInitCall";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forwardName";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relationType";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relationInfo";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classType";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyClass";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relationName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/django/model/DjangoModel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "collectMembers";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributesFromReverseForeignRelations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createFromClass";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "collectMembers";
                break;
            }
            case 3: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "resolveClassMember";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "resolveInstanceMember";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAttributesFromReverseForeignRelations";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getForeignKeyAttributes";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getAppNameByModelClass";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getAppNameByModelClassInt";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addForeignKeyAttribute";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createForeignRelatedDynamicMember";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getRelatedInfo";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getFields";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getNameNoPostfix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static interface AssignedCallsProcessor {
        public boolean process(PyTargetExpression var1, PyCallExpression var2);
    }
}

