/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.manage;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.commandInterface.command.Argument;
import com.jetbrains.commandInterface.command.ArgumentsInfo;
import com.jetbrains.commandInterface.command.CommandExecutor;
import com.jetbrains.commandInterface.command.Help;
import com.jetbrains.commandInterface.command.KnownArgumentsInfo;
import com.jetbrains.commandInterface.command.NoArgumentsInfo;
import com.jetbrains.django.manage.FailedToProvideCommandsException;
import com.jetbrains.django.manage.ShellExecutor;
import com.jetbrains.django.manage.SpecialCaseInfo;
import com.jetbrains.django.manage.TestsExecutor;
import com.jetbrains.django.manage.externalUrl.DjangoExternalUrlsCommand;
import com.jetbrains.django.manage.externalUrl.DjangoExternalUrlsRoot;
import com.jetbrains.django.model.applications.DjangoApplicationModel;
import com.jetbrains.django.model.modelApi.DjangoModelApi;
import com.jetbrains.extensions.RegistryValueExtKt;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class SpecialCaseCommandsProvider {
    @NotNull
    private final Map<String, Pair<ArgumentsInfo, CommandExecutor>> myArgumentsAndExecutors;
    @NotNull
    private final Map<String, DjangoExternalUrlsCommand> myExternalUrls;
    private final Set<String> myCommandsToUseNativeRunner;

    SpecialCaseCommandsProvider(@NotNull Module module) throws FailedToProvideCommandsException {
        if (module == null) {
            SpecialCaseCommandsProvider.$$$reportNull$$$0(0);
        }
        this.myArgumentsAndExecutors = new HashMap<String, Pair<ArgumentsInfo, CommandExecutor>>();
        this.myExternalUrls = new HashMap<String, DjangoExternalUrlsCommand>();
        this.myCommandsToUseNativeRunner = new HashSet<String>();
        this.fillArgumentsAndExecutors(module);
        this.myExternalUrls.putAll(DjangoExternalUrlsRoot.getCommands(module));
        this.myCommandsToUseNativeRunner.addAll(RegistryValueExtKt.asList(Registry.get((String)"python.django.commandsToUseNativeRunner")));
    }

    private void fillArgumentsAndExecutors(@NotNull Module module) throws FailedToProvideCommandsException {
        DjangoModelApi api;
        if (module == null) {
            SpecialCaseCommandsProvider.$$$reportNull$$$0(1);
        }
        if ((api = DjangoModelApi.create(module).getSuccessOrNull()) == null) {
            throw new FailedToProvideCommandsException("No django on module " + module);
        }
        List<DjangoApplicationModel> applications = api.getApplications();
        ArrayList<String> appNames = new ArrayList<String>(applications.size());
        ArrayList<String> appLabels = new ArrayList<String>(applications.size());
        for (DjangoApplicationModel application : applications) {
            appNames.add(application.getName());
            appLabels.add(application.getLabel());
        }
        Argument applicationArgument = new Argument(new Help("appname"), (Pair<List<String>, Boolean>)Pair.create(appLabels, (Object)true));
        KnownArgumentsInfo infiniteAppArgs = new KnownArgumentsInfo(0, Integer.MAX_VALUE, applicationArgument);
        KnownArgumentsInfo mandatoryAppArg = new KnownArgumentsInfo(1, Integer.MAX_VALUE, applicationArgument);
        KnownArgumentsInfo appAndMigrateArgument = new KnownArgumentsInfo(0, 2, applicationArgument, new Argument(new Help("migrationname")));
        this.addCommand("check", infiniteAppArgs);
        this.addCommand("compilemessages", NoArgumentsInfo.INSTANCE);
        this.addCommand("createcachetable", NoArgumentsInfo.INSTANCE);
        this.addCommand("dbshell", NoArgumentsInfo.INSTANCE, ShellExecutor.INSTANCE);
        this.addCommand("diffsettings", NoArgumentsInfo.INSTANCE);
        Argument dumpDataArg = new Argument(new Help("app_label app_label app_label.Model ...>"), (Pair<List<String>, Boolean>)Pair.create(appLabels, (Object)false));
        this.addCommand("dumpdata", new KnownArgumentsInfo(0, Integer.MAX_VALUE, dumpDataArg));
        this.addCommand("flush", NoArgumentsInfo.INSTANCE);
        this.addCommand("makemessages", NoArgumentsInfo.INSTANCE);
        this.addCommand("makemessages", NoArgumentsInfo.INSTANCE);
        this.addCommand("makemigrations", infiniteAppArgs);
        this.addCommand("migrate", appAndMigrateArgument);
        this.addCommand("runserver", new KnownArgumentsInfo(0, 1, new Argument(new Help("[port or address:port]"))));
        this.addCommand("shell", NoArgumentsInfo.INSTANCE, ShellExecutor.INSTANCE);
        this.addCommand("sql", mandatoryAppArg);
        this.addCommand("sqlall", mandatoryAppArg);
        this.addCommand("sqlclear", mandatoryAppArg);
        this.addCommand("sqlcustom", mandatoryAppArg);
        this.addCommand("sqldropindexes", mandatoryAppArg);
        this.addCommand("sqlflush", mandatoryAppArg);
        this.addCommand("sqlindexes", mandatoryAppArg);
        this.addCommand("sqlmigrate", appAndMigrateArgument);
        this.addCommand("sqlsequencereset", mandatoryAppArg);
        this.addCommand("squashmigrations", appAndMigrateArgument);
        this.addCommand("startapp", new KnownArgumentsInfo(1, 2, new Argument(new Help("<app_label>")), new Argument(new Help("[destination]"))));
        this.addCommand("startproject", new KnownArgumentsInfo(1, 2, new Argument(new Help("<projectname>")), new Argument(new Help("[destination]"))));
        this.addCommand("syncdb", NoArgumentsInfo.INSTANCE);
        Argument testArg = new Argument(new Help("<app or test identifier>"), (Pair<List<String>, Boolean>)Pair.create(appNames, (Object)false));
        this.addCommand("test", new KnownArgumentsInfo(0, Integer.MAX_VALUE, testArg), TestsExecutor.INSTANCE);
        this.addCommand("testserver", new KnownArgumentsInfo(1, Integer.MAX_VALUE, new Argument(new Help("<fixture >"))));
        this.addCommand("validate", NoArgumentsInfo.INSTANCE);
        this.addCommand("changepassword", NoArgumentsInfo.INSTANCE);
        this.addCommand("createsuperuser", NoArgumentsInfo.INSTANCE);
        this.addCommand("ogrinspect", NoArgumentsInfo.INSTANCE);
        this.addCommand("clearsessions", NoArgumentsInfo.INSTANCE);
        this.addCommand("ping_google", NoArgumentsInfo.INSTANCE);
        this.addCommand("collectstatic", NoArgumentsInfo.INSTANCE);
    }

    private void addCommand(@NotNull String commandName, @NotNull ArgumentsInfo argumentsInfo, @Nullable CommandExecutor executor) {
        if (commandName == null) {
            SpecialCaseCommandsProvider.$$$reportNull$$$0(2);
        }
        if (argumentsInfo == null) {
            SpecialCaseCommandsProvider.$$$reportNull$$$0(3);
        }
        this.myArgumentsAndExecutors.put(StringUtil.trim((String)commandName), (Pair<ArgumentsInfo, CommandExecutor>)Pair.create((Object)argumentsInfo, (Object)executor));
    }

    private void addCommand(@NotNull String commandName, @NotNull ArgumentsInfo argumentsInfo) {
        if (commandName == null) {
            SpecialCaseCommandsProvider.$$$reportNull$$$0(4);
        }
        if (argumentsInfo == null) {
            SpecialCaseCommandsProvider.$$$reportNull$$$0(5);
        }
        this.addCommand(commandName, argumentsInfo, null);
    }

    @Nullable
    SpecialCaseInfo getSpecialCaseInfo(@NotNull String commandName) {
        if (commandName == null) {
            SpecialCaseCommandsProvider.$$$reportNull$$$0(6);
        }
        if (this.myCommandsToUseNativeRunner.contains(commandName)) {
            return null;
        }
        String href = null;
        Map<String, String> optionHrefs = null;
        DjangoExternalUrlsCommand urlInfo = this.myExternalUrls.get(commandName);
        if (urlInfo != null) {
            href = urlInfo.getHref();
            optionHrefs = urlInfo.getOptionHrefs();
        }
        Pair<ArgumentsInfo, CommandExecutor> info = this.myArgumentsAndExecutors.get(commandName);
        ArgumentsInfo argumentsInfo = null;
        CommandExecutor executor = null;
        if (info != null) {
            argumentsInfo = (ArgumentsInfo)info.first;
            executor = (CommandExecutor)info.second;
        }
        if (executor == null && href == null && argumentsInfo == null && optionHrefs == null) {
            return null;
        }
        return new SpecialCaseInfo(executor, href, argumentsInfo, optionHrefs);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandName";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentsInfo";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/django/manage/SpecialCaseCommandsProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "fillArgumentsAndExecutors";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "addCommand";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getSpecialCaseInfo";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

