/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.lang.template.ref;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.jetbrains.django.model.DjangoTemplateManager;
import com.jetbrains.python.templateLanguages.TemplateFileReferenceSet;
import java.util.List;

public class DjangoTemplateFileReferenceSet
extends TemplateFileReferenceSet {
    private final boolean myExcludeCurrentFileFromCompletion;

    public DjangoTemplateFileReferenceSet(PsiElement element, boolean excludeCurrentFileFromCompletion) {
        super(element, null);
        this.myExcludeCurrentFileFromCompletion = excludeCurrentFileFromCompletion;
    }

    public static DjangoTemplateFileReferenceSet fromQuotedStringLiteral(PsiElement stringLiteral) {
        return new DjangoTemplateFileReferenceSet(stringLiteral, true);
    }

    @Override
    protected List<VirtualFile> getRoots(Module module) {
        return DjangoTemplateManager.getInstance(module).getTemplatesFolderList(false, null, false);
    }

    protected Condition<PsiFileSystemItem> getReferenceCompletionFilter() {
        if (this.myExcludeCurrentFileFromCompletion) {
            return psiFileSystemItem -> !psiFileSystemItem.equals(this.getElement().getContainingFile().getOriginalFile());
        }
        return Conditions.alwaysTrue();
    }
}

