/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.lang.template.ref;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.jetbrains.django.lang.template.psi.DjangoTemplateElementTypes;
import com.jetbrains.django.lang.template.psi.impl.DjangoTemplateHierarchyVisitor;
import com.jetbrains.django.lang.template.tags.DjangoBlockTag;
import com.jetbrains.python.BaseReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DjangoBlockReference
extends BaseReference {
    private final DjangoBlockTag myBlockTag;

    public DjangoBlockReference(DjangoBlockTag element) {
        super((PsiElement)element);
        this.myBlockTag = element;
    }

    @Override
    @NotNull
    public TextRange getRangeInElement() {
        ASTNode idNode = this.myBlockTag.getNode().findChildByType(DjangoTemplateElementTypes.BLOCK_NAME);
        if (idNode != null) {
            TextRange textRange = idNode.getPsi().getTextRangeInParent();
            if (textRange == null) {
                DjangoBlockReference.$$$reportNull$$$0(0);
            }
            return textRange;
        }
        TextRange textRange = TextRange.EMPTY_RANGE;
        if (textRange == null) {
            DjangoBlockReference.$$$reportNull$$$0(1);
        }
        return textRange;
    }

    public PsiElement resolve() {
        BlockResolveVisitor resolveVisitor = new BlockResolveVisitor();
        this.myBlockTag.getContainingFile().accept((PsiElementVisitor)resolveVisitor);
        return resolveVisitor.result;
    }

    public Object @NotNull [] getVariants() {
        List<LookupElement> elementList = DjangoBlockReference.getBlockCompletionVariants(this.myBlockTag.getContainingFile(), this.myBlockTag);
        Object[] objectArray = elementList.toArray();
        if (objectArray == null) {
            DjangoBlockReference.$$$reportNull$$$0(2);
        }
        return objectArray;
    }

    public static List<LookupElement> getBlockCompletionVariants(PsiFile containingFile, @Nullable DjangoBlockTag ignoreTag) {
        BlockCompletionVisitor completionVisitor = new BlockCompletionVisitor(containingFile, ignoreTag);
        containingFile.accept((PsiElementVisitor)completionVisitor);
        return completionVisitor.getResults();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/jetbrains/django/lang/template/ref/DjangoBlockReference";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class BlockCompletionVisitor
    extends DjangoTemplateHierarchyVisitor {
        private final PsiFile myFile;
        @Nullable
        private final DjangoBlockTag myIgnoreTag;
        private final Set<String> blockNames = new HashSet<String>();
        private final Set<String> usedBlockNames = new HashSet<String>();

        private BlockCompletionVisitor(PsiFile file2, @Nullable DjangoBlockTag ignoreTag) {
            this.myFile = file2;
            this.myIgnoreTag = ignoreTag;
        }

        @Override
        public void visitBlockTag(DjangoBlockTag blockTag) {
            super.visitBlockTag(blockTag);
            String blockName = blockTag.getBlockName();
            if (blockName != null) {
                if (blockTag.getContainingFile() != this.myFile) {
                    this.blockNames.add(blockName);
                } else if (blockTag != this.myIgnoreTag) {
                    this.usedBlockNames.add(blockName);
                }
            }
        }

        public List<LookupElement> getResults() {
            for (String name : this.usedBlockNames) {
                this.blockNames.remove(name);
            }
            ArrayList<LookupElement> result = new ArrayList<LookupElement>();
            for (String blockName : this.blockNames) {
                result.add((LookupElement)LookupElementBuilder.create((String)blockName));
            }
            return result;
        }
    }

    private class BlockResolveVisitor
    extends DjangoTemplateHierarchyVisitor {
        private DjangoBlockTag result = null;

        private BlockResolveVisitor() {
        }

        @Override
        public void visitBlockTag(DjangoBlockTag blockTag) {
            super.visitBlockTag(blockTag);
            if (Comparing.equal((String)blockTag.getBlockName(), (String)DjangoBlockReference.this.myBlockTag.getBlockName()) && (this.result == null || this.result.getContainingFile().equals(DjangoBlockReference.this.myBlockTag.getContainingFile()))) {
                this.result = blockTag;
            }
        }

        @Override
        protected boolean done() {
            return this.result != null && this.result.getContainingFile() != DjangoBlockReference.this.myBlockTag.getContainingFile();
        }
    }
}

