/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.lang.template.psi;

import com.google.common.collect.Lists;
import com.intellij.lang.ASTNode;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlDocument;
import com.jetbrains.django.lang.template.DjangoTemplateLanguage;
import com.jetbrains.django.lang.template.parsing.DjangoTemplateTokenTypes;
import com.jetbrains.django.lang.template.psi.impl.DjangoOuterLanguageElement;
import com.jetbrains.django.lang.template.psi.impl.DjangoTagElementImpl;
import com.jetbrains.django.lang.template.psi.impl.DjangoVariableReferenceImpl;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DjangoTemplatePsiUtil {
    private DjangoTemplatePsiUtil() {
    }

    public static boolean isTemplateCharacters(@NotNull ASTNode child) {
        if (child == null) {
            DjangoTemplatePsiUtil.$$$reportNull$$$0(0);
        }
        return child.getPsi() instanceof DjangoOuterLanguageElement && child.getElementType() == DjangoTemplateTokenTypes.TEMPLATE_CHARACTERS;
    }

    public static boolean containsButNotEqual(@NotNull TextRange biggerRange, @NotNull TextRange smallerRange) {
        if (biggerRange == null) {
            DjangoTemplatePsiUtil.$$$reportNull$$$0(1);
        }
        if (smallerRange == null) {
            DjangoTemplatePsiUtil.$$$reportNull$$$0(2);
        }
        return biggerRange.contains(smallerRange) && !biggerRange.equals((Object)smallerRange);
    }

    @NotNull
    public static PsiElement biggestElementInside(@NotNull PsiElement element, @NotNull PsiElement djangoElement) {
        if (element == null) {
            DjangoTemplatePsiUtil.$$$reportNull$$$0(3);
        }
        if (djangoElement == null) {
            DjangoTemplatePsiUtil.$$$reportNull$$$0(4);
        }
        while (djangoElement.getParent() != null && !(djangoElement.getParent() instanceof XmlDocument) && djangoElement.getParent().getTextRange() != null && !DjangoTemplatePsiUtil.containsButNotEqual(djangoElement.getParent().getTextRange(), element.getTextRange())) {
            djangoElement = djangoElement.getParent();
        }
        PsiElement psiElement = djangoElement;
        if (psiElement == null) {
            DjangoTemplatePsiUtil.$$$reportNull$$$0(5);
        }
        return psiElement;
    }

    public static List<PsiElement> findAllDjangoElementsInsideOuterLanguageElement(PsiElement outerLangElement, TemplateLanguageFileViewProvider vProvider) {
        PsiFile psi = vProvider.getPsi(vProvider.getBaseLanguage());
        if (psi == null) {
            return Lists.newArrayList();
        }
        PsiElement el = psi.findElementAt(outerLangElement.getTextRange().getStartOffset());
        return DjangoTemplatePsiUtil.findAllDjangoElementsInsideOuterLanguageElementInner(outerLangElement, el);
    }

    public static List<PsiElement> findAllDjangoElementsInsideOuterLanguageElement(PsiElement outerLangElement, PsiElement djangoElement) {
        djangoElement = djangoElement.findElementAt(outerLangElement.getTextOffset());
        return DjangoTemplatePsiUtil.findAllDjangoElementsInsideOuterLanguageElementInner(outerLangElement, djangoElement);
    }

    public static List<PsiElement> findAllDjangoElementsInsideOuterLanguageElementInner(PsiElement outerLangElement, PsiElement djangoElement) {
        ArrayList list = Lists.newArrayList();
        for (djangoElement = DjangoTemplatePsiUtil.biggestElementInside(outerLangElement, djangoElement); djangoElement != null && djangoElement.getTextRange().getEndOffset() <= outerLangElement.getTextRange().getEndOffset(); djangoElement = djangoElement.getNextSibling()) {
            list.add(djangoElement);
        }
        return list;
    }

    @Nullable
    public static String getDjangoExpressionVariable(DjangoTagElementImpl element) {
        DjangoVariableReferenceImpl ref = (DjangoVariableReferenceImpl)PsiTreeUtil.findChildOfType((PsiElement)element, DjangoVariableReferenceImpl.class);
        if (ref != null) {
            return ref.getName();
        }
        return null;
    }

    public static boolean isWhiteSpaceOrComment(@NotNull PsiElement element) {
        if (element == null) {
            DjangoTemplatePsiUtil.$$$reportNull$$$0(6);
        }
        return element.getText().trim().length() == 0 || element instanceof PsiComment || element instanceof PsiWhiteSpace;
    }

    public static PsiElement skipCommentsAndWhitespaces(@NotNull PsiElement element, boolean strict) {
        if (element == null) {
            DjangoTemplatePsiUtil.$$$reportNull$$$0(7);
        }
        if (!strict && !DjangoTemplatePsiUtil.isWhiteSpaceOrComment(element)) {
            return element;
        }
        PsiElement candidate = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)element);
        while (candidate != null && DjangoTemplatePsiUtil.isWhiteSpaceOrComment(candidate)) {
            candidate = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)candidate);
        }
        return candidate;
    }

    public static PsiElement getInjectedHostOrElement(@NotNull PsiElement element) {
        PsiLanguageInjectionHost host;
        if (element == null) {
            DjangoTemplatePsiUtil.$$$reportNull$$$0(8);
        }
        return (host = InjectedLanguageManager.getInstance((Project)element.getProject()).getInjectionHost(element)) != null ? host : element;
    }

    @NotNull
    public static PsiFile getContainingFile(@NotNull PsiElement element) {
        if (element == null) {
            DjangoTemplatePsiUtil.$$$reportNull$$$0(9);
        }
        PsiElement el = DjangoTemplatePsiUtil.getInjectedHostOrElement(element);
        PsiFile psiFile = DjangoTemplateLanguage.getDjangoTemplateFile(el.getContainingFile());
        if (psiFile == null) {
            DjangoTemplatePsiUtil.$$$reportNull$$$0(10);
        }
        return psiFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "biggerRange";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "smallerRange";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "djangoElement";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/django/lang/template/psi/DjangoTemplatePsiUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/django/lang/template/psi/DjangoTemplatePsiUtil";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "biggestElementInside";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainingFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isTemplateCharacters";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "containsButNotEqual";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "biggestElementInside";
                break;
            }
            case 5: 
            case 10: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isWhiteSpaceOrComment";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "skipCommentsAndWhitespaces";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getInjectedHostOrElement";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getContainingFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

