/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.lang.template.parsing.parser;

import com.intellij.lang.PsiBuilder;
import com.jetbrains.django.lang.template.parsing.parser.DjangoTemplateParsing;
import com.jetbrains.django.lang.template.parsing.parser.TagParserRegistry;
import com.jetbrains.django.lang.template.parsing.parser.args.DjangoArgumentedTagParser;
import com.jetbrains.django.lang.template.parsing.parser.args.DjangoCardinalityArgument;
import com.jetbrains.django.lang.template.parsing.parser.args.DjangoIdArgument;
import com.jetbrains.django.lang.template.parsing.parser.args.DjangoTagArgument;
import com.jetbrains.django.lang.template.tags.DjangoBlockTagParser;
import com.jetbrains.django.lang.template.tags.DjangoBlockTransTagParser;
import com.jetbrains.django.lang.template.tags.DjangoCycleTagParser;
import com.jetbrains.django.lang.template.tags.DjangoEndBlockTagParser;
import com.jetbrains.django.lang.template.tags.DjangoExtendsTagParser;
import com.jetbrains.django.lang.template.tags.DjangoFilterTagParser;
import com.jetbrains.django.lang.template.tags.DjangoForTagParser;
import com.jetbrains.django.lang.template.tags.DjangoIfTagParser;
import com.jetbrains.django.lang.template.tags.DjangoIncludeTagParser;
import com.jetbrains.django.lang.template.tags.DjangoLoadTagParser;
import com.jetbrains.django.lang.template.tags.DjangoRegroupTagParser;
import com.jetbrains.django.lang.template.tags.DjangoStaticPrefixTagParser;
import com.jetbrains.django.lang.template.tags.DjangoStaticTagParser;
import com.jetbrains.django.lang.template.tags.DjangoUrlTagParser;
import com.jetbrains.django.lang.template.tags.DjangoWithTagParser;
import com.jetbrains.django.ui.DjangoBundle;
import org.jetbrains.annotations.NotNull;

public abstract class DjangoTagParser<T extends DjangoTemplateParsing> {
    public static TagParserRegistry<DjangoTemplateParsing> DJANGO_TAG_PARSER_REGISTRY = new TagParserRegistry<DjangoTemplateParsing>().with("if", new DjangoIfTagParser()).with("elif", (DjangoTagParser<DjangoTemplateParsing>)new DjangoIfTagParser()).with("for", (DjangoTagParser<DjangoTemplateParsing>)new DjangoForTagParser()).with("filter", new DjangoFilterTagParser()).with("include", (DjangoTagParser<DjangoTemplateParsing>)new DjangoIncludeTagParser()).with("extends", new DjangoExtendsTagParser()).with("with", (DjangoTagParser<DjangoTemplateParsing>)new DjangoWithTagParser()).with("blocktrans", (DjangoTagParser<DjangoTemplateParsing>)new DjangoBlockTransTagParser()).with("load", (DjangoTagParser<DjangoTemplateParsing>)new DjangoLoadTagParser()).with("url", (DjangoTagParser<DjangoTemplateParsing>)new DjangoUrlTagParser()).with("block", new DjangoBlockTagParser(null)).with("endblock", new DjangoEndBlockTagParser(null)).with("cycle", (DjangoTagParser<DjangoTemplateParsing>)new DjangoCycleTagParser()).with("autoescape", DjangoTagParser.argparser(DjangoTagParser.one(DjangoTagParser.id("on", "off")))).with("templatetag", DjangoTagParser.argparser(DjangoTagParser.one(DjangoTagParser.id("openblock", "closeblock", "openvariable", "closevariable", "openbrace", "closebrace", "opencomment", "closecomment")))).with(new String[]{"ifequal", "ifnotequal"}, DjangoTagParser.argparser(DjangoTagParser.two(DjangoTagParser.idOrLiteral()))).with("firstof", DjangoTagParser.argparser(DjangoTagParser.many(DjangoTagParser.idOrLiteral()))).with("now", DjangoTagParser.argparser(DjangoTagParser.one(DjangoTagParser.stringLiteral()), DjangoTagParser.optional(DjangoTagParser.asAndId()))).with("ssi", DjangoTagParser.argparser(DjangoTagParser.one(DjangoTagParser.path()), DjangoTagParser.optional(DjangoTagParser.id("parsed")))).with("regroup", (DjangoTagParser<DjangoTemplateParsing>)new DjangoRegroupTagParser()).with("get_static_prefix", (DjangoTagParser<DjangoTemplateParsing>)new DjangoStaticPrefixTagParser()).with("get_media_prefix", (DjangoTagParser<DjangoTemplateParsing>)new DjangoStaticPrefixTagParser()).with("static", new DjangoStaticTagParser());

    public static void memberExpected(@NotNull PsiBuilder builder) {
        if (builder == null) {
            DjangoTagParser.$$$reportNull$$$0(0);
        }
        builder.error(DjangoBundle.message("django.parse.error.member.literal.expected", new Object[0]));
    }

    public abstract void parse(PsiBuilder var1, PsiBuilder.Marker var2, T var3);

    static <T extends DjangoTemplateParsing> DjangoTagParser<T> argparser(DjangoTagArgument ... arguments) {
        return new DjangoArgumentedTagParser(arguments);
    }

    static DjangoTagArgument id(String ... options) {
        return new DjangoIdArgument(options);
    }

    static DjangoTagArgument path() {
        return new DjangoTagArgument(){

            @Override
            public boolean parse(PsiBuilder builder, DjangoTemplateParsing templateParser) {
                boolean flag = false;
                if (templateParser.isStringLiteral()) {
                    templateParser.parseStringLiteral();
                    flag = true;
                } else {
                    while (builder.getTokenType() == SLASH) {
                        builder.advanceLexer();
                        if (!templateParser.parseId()) {
                            flag = false;
                            break;
                        }
                        flag = true;
                    }
                }
                if (!flag) {
                    this.setError("Path expected.");
                }
                return flag;
            }
        };
    }

    static DjangoTagArgument idOrLiteral() {
        return new DjangoTagArgument(){

            @Override
            public boolean parse(PsiBuilder builder, DjangoTemplateParsing templateParser) {
                if (templateParser.parseMemberLiteral(false)) {
                    return true;
                }
                this.setError("Id or literal expected.");
                return false;
            }
        };
    }

    @NotNull
    static DjangoTagArgument asAndId() {
        return new DjangoTagArgument(){

            @Override
            public boolean parse(PsiBuilder builder, DjangoTemplateParsing templateParser) {
                if (builder.getTokenType() == AS) {
                    return templateParser.parseAsExpression(true);
                }
                return false;
            }
        };
    }

    static DjangoTagArgument stringLiteral() {
        return new DjangoTagArgument(){

            @Override
            public boolean parse(PsiBuilder builder, DjangoTemplateParsing templateParser) {
                if (templateParser.parseStringLiteral()) {
                    return true;
                }
                this.setError("String literal expected.");
                return false;
            }
        };
    }

    static DjangoTagArgument optional(DjangoTagArgument arg) {
        return new DjangoCardinalityArgument(arg, 0, 1);
    }

    static DjangoTagArgument two(DjangoTagArgument arg) {
        return new DjangoCardinalityArgument(arg, 2, 2);
    }

    static DjangoTagArgument one(DjangoTagArgument arg) {
        return new DjangoCardinalityArgument(arg, 1, 1);
    }

    static DjangoTagArgument many(DjangoTagArgument arg) {
        return new DjangoCardinalityArgument(arg, 1, -1);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/jetbrains/django/lang/template/parsing/parser/DjangoTagParser", "memberExpected"));
    }
}

