/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.lang.template.inspection.incompatible;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ex.ProblemDescriptorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.django.lang.template.DjangoTemplateElementGenerator;
import com.jetbrains.django.lang.template.inspection.incompatible.DjangoCompatibilityInfo;
import com.jetbrains.django.lang.template.psi.impl.DjangoUrlViewImpl;
import com.jetbrains.django.lang.template.tags.DjangoUrlTag;
import com.jetbrains.django.ui.DjangoBundle;
import com.jetbrains.django.util.DjangoUtil;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DjangoUrlParamCompatibilityInfo
extends DjangoCompatibilityInfo<DjangoUrlTag> {
    DjangoUrlParamCompatibilityInfo() {
        super(DjangoUtil.createRequirementAtLeast(1, 5), null, DjangoUrlTag.class);
    }

    @Override
    @Nullable
    public ProblemDescriptor processVersion(boolean isVersionGreater, @NotNull DjangoUrlTag tag, @NotNull InspectionManager inspectionManager) {
        DjangoUrlViewImpl view;
        if (tag == null) {
            DjangoUrlParamCompatibilityInfo.$$$reportNull$$$0(0);
        }
        if (inspectionManager == null) {
            DjangoUrlParamCompatibilityInfo.$$$reportNull$$$0(1);
        }
        if ((view = tag.getUrlView()) != null) {
            boolean correct;
            boolean bl = correct = isVersionGreater == view.isInQuotes();
            if (!correct) {
                return new ProblemDescriptorImpl((PsiElement)view, (PsiElement)view, DjangoUrlParamCompatibilityInfo.getMessageText(), new LocalQuickFix[]{new AddQuotesFix(isVersionGreater, view)}, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false, null, false);
            }
        }
        return null;
    }

    private static String getMessageText() {
        return DjangoBundle.message("inspection.incompatible.url_tag.error", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "tag";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "inspectionManager";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/django/lang/template/inspection/incompatible/DjangoUrlParamCompatibilityInfo";
        objectArray[2] = "processVersion";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class AddQuotesFix
    implements LocalQuickFix {
        private static final Pattern QUOTE = Pattern.compile("\"");
        private final boolean myIsDjango5orMore;
        @NotNull
        private final SmartPsiElementPointer<DjangoUrlViewImpl> myViewToChange;
        @NotNull
        private final String myMessage;

        private AddQuotesFix(boolean isDjango5orMore, @NotNull DjangoUrlViewImpl viewToChange) {
            if (viewToChange == null) {
                AddQuotesFix.$$$reportNull$$$0(0);
            }
            this.myIsDjango5orMore = isDjango5orMore;
            this.myViewToChange = SmartPointerManager.createPointer((PsiElement)viewToChange);
            this.myMessage = isDjango5orMore ? DjangoBundle.message("inspection.incompatible.fix.url_tag.add_quotes", new Object[0]) : DjangoBundle.message("inspection.incompatible.fix.url_tag.remove_quotes", new Object[0]);
        }

        @NotNull
        public String getFamilyName() {
            String string = this.myMessage;
            if (string == null) {
                AddQuotesFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            DjangoUrlViewImpl viewToChange;
            if (project == null) {
                AddQuotesFix.$$$reportNull$$$0(2);
            }
            if (descriptor2 == null) {
                AddQuotesFix.$$$reportNull$$$0(3);
            }
            if ((viewToChange = (DjangoUrlViewImpl)this.myViewToChange.getElement()) == null) {
                return;
            }
            String currentText = viewToChange.getText();
            String text2 = this.myIsDjango5orMore ? '\'' + currentText + '\'' : QUOTE.matcher(currentText).replaceAll("");
            DjangoTemplateElementGenerator generator = DjangoTemplateElementGenerator.getInstance(project);
            DjangoUrlViewImpl newView = (DjangoUrlViewImpl)PsiTreeUtil.findChildOfType((PsiElement)generator.createTag("url", text2), DjangoUrlViewImpl.class);
            assert (newView != null) : "No url view generated!";
            viewToChange.replace((PsiElement)newView);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "viewToChange";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/django/lang/template/inspection/incompatible/DjangoUrlParamCompatibilityInfo$AddQuotesFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/django/lang/template/inspection/incompatible/DjangoUrlParamCompatibilityInfo$AddQuotesFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

