/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.lang.template.inspection.incompatible;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.django.lang.template.inspection.DjangoInspectionVisitorAdapter;
import com.jetbrains.django.lang.template.inspection.DjangoLocalInspectionTool;
import com.jetbrains.django.lang.template.inspection.incompatible.DjangoBlockTransAsVarCompatibilityInfo;
import com.jetbrains.django.lang.template.inspection.incompatible.DjangoBlockTransTrimmedCompatibilityInfo;
import com.jetbrains.django.lang.template.inspection.incompatible.DjangoCompatibilityInfo;
import com.jetbrains.django.lang.template.inspection.incompatible.DjangoIfIsCompatibilityInfo;
import com.jetbrains.django.lang.template.inspection.incompatible.DjangoNowAsCompatibilityInfo;
import com.jetbrains.django.lang.template.inspection.incompatible.DjangoUrlParamCompatibilityInfo;
import com.jetbrains.django.lang.template.inspection.incompatible.DjangoVersionObtainer;
import com.jetbrains.django.lang.template.tags.DjangoTag;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DjangoIncompatibleInspection
extends DjangoLocalInspectionTool {
    private static final List<DjangoCompatibilityInfo<?>> COMPATIBILITY_INFOS = Arrays.asList(new DjangoUrlParamCompatibilityInfo(), new DjangoBlockTransTrimmedCompatibilityInfo(), new DjangoBlockTransAsVarCompatibilityInfo(), new DjangoNowAsCompatibilityInfo(), new DjangoIfIsCompatibilityInfo());
    @NotNull
    private final DjangoVersionObtainer myVersionObtainer;

    public DjangoIncompatibleInspection() {
        this(new DjangoVersionObtainer());
    }

    public DjangoIncompatibleInspection(@NotNull DjangoVersionObtainer versionObtainer) {
        if (versionObtainer == null) {
            DjangoIncompatibleInspection.$$$reportNull$$$0(0);
        }
        this.myVersionObtainer = versionObtainer;
    }

    @Override
    protected PsiElementVisitor createInspectionVisitor(InspectionManager manager) {
        return new DjangoIncompatibleVisitor(manager);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "versionObtainer", "com/jetbrains/django/lang/template/inspection/incompatible/DjangoIncompatibleInspection", "<init>"));
    }

    private final class DjangoIncompatibleVisitor
    extends DjangoInspectionVisitorAdapter {
        private DjangoIncompatibleVisitor(InspectionManager manager) {
            if (manager == null) {
                DjangoIncompatibleVisitor.$$$reportNull$$$0(0);
            }
            super(manager);
        }

        @Override
        public void visitTag(@NotNull DjangoTag djangoTag) {
            if (djangoTag == null) {
                DjangoIncompatibleVisitor.$$$reportNull$$$0(1);
            }
            for (DjangoCompatibilityInfo info : COMPATIBILITY_INFOS) {
                ProblemDescriptor descriptor2;
                Boolean isVersionGreater;
                if (!info.getTagClass().isAssignableFrom(((Object)((Object)djangoTag)).getClass()) || (isVersionGreater = DjangoIncompatibleInspection.this.myVersionObtainer.getIsDjangoVersionOrMore(info.getRequirement(), (PsiElement)djangoTag)) == null || (descriptor2 = this.processVersionSafely(djangoTag, info, isVersionGreater)) == null) continue;
                this.myProblems.add(descriptor2);
            }
        }

        @Nullable
        private ProblemDescriptor processVersionSafely(@NotNull DjangoTag djangoTag, @NotNull DjangoCompatibilityInfo<? extends DjangoTag> info, boolean isVersionGreater) {
            if (djangoTag == null) {
                DjangoIncompatibleVisitor.$$$reportNull$$$0(2);
            }
            if (info == null) {
                DjangoIncompatibleVisitor.$$$reportNull$$$0(3);
            }
            assert (info.getTagClass().isAssignableFrom(((Object)((Object)djangoTag)).getClass())) : "bad django tag type";
            DjangoCompatibilityInfo<? extends DjangoTag> saveInfo = info;
            return saveInfo.processVersion(isVersionGreater, djangoTag, this.myManager);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "manager";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "djangoTag";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/django/lang/template/inspection/incompatible/DjangoIncompatibleInspection$DjangoIncompatibleVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitTag";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processVersionSafely";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

