/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.lang.template.inspection;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.jetbrains.django.lang.template.inspection.DjangoInspectionVisitorAdapter;
import com.jetbrains.django.lang.template.inspection.DjangoLocalInspectionTool;
import com.jetbrains.django.lang.template.ref.DjangoLoadTagsReference;
import com.jetbrains.django.lang.template.ref.DjangoLoadedNameReference;
import com.jetbrains.django.lang.template.tags.DjangoLoadTag;
import com.jetbrains.django.ui.DjangoBundle;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class UnresolvedLoadReferenceInspection
extends DjangoLocalInspectionTool {
    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = DjangoBundle.message("django", new Object[0]);
        if (string == null) {
            UnresolvedLoadReferenceInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        return "DjangoUnresolvedLoadInspection";
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    protected PsiElementVisitor createInspectionVisitor(InspectionManager manager) {
        return new DjangoTagVisitor(manager);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/django/lang/template/inspection/UnresolvedLoadReferenceInspection", "getGroupDisplayName"));
    }

    private static class DjangoTagVisitor
    extends DjangoInspectionVisitorAdapter {
        private DjangoTagVisitor(InspectionManager manager) {
            super(manager);
        }

        @Override
        public void visitLoadTag(DjangoLoadTag loadTag) {
            for (PsiReference ref : loadTag.getReferences()) {
                ASTNode memberNode;
                if (ref instanceof DjangoLoadTagsReference && ref.resolve() == null) {
                    memberNode = ((DjangoLoadTagsReference)ref).getMemberNode();
                    if (memberNode == null) continue;
                    this.reportProblem(memberNode.getPsi(), DjangoBundle.message("inspection.unresolved-load.error-msg", memberNode.getPsi().getText()));
                    continue;
                }
                if (!(ref instanceof DjangoLoadedNameReference) || ref.resolve() != null || (memberNode = ((DjangoLoadedNameReference)ref).getMemberNode()) == null) continue;
                this.reportProblem(memberNode.getPsi(), DjangoBundle.message("inspection.unresolved-name.error-msg", memberNode.getPsi().getText()));
            }
        }

        private void reportProblem(PsiElement elem, String msg) {
            ProblemDescriptor d = this.myManager.createProblemDescriptor(elem, new TextRange(0, elem.getTextLength()), msg, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false, new LocalQuickFix[0]);
            this.myProblems.add(d);
        }
    }
}

