/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.lang.template.inspection;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.django.lang.template.DjangoTemplateCloseTagHandlingVisitor;
import com.jetbrains.django.lang.template.inspection.DjangoInspectionVisitor;
import com.jetbrains.django.lang.template.inspection.DjangoLocalInspectionTool;
import com.jetbrains.django.lang.template.psi.DjangoTagName;
import com.jetbrains.django.lang.template.psi.impl.DjangoTagElementImpl;
import com.jetbrains.django.ui.DjangoBundle;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class TemplateCloseTagInspection
extends DjangoLocalInspectionTool {
    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = DjangoBundle.message("django", new Object[0]);
        if (string == null) {
            TemplateCloseTagInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        return "DjangoCloseTagInspection";
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    protected PsiElementVisitor createInspectionVisitor(InspectionManager manager) {
        return new DjangoTagVisitor(manager);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/django/lang/template/inspection/TemplateCloseTagInspection", "getGroupDisplayName"));
    }

    private static class DjangoTagVisitor
    extends DjangoTemplateCloseTagHandlingVisitor
    implements DjangoInspectionVisitor {
        private final List<ProblemDescriptor> myProblems = new ArrayList<ProblemDescriptor>();
        private final InspectionManager myManager;

        private DjangoTagVisitor(InspectionManager manager) {
            this.myManager = manager;
        }

        @Override
        protected void handleTagClosed(@NotNull DjangoTagName openTag, @NotNull DjangoTagName closeTag) {
            if (openTag == null) {
                DjangoTagVisitor.$$$reportNull$$$0(0);
            }
            if (closeTag == null) {
                DjangoTagVisitor.$$$reportNull$$$0(1);
            }
        }

        @Override
        protected void handleCloseTagWithoutOpened(@NotNull DjangoTagName closeTag) {
            if (closeTag == null) {
                DjangoTagVisitor.$$$reportNull$$$0(2);
            }
            this.reportCloseTagWithoutOpened(closeTag);
        }

        @Override
        protected void handleMiddleWithoutOpened(@NotNull DjangoTagName middleTag) {
            if (middleTag == null) {
                DjangoTagVisitor.$$$reportNull$$$0(3);
            }
            this.reportMiddleTagWithoutOpen(middleTag);
        }

        @Override
        protected void handleOpenedTagWithoutClosed(@NotNull DjangoTagName openedTag) {
            if (openedTag == null) {
                DjangoTagVisitor.$$$reportNull$$$0(4);
            }
            this.reportOpenTagWithoutClosing(openedTag);
        }

        @NotNull
        private static PsiElement substitute(@NotNull DjangoTagName tagName) {
            DjangoTagElementImpl parent;
            if (tagName == null) {
                DjangoTagVisitor.$$$reportNull$$$0(5);
            }
            Object object = (parent = (DjangoTagElementImpl)PsiTreeUtil.getParentOfType((PsiElement)tagName, DjangoTagElementImpl.class)) != null ? parent : tagName;
            if (object == null) {
                DjangoTagVisitor.$$$reportNull$$$0(6);
            }
            return object;
        }

        private void reportOpenTagWithoutClosing(DjangoTagName openTag) {
            this.reportProblem(openTag, DjangoBundle.message("inspection.error.open-tag-without-closed", openTag.getTagName()));
        }

        private void reportMiddleTagWithoutOpen(DjangoTagName middleTag) {
            this.reportProblem(middleTag, DjangoBundle.message("inspection.error.middle-tag-without-opened", middleTag.getTagName()));
        }

        private void reportCloseTagWithoutOpened(DjangoTagName closeTag) {
            this.reportProblem(closeTag, DjangoBundle.message("inspection.error.no-opened-tag", new Object[0]));
        }

        private void reportProblem(DjangoTagName elem, String msg) {
            ProblemDescriptor d = this.myManager.createProblemDescriptor(DjangoTagVisitor.substitute(elem), new TextRange(0, DjangoTagVisitor.substitute(elem).getTextLength()), msg, ProblemHighlightType.GENERIC_ERROR, false, new LocalQuickFix[0]);
            this.myProblems.add(d);
        }

        @Override
        public void postprocess() {
            this.reportOpenedTagWithoutCloseTags();
        }

        private void reportOpenedTagWithoutCloseTags() {
            for (DjangoTagName tag : this.getOpenedTags()) {
                this.reportProblem(tag, DjangoBundle.message("inspection.error.no-closing-tag", new Object[0]));
            }
        }

        @Override
        public List<ProblemDescriptor> getProblems() {
            return this.myProblems;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "openTag";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "closeTag";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "middleTag";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "openedTag";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tagName";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/django/lang/template/inspection/TemplateCloseTagInspection$DjangoTagVisitor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/django/lang/template/inspection/TemplateCloseTagInspection$DjangoTagVisitor";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "substitute";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "handleTagClosed";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "handleCloseTagWithoutOpened";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "handleMiddleWithoutOpened";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "handleOpenedTagWithoutClosed";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "substitute";
                    break;
                }
                case 6: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

