/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.lang.template.inspection;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.django.lang.template.inspection.DjangoProblemHolderVisitor;
import com.jetbrains.django.lang.template.tags.DjangoBlockTag;
import com.jetbrains.django.ui.DjangoBundle;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class DuplicatedBlockNamesInspection
extends LocalInspectionTool {
    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = DjangoBundle.message("django", new Object[0]);
        if (string == null) {
            DuplicatedBlockNamesInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        return "DuplicatedBlockNamesInspection";
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            DuplicatedBlockNamesInspection.$$$reportNull$$$0(1);
        }
        return new Visitor(holder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/django/lang/template/inspection/DuplicatedBlockNamesInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/django/lang/template/inspection/DuplicatedBlockNamesInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Visitor
    extends DjangoProblemHolderVisitor {
        private final Set<String> myNames = new HashSet<String>();

        Visitor(ProblemsHolder holder) {
            super(holder);
        }

        @Override
        public void visitBlockTag(DjangoBlockTag blockTag) {
            String name = blockTag.getBlockName();
            if (this.myNames.contains(name)) {
                this.registerProblem((PsiElement)blockTag, DjangoBundle.message("INSP.NAME.name.$0.is.duplicated", name));
            } else {
                this.myNames.add(name);
            }
        }
    }
}

