/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.lang.template.inspection;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.django.lang.template.inspection.DjangoInspectionVisitorAdapter;
import com.jetbrains.django.lang.template.inspection.DjangoLocalInspectionTool;
import com.jetbrains.django.lang.template.parsing.DjangoTemplateTokenTypes;
import com.jetbrains.django.lang.template.psi.impl.DjangoRelationExpressionImpl;
import com.jetbrains.django.ui.DjangoBundle;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DjangoRelationInspection
extends DjangoLocalInspectionTool {
    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = DjangoBundle.message("django", new Object[0]);
        if (string == null) {
            DjangoRelationInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        return "DjangoRelationInspection";
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    protected PsiElementVisitor createInspectionVisitor(InspectionManager manager) {
        return new DjangoTagVisitor(manager);
    }

    private static boolean noWhitespace(@Nullable ASTNode node) {
        return node != null && !DjangoTemplateTokenTypes.WHITESPACES.contains(node.getElementType());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/django/lang/template/inspection/DjangoRelationInspection", "getGroupDisplayName"));
    }

    private static class DjangoTagVisitor
    extends DjangoInspectionVisitorAdapter {
        private DjangoTagVisitor(@NotNull InspectionManager manager) {
            if (manager == null) {
                DjangoTagVisitor.$$$reportNull$$$0(0);
            }
            super(manager);
        }

        @Override
        public void visitRelationExpression(DjangoRelationExpressionImpl relationExpression) {
            ASTNode relation = relationExpression.getNode().findChildByType(DjangoTemplateTokenTypes.DJANGO_RELATION_OPERATORS);
            if (relation != null) {
                boolean before = false;
                boolean after = false;
                if (DjangoRelationInspection.noWhitespace(relation.getTreePrev())) {
                    before = true;
                }
                if (DjangoRelationInspection.noWhitespace(relation.getTreeNext())) {
                    after = true;
                }
                if (before || after) {
                    this.reportProblem(relation.getPsi(), "Whitespace expected " + (before ? "before " : "") + (after && before ? "and " : "") + (after ? "after " : "") + "of the relation operator");
                }
            }
        }

        private void reportProblem(PsiElement elem, String msg) {
            ProblemDescriptor d = this.myManager.createProblemDescriptor(elem, new TextRange(0, elem.getTextLength()), msg, ProblemHighlightType.GENERIC_ERROR, false, new LocalQuickFix[0]);
            this.myProblems.add(d);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/jetbrains/django/lang/template/inspection/DjangoRelationInspection$DjangoTagVisitor", "<init>"));
        }
    }
}

