/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.lang.template.highlighting;

import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.util.LayerDescriptor;
import com.intellij.openapi.editor.ex.util.LayeredLexerEditorHighlighter;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.django.lang.template.parsing.DjangoTemplateTokenTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DjangoTemplateEditorHighlighter
extends LayeredLexerEditorHighlighter {
    @Nullable
    private Language myTemplateLanguage;
    @Nullable
    private final Project myProject;
    @NotNull
    private final VirtualFile myFile;
    @Nullable
    private final Language myBaseLanguage;

    public DjangoTemplateEditorHighlighter(@NotNull EditorColorsScheme scheme, @Nullable Project project, @Nullable VirtualFile file2, Language templateLanguage) {
        if (scheme == null) {
            DjangoTemplateEditorHighlighter.$$$reportNull$$$0(0);
        }
        super(SyntaxHighlighterFactory.getSyntaxHighlighter((Language)templateLanguage, (Project)project, (VirtualFile)file2), scheme);
        this.myProject = project;
        this.myFile = file2;
        this.myBaseLanguage = templateLanguage;
    }

    @Nullable
    private Language getTemplateLanguage(@Nullable VirtualFile file2) {
        if (file2 == null) {
            return null;
        }
        LanguageFileType fileType = (LanguageFileType)file2.getFileType();
        if (fileType.getLanguage() == this.myBaseLanguage) {
            return HTMLLanguage.INSTANCE;
        }
        return fileType.getLanguage();
    }

    protected boolean updateLayers() {
        Language templateLanguage = this.getTemplateLanguage(this.myFile);
        if (!Comparing.equal((Object)this.myTemplateLanguage, (Object)templateLanguage)) {
            this.unregisterLayer(DjangoTemplateTokenTypes.TEMPLATE_CHARACTERS);
            this.myTemplateLanguage = templateLanguage;
            SyntaxHighlighter templateLanguageHighlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)this.myTemplateLanguage, (Project)this.myProject, (VirtualFile)this.myFile);
            this.registerLayer(DjangoTemplateTokenTypes.TEMPLATE_CHARACTERS, new LayerDescriptor(templateLanguageHighlighter, "", null));
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/jetbrains/django/lang/template/highlighting/DjangoTemplateEditorHighlighter", "<init>"));
    }
}

