/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.lang.template.editor;

import com.intellij.codeInsight.generation.CommenterWithLineSuffix;
import com.intellij.lang.CustomUncommenter;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.TextRange;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DjangoTemplateCommenter
implements CustomUncommenter,
CommenterWithLineSuffix {
    private static final Pattern COMMENT_RANGE_REGEX = Pattern.compile("(\\{% *comment .*?(?<!%})%}.*\\{% *endcomment *%})", 32);
    private static final Pattern COMMENTS_REGEX = Pattern.compile("(\\{% *comment .*?(?<!%})%}\\r?\\n?).*?(\\{% *endcomment *%})", 32);

    public String getLineCommentPrefix() {
        return "{#";
    }

    @NotNull
    public String getLineCommentSuffix() {
        return "#}";
    }

    @Nullable
    public String getCommentedBlockCommentPrefix() {
        return null;
    }

    @Nullable
    public String getCommentedBlockCommentSuffix() {
        return null;
    }

    public String getBlockCommentPrefix() {
        return "{% comment %}";
    }

    public String getBlockCommentSuffix() {
        return "{% endcomment %}";
    }

    @Nullable
    public TextRange findMaximumCommentedRange(@NotNull CharSequence text2) {
        Matcher matcher;
        if (text2 == null) {
            DjangoTemplateCommenter.$$$reportNull$$$0(0);
        }
        if (!(matcher = COMMENT_RANGE_REGEX.matcher(text2)).find()) {
            return null;
        }
        return new TextRange(matcher.start(1), matcher.end(1));
    }

    @NotNull
    public List<Couple<TextRange>> getCommentRangesToDelete(@NotNull CharSequence text2) {
        if (text2 == null) {
            DjangoTemplateCommenter.$$$reportNull$$$0(1);
        }
        ArrayList<Couple<TextRange>> result = new ArrayList<Couple<TextRange>>();
        Matcher matcher = COMMENTS_REGEX.matcher(text2);
        while (matcher.find()) {
            result.add((Couple<TextRange>)Couple.of((Object)new TextRange(matcher.start(1), matcher.end(1)), (Object)new TextRange(matcher.start(2), matcher.end(2))));
        }
        ArrayList<Couple<TextRange>> arrayList = result;
        if (arrayList == null) {
            DjangoTemplateCommenter.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/django/lang/template/editor/DjangoTemplateCommenter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/django/lang/template/editor/DjangoTemplateCommenter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommentRangesToDelete";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findMaximumCommentedRange";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getCommentRangesToDelete";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

