/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.lang.template;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.django.lang.template.DjangoTemplateFileType;
import com.jetbrains.django.lang.template.DjangoTemplateLanguage;
import com.jetbrains.django.lang.template.psi.impl.DjangoFilterNameImpl;
import com.jetbrains.django.lang.template.psi.impl.DjangoMemberExpressionImpl;
import com.jetbrains.django.lang.template.psi.impl.DjangoMemberNameImpl;
import com.jetbrains.django.lang.template.psi.impl.DjangoStringLiteralImpl;
import com.jetbrains.django.lang.template.psi.impl.DjangoTagElementImpl;
import com.jetbrains.django.lang.template.psi.impl.DjangoTagNameImpl;
import com.jetbrains.django.lang.template.psi.impl.DjangoVariableReferenceImpl;
import com.jetbrains.python.psi.PyStringLiteralUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DjangoTemplateElementGenerator {
    private final Project myProject;

    public DjangoTemplateElementGenerator(Project project) {
        this.myProject = project;
    }

    public static DjangoTemplateElementGenerator getInstance(Project project) {
        return (DjangoTemplateElementGenerator)ServiceManager.getService((Project)project, DjangoTemplateElementGenerator.class);
    }

    @NotNull
    public DjangoVariableReferenceImpl createVariableReference(@NotNull String name) {
        if (name == null) {
            DjangoTemplateElementGenerator.$$$reportNull$$$0(0);
        }
        PsiFile tempFile = this.createTempFile("{{ " + name + " }}");
        DjangoVariableReferenceImpl djangoVariableReferenceImpl = (DjangoVariableReferenceImpl)((Object)PsiTreeUtil.collectElementsOfType((PsiElement)tempFile, (Class[])new Class[]{DjangoVariableReferenceImpl.class}).iterator().next());
        if (djangoVariableReferenceImpl == null) {
            DjangoTemplateElementGenerator.$$$reportNull$$$0(1);
        }
        return djangoVariableReferenceImpl;
    }

    @NotNull
    public DjangoFilterNameImpl createFilterName(@NotNull String name) {
        if (name == null) {
            DjangoTemplateElementGenerator.$$$reportNull$$$0(2);
        }
        PsiFile tempFile = this.createTempFile("{{ x|" + name + " }}");
        DjangoFilterNameImpl djangoFilterNameImpl = (DjangoFilterNameImpl)PsiTreeUtil.collectElementsOfType((PsiElement)tempFile, (Class[])new Class[]{DjangoFilterNameImpl.class}).iterator().next();
        if (djangoFilterNameImpl == null) {
            DjangoTemplateElementGenerator.$$$reportNull$$$0(3);
        }
        return djangoFilterNameImpl;
    }

    @NotNull
    public DjangoMemberExpressionImpl createLoadTagReference(@NotNull String name) {
        if (name == null) {
            DjangoTemplateElementGenerator.$$$reportNull$$$0(4);
        }
        name = FileUtilRt.getNameWithoutExtension((String)name);
        PsiFile tempFile = this.createTempFile("{% load " + name + " %}");
        DjangoMemberExpressionImpl djangoMemberExpressionImpl = (DjangoMemberExpressionImpl)((Object)PsiTreeUtil.collectElementsOfType((PsiElement)tempFile, (Class[])new Class[]{DjangoMemberExpressionImpl.class}).iterator().next());
        if (djangoMemberExpressionImpl == null) {
            DjangoTemplateElementGenerator.$$$reportNull$$$0(5);
        }
        return djangoMemberExpressionImpl;
    }

    @NotNull
    public DjangoMemberNameImpl createLoadedNameReference(@NotNull String name) {
        if (name == null) {
            DjangoTemplateElementGenerator.$$$reportNull$$$0(6);
        }
        PsiFile tempFile = this.createTempFile("{% load " + name + " from foo %}");
        DjangoMemberNameImpl djangoMemberNameImpl = (DjangoMemberNameImpl)((Object)PsiTreeUtil.collectElementsOfType((PsiElement)tempFile, (Class[])new Class[]{DjangoMemberNameImpl.class}).iterator().next());
        if (djangoMemberNameImpl == null) {
            DjangoTemplateElementGenerator.$$$reportNull$$$0(7);
        }
        return djangoMemberNameImpl;
    }

    @NotNull
    public ASTNode createNameIdentifier(@NotNull String name) {
        if (name == null) {
            DjangoTemplateElementGenerator.$$$reportNull$$$0(8);
        }
        PsiFile tempFile = this.createTempFile("{% for " + name + " in books %}");
        ASTNode aSTNode = tempFile.getFirstChild().getFirstChild().getFirstChild().getNextSibling().getNextSibling().getNode().getFirstChildNode().getPsi().getNextSibling().getNextSibling().getNode();
        if (aSTNode == null) {
            DjangoTemplateElementGenerator.$$$reportNull$$$0(9);
        }
        return aSTNode;
    }

    @NotNull
    public DjangoStringLiteralImpl createStringLiteral(@NotNull String name) {
        if (name == null) {
            DjangoTemplateElementGenerator.$$$reportNull$$$0(10);
        }
        assert (PyStringLiteralUtil.isQuoted(name));
        PsiFile tempFile = this.createTempFile("{% extends " + name + " %}");
        DjangoStringLiteralImpl djangoStringLiteralImpl = (DjangoStringLiteralImpl)PsiTreeUtil.findChildOfType((PsiElement)tempFile, DjangoStringLiteralImpl.class);
        if (djangoStringLiteralImpl == null) {
            DjangoTemplateElementGenerator.$$$reportNull$$$0(11);
        }
        return djangoStringLiteralImpl;
    }

    @NotNull
    public DjangoMemberExpressionImpl createMemberExpression(@NotNull String name) {
        if (name == null) {
            DjangoTemplateElementGenerator.$$$reportNull$$$0(12);
        }
        PsiFile tempFile = this.createTempFile("{% url " + name + " %}");
        DjangoMemberExpressionImpl djangoMemberExpressionImpl = (DjangoMemberExpressionImpl)PsiTreeUtil.findChildOfType((PsiElement)tempFile, DjangoMemberExpressionImpl.class);
        if (djangoMemberExpressionImpl == null) {
            DjangoTemplateElementGenerator.$$$reportNull$$$0(13);
        }
        return djangoMemberExpressionImpl;
    }

    @NotNull
    public DjangoMemberNameImpl createMemberName(@NotNull String name) {
        if (name == null) {
            DjangoTemplateElementGenerator.$$$reportNull$$$0(14);
        }
        PsiFile tempFile = this.createTempFile("{% url " + name + " %}");
        DjangoMemberNameImpl djangoMemberNameImpl = (DjangoMemberNameImpl)PsiTreeUtil.findChildOfType((PsiElement)tempFile, DjangoMemberNameImpl.class);
        if (djangoMemberNameImpl == null) {
            DjangoTemplateElementGenerator.$$$reportNull$$$0(15);
        }
        return djangoMemberNameImpl;
    }

    @NotNull
    public DjangoTagElementImpl createTag(@NotNull String name) {
        if (name == null) {
            DjangoTemplateElementGenerator.$$$reportNull$$$0(16);
        }
        DjangoTagElementImpl djangoTagElementImpl = this.createTag(name, null);
        if (djangoTagElementImpl == null) {
            DjangoTemplateElementGenerator.$$$reportNull$$$0(17);
        }
        return djangoTagElementImpl;
    }

    @NotNull
    public DjangoTagNameImpl createTagName(@NotNull String name) {
        if (name == null) {
            DjangoTemplateElementGenerator.$$$reportNull$$$0(18);
        }
        DjangoTagElementImpl tag = this.createTag(name, null);
        DjangoTagNameImpl djangoTagNameImpl = (DjangoTagNameImpl)PsiTreeUtil.findChildOfType((PsiElement)tag, DjangoTagNameImpl.class);
        if (djangoTagNameImpl == null) {
            DjangoTemplateElementGenerator.$$$reportNull$$$0(19);
        }
        return djangoTagNameImpl;
    }

    @NotNull
    public DjangoTagElementImpl createTag(@NotNull String name, @Nullable String content2) {
        if (name == null) {
            DjangoTemplateElementGenerator.$$$reportNull$$$0(20);
        }
        PsiFile tempFile = content2 == null && StringUtil.isEmptyOrSpaces((String)content2) ? this.createTempFile("{% " + name + " %}") : this.createTempFile("{% " + name + " " + content2 + " %}");
        DjangoTagElementImpl djangoTagElementImpl = (DjangoTagElementImpl)PsiTreeUtil.findChildOfType((PsiElement)tempFile, DjangoTagElementImpl.class);
        if (djangoTagElementImpl == null) {
            DjangoTemplateElementGenerator.$$$reportNull$$$0(21);
        }
        return djangoTagElementImpl;
    }

    public static PsiElement createMember(@NotNull String fullName, @NotNull Project project) {
        if (fullName == null) {
            DjangoTemplateElementGenerator.$$$reportNull$$$0(22);
        }
        if (project == null) {
            DjangoTemplateElementGenerator.$$$reportNull$$$0(23);
        }
        if (fullName.contains(".")) {
            return DjangoTemplateElementGenerator.getInstance(project).createMemberExpression(fullName);
        }
        return DjangoTemplateElementGenerator.getInstance(project).createMemberName(fullName);
    }

    public PsiFile createTempFile(String contents) {
        return PsiFileFactory.getInstance((Project)this.myProject).createFileFromText("temp." + DjangoTemplateFileType.INSTANCE.getDefaultExtension(), (Language)DjangoTemplateLanguage.INSTANCE, (CharSequence)contents);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/django/lang/template/DjangoTemplateElementGenerator";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullName";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/django/lang/template/DjangoTemplateElementGenerator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createVariableReference";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createFilterName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createLoadTagReference";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createLoadedNameReference";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createNameIdentifier";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createStringLiteral";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createMemberExpression";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createMemberName";
                break;
            }
            case 17: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createTag";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createTagName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createVariableReference";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 21: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createFilterName";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createLoadTagReference";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createLoadedNameReference";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createNameIdentifier";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createStringLiteral";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createMemberExpression";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createMemberName";
                break;
            }
            case 16: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createTag";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createTagName";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createMember";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

