/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.facet;

import com.google.common.collect.Lists;
import com.intellij.DynamicBundle;
import com.intellij.facet.ui.FacetValidatorsManager;
import com.intellij.facet.ui.ValidationResult;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jetbrains.django.facet.DjangoWizardSettingsHolder;
import com.jetbrains.django.ui.DjangoBundle;
import com.jetbrains.python.templateLanguages.TemplateLanguagePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.function.Consumer;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DjangoProjectCreateWizardPanel
extends JPanel {
    private final TemplateLanguagePanel myTemplatesPanel;
    private String myProjectName;
    private JBTextField myAppName;
    private JPanel myMainPanel;
    private JCheckBox myEnableDjangoAdminCheckBox;
    private JPanel myTemplatesPlaceholder;
    private JLabel myAppLabel;
    private final Consumer<? super String> myErrorCallback;

    public DjangoProjectCreateWizardPanel() {
        this((Consumer<? super String>)null);
    }

    public DjangoProjectCreateWizardPanel(@Nullable Consumer<? super String> errorCallback) {
        super(new BorderLayout());
        this.myErrorCallback = errorCallback;
        this.$$$setupUI$$$();
        this.add((Component)this.myMainPanel, "Center");
        this.myTemplatesPanel = new TemplateLanguagePanel(Lists.newArrayList((Object[])new String[]{"Django", "Jinja2"}));
        this.myTemplatesPanel.setTemplateLanguage("Django");
        this.myTemplatesPlaceholder.add(this.myTemplatesPanel);
        this.myAppLabel.setPreferredSize(this.myTemplatesPanel.getLabelSize());
    }

    public TemplateLanguagePanel getTemplatesPanel() {
        return this.myTemplatesPanel;
    }

    public String getProjectName() {
        return this.myProjectName;
    }

    public void setProjectName(String name) {
        this.myProjectName = name;
    }

    public void registerValidators(FacetValidatorsManager validatorsManager) {
        this.myTemplatesPanel.registerValidators(validatorsManager);
        this.myAppName.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                ValidationResult result = DjangoProjectCreateWizardPanel.this.validateDjangoNames(DjangoProjectCreateWizardPanel.this.myProjectName);
                if (DjangoProjectCreateWizardPanel.this.myErrorCallback != null) {
                    DjangoProjectCreateWizardPanel.this.myErrorCallback.accept(result.getErrorMessage());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/django/facet/DjangoProjectCreateWizardPanel$1", "textChanged"));
            }
        });
    }

    public void saveSettings(DjangoWizardSettingsHolder holder) {
        if (this.myProjectName != null) {
            holder.setProjectName(this.myProjectName);
        }
        this.myTemplatesPanel.saveSettings(holder);
        holder.setApplicationName(this.getAppName());
        holder.setEnableAdmin(this.myEnableDjangoAdminCheckBox.isSelected());
    }

    public String getAppName() {
        return this.myAppName.getText();
    }

    public ValidationResult getValidationResult() {
        ValidationResult res = DjangoProjectCreateWizardPanel.validateProjectName(this.myProjectName);
        if (res != ValidationResult.OK) {
            return res;
        }
        return this.validateDjangoNames(this.myProjectName);
    }

    public static ValidationResult validateProjectName(String projectName) {
        if (projectName != null && !StringUtil.isJavaIdentifier((String)projectName)) {
            return new ValidationResult(DjangoBundle.message("django.facet.wizard.error.bad.project.name", new Object[0]));
        }
        return ValidationResult.OK;
    }

    public ValidationResult validateDjangoNames(String projectName) {
        String appName = this.getAppName();
        return DjangoProjectCreateWizardPanel.validateDjangoNames(projectName, appName);
    }

    public static ValidationResult validateDjangoNames(String projectName, String appName) {
        if (appName.length() > 0 && !StringUtil.isJavaIdentifier((String)appName)) {
            return new ValidationResult(DjangoBundle.message("django.facet.wizard.error.bad.app.name", new Object[0]));
        }
        if (appName.equals(projectName)) {
            return new ValidationResult(DjangoBundle.message("django.facet.wizard.error.project.equals.app.name", new Object[0]));
        }
        return ValidationResult.OK;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JBTextField jBTextField;
        JPanel jPanel;
        JPanel jPanel2;
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myTemplatesPlaceholder = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(0, 0, 1, 4, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel = new JBLabel();
        this.myAppLabel = jBLabel;
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/DjangoBundle", DjangoProjectCreateWizardPanel.class).getString("app-name"));
        jPanel2.add((Component)jBLabel, new GridConstraints(1, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myAppName = jBTextField = new JBTextField();
        jPanel2.add((Component)jBTextField, new GridConstraints(1, 1, 1, 3, 0, 1, 3, 3, null, null, null));
        this.myEnableDjangoAdminCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setSelected(true);
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/DjangoBundle", DjangoProjectCreateWizardPanel.class).getString("django.enable.admin"));
        jPanel2.add((Component)jCheckBox, new GridConstraints(2, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(3, 1, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

