/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.codeInsight.djangoForms;

import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.jetbrains.django.DjangoFQNamesProvider;
import com.jetbrains.django.codeInsight.djangoForms.DjangoFormWrapper;
import com.jetbrains.django.model.modelApi.DjangoField;
import com.jetbrains.python.PyStringLiteralReference;
import com.jetbrains.python.nameResolver.NameResolverTools;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyPossibleClassMember;
import com.jetbrains.python.psi.PySequenceExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.StringLiteralExpression;
import com.jetbrains.python.psi.impl.PyEvaluator;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class DjangoFormFieldReference
extends PyStringLiteralReference {
    private final boolean myAllowedFieldsOnly;
    @NotNull
    private final PyTypedElement myPossibleForm;
    @NotNull
    private final TypeEvalContext myDefaultContext;

    DjangoFormFieldReference(@NotNull StringLiteralExpression element, boolean allowedFieldsOnly, @NotNull PyTypedElement possibleForm, @NotNull TypeEvalContext defaultContext) {
        if (element == null) {
            DjangoFormFieldReference.$$$reportNull$$$0(0);
        }
        if (possibleForm == null) {
            DjangoFormFieldReference.$$$reportNull$$$0(1);
        }
        if (defaultContext == null) {
            DjangoFormFieldReference.$$$reportNull$$$0(2);
        }
        super(element);
        this.myAllowedFieldsOnly = allowedFieldsOnly;
        this.myPossibleForm = possibleForm;
        this.myDefaultContext = defaultContext;
    }

    @Nullable
    private Pair<DjangoFormWrapper, TypeEvalContext> getFormWrapper(boolean usedInitiated) {
        LinkedList<TypeEvalContext> contexts = new LinkedList<TypeEvalContext>(Collections.singleton(this.myDefaultContext));
        if (usedInitiated) {
            contexts.addFirst(TypeEvalContext.userInitiated(this.myElement.getProject(), this.myElement.getContainingFile()));
        }
        for (TypeEvalContext context : contexts) {
            DjangoFormWrapper formWrapper = DjangoFormWrapper.getFormWrapper(context, this.myPossibleForm);
            if (formWrapper == null) continue;
            return Pair.create((Object)formWrapper, (Object)context);
        }
        return null;
    }

    public Object @NotNull [] getVariants() {
        List<String> anotherFields = this.getFieldsAlreadyUsed();
        Object[] objectArray = this.getStreamOfFields(true).filter(o -> !anotherFields.contains(o.getName())).map(o -> LookupElementBuilder.create((String)o.getName()).withIcon(AllIcons.Nodes.Field)).toArray();
        if (objectArray == null) {
            DjangoFormFieldReference.$$$reportNull$$$0(3);
        }
        return objectArray;
    }

    @NotNull
    private Stream<DjangoField> getStreamOfFields(boolean userInitiated) {
        Pair<DjangoFormWrapper, TypeEvalContext> wrapperAndContext = this.getFormWrapper(userInitiated);
        if (wrapperAndContext == null) {
            Stream<DjangoField> stream = Stream.empty();
            if (stream == null) {
                DjangoFormFieldReference.$$$reportNull$$$0(4);
            }
            return stream;
        }
        TypeEvalContext context = (TypeEvalContext)wrapperAndContext.second;
        DjangoFormWrapper wrapper2 = (DjangoFormWrapper)wrapperAndContext.first;
        Stream<DjangoField> stream = (this.myAllowedFieldsOnly ? wrapper2.getAllowedFields(context) : wrapper2.getAllFields(context)).stream();
        if (stream == null) {
            DjangoFormFieldReference.$$$reportNull$$$0(5);
        }
        return stream;
    }

    @NotNull
    private List<String> getFieldsAlreadyUsed() {
        PySequenceExpression sequenceExpression = PyUtil.as(this.myElement.getParent(), PySequenceExpression.class);
        if (sequenceExpression == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                DjangoFormFieldReference.$$$reportNull$$$0(6);
            }
            return list;
        }
        List list = PyEvaluator.evaluate(sequenceExpression, List.class);
        if (list == null) {
            List<String> list2 = Collections.emptyList();
            if (list2 == null) {
                DjangoFormFieldReference.$$$reportNull$$$0(7);
            }
            return list2;
        }
        List<String> list3 = list.stream().map(o -> o.toString()).collect(Collectors.toList());
        if (list3 == null) {
            DjangoFormFieldReference.$$$reportNull$$$0(8);
        }
        return list3;
    }

    @Override
    public boolean isSoft() {
        return true;
    }

    @Override
    @Nullable
    public PsiElement userInitiatedResolve() {
        return this.resolveInner(true);
    }

    @Nullable
    public PsiElement resolve() {
        return this.resolveInner(false);
    }

    @Override
    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (element == null) {
            DjangoFormFieldReference.$$$reportNull$$$0(9);
        }
        if (super.isReferenceTo(element)) {
            return true;
        }
        if (!(element instanceof PyTargetExpression)) {
            return false;
        }
        PyClass possibleModelOrForm = ((PyPossibleClassMember)element).getContainingClass();
        if (possibleModelOrForm == null) {
            return false;
        }
        TypeEvalContext context = TypeEvalContext.codeAnalysis(element.getProject(), null);
        if (NameResolverTools.isSubclass(possibleModelOrForm, DjangoFQNamesProvider.FORM_CLASS, context) || NameResolverTools.isSubclass(possibleModelOrForm, DjangoFQNamesProvider.DJANGO_MODEL_CLASS, context)) {
            return this.myStringLiteral.getStringValue().equals(element.getText());
        }
        return false;
    }

    @Nullable
    private PsiElement resolveInner(boolean userInitiated) {
        String currentValue = this.myStringLiteral.getStringValue();
        Optional<DjangoField> currentField = this.getStreamOfFields(userInitiated).filter(o -> o.getName().equals(currentValue)).findFirst();
        return currentField.map(DjangoField::getField).orElse(null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "possibleForm";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultContext";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/django/codeInsight/djangoForms/DjangoFormFieldReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/django/codeInsight/djangoForms/DjangoFormFieldReference";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getStreamOfFields";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFieldsAlreadyUsed";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

