/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.actions;

import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.ide.actions.GotoActionBase;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.psi.PsiElement;
import com.jetbrains.commandInterface.command.CommandExecutor;
import com.jetbrains.commandInterface.command.SimpleCommand;
import com.jetbrains.commandInterface.console.CommandLineConsoleApiKt;
import com.jetbrains.commandInterface.console.CommandsInfo;
import com.jetbrains.django.manage.DjangoManageCommandsApi;
import com.jetbrains.django.manage.FailedToProvideCommandsException;
import com.jetbrains.django.model.modelApi.DjangoModelApi;
import com.jetbrains.django.ui.DjangoBundle;
import com.jetbrains.python.PythonModuleTypeBase;
import com.jetbrains.python.remote.NewFilesProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunManageTaskAction
extends AnAction {
    public final void update(@NotNull AnActionEvent e) {
        if (e == null) {
            RunManageTaskAction.$$$reportNull$$$0(0);
        }
        boolean djangoModuleExists = !RunManageTaskAction.findModulesWithDjango(e).isEmpty();
        e.getPresentation().setEnabledAndVisible(djangoModuleExists);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            RunManageTaskAction.$$$reportNull$$$0(1);
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        Module module = RunManageTaskAction.getAppropriateModule(e);
        if (module == null) {
            return;
        }
        RunManageTaskAction.runManagePyOnModule(module);
    }

    @Nullable
    static LanguageConsoleView runManagePyOnModule(@NotNull Module moduleWithDjango) {
        if (moduleWithDjango == null) {
            RunManageTaskAction.$$$reportNull$$$0(2);
        }
        StringBuilder errors = new StringBuilder();
        ArrayList<SimpleCommand> commands = null;
        try {
            commands = new ArrayList<SimpleCommand>(DjangoManageCommandsApi.getCommands(moduleWithDjango, e -> errors.append((String)e).append('\n')));
        }
        catch (FailedToProvideCommandsException exception) {
            Logger.getInstance(RunManageTaskAction.class).warn("Error obtaining real commands", (Throwable)exception);
            errors.append(exception.getMessage());
        }
        CommandExecutor defaultExecutor = DjangoManageCommandsApi.getDefaultExecutor();
        String title = DjangoBundle.message("django.manage.name", moduleWithDjango.getName());
        CommandsInfo commandsInfo = new CommandsInfo(commands, defaultExecutor, CommandLineConsoleApiKt.jbFilter((Function1<? super String, String>)((Function1)s -> NewFilesProcessor.processNewFiles(moduleWithDjango, s))));
        LanguageConsoleView console = CommandLineConsoleApiKt.createConsole(moduleWithDjango, title, title, commandsInfo);
        if (errors.length() > 0) {
            console.print(errors.toString(), ConsoleViewContentType.ERROR_OUTPUT);
        }
        return console;
    }

    @Nullable
    private static Module getAppropriateModule(@NotNull AnActionEvent event2) {
        Module module;
        Module moduleFromEvent;
        if (event2 == null) {
            RunManageTaskAction.$$$reportNull$$$0(3);
        }
        if ((moduleFromEvent = (Module)event2.getData(LangDataKeys.MODULE)) != null && DjangoModelApi.create(moduleFromEvent).getSuccessOrNull() != null) {
            return moduleFromEvent;
        }
        PsiElement context = GotoActionBase.getPsiContext((AnActionEvent)event2);
        if (context != null && (module = ModuleUtilCore.findModuleForPsiElement((PsiElement)context)) != null && DjangoModelApi.create(module).getSuccessOrNull() != null) {
            return module;
        }
        List<Module> modulesWithDjango = RunManageTaskAction.findModulesWithDjango(event2);
        if (modulesWithDjango.isEmpty()) {
            return null;
        }
        if (modulesWithDjango.size() == 1) {
            return modulesWithDjango.get(0);
        }
        JBPopupFactory.getInstance().createListPopup((ListPopupStep)new ModuleChooser(modulesWithDjango)).showInFocusCenter();
        return null;
    }

    @NotNull
    private static List<Module> findModulesWithDjango(@NotNull AnActionEvent event2) {
        if (event2 == null) {
            RunManageTaskAction.$$$reportNull$$$0(4);
        }
        ArrayList<Module> modules = new ArrayList<Module>();
        Project project = event2.getProject();
        if (project != null) {
            for (Module module : ModuleUtil.getModulesOfType((Project)project, (ModuleType)PythonModuleTypeBase.getInstance())) {
                if (DjangoModelApi.create(module).getSuccessOrNull() == null) continue;
                modules.add(module);
            }
        }
        ArrayList<Module> arrayList = modules;
        if (arrayList == null) {
            RunManageTaskAction.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleWithDjango";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/django/actions/RunManageTaskAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/django/actions/RunManageTaskAction";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findModulesWithDjango";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "runManagePyOnModule";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAppropriateModule";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findModulesWithDjango";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class ModuleChooser
    extends BaseListPopupStep<String> {
        @NotNull
        private final Map<String, Module> myModulesMap;

        ModuleChooser(@NotNull Collection<Module> modulesWithDjango) {
            if (modulesWithDjango == null) {
                ModuleChooser.$$$reportNull$$$0(0);
            }
            super(DjangoBundle.message("django.manage.several_modules", new Object[0]), new ArrayList<String>(ModuleChooser.getModulesMap(modulesWithDjango).keySet()));
            this.myModulesMap = new HashMap<String, Module>();
            this.myModulesMap.putAll(ModuleChooser.getModulesMap(modulesWithDjango));
        }

        public PopupStep<?> onChosen(String selectedValue, boolean finalChoice) {
            PopupStep chosen = super.onChosen((Object)selectedValue, finalChoice);
            Module module = this.myModulesMap.get(selectedValue);
            if (module != null) {
                RunManageTaskAction.runManagePyOnModule(module);
            }
            return chosen;
        }

        @NotNull
        private static Map<String, Module> getModulesMap(@NotNull Iterable<Module> modules) {
            if (modules == null) {
                ModuleChooser.$$$reportNull$$$0(1);
            }
            TreeMap<String, Module> result = new TreeMap<String, Module>();
            for (Module module : modules) {
                result.put(module.getName(), module);
            }
            TreeMap<String, Module> treeMap = result;
            if (treeMap == null) {
                ModuleChooser.$$$reportNull$$$0(2);
            }
            return treeMap;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "modulesWithDjango";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "modules";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/django/actions/RunManageTaskAction$ModuleChooser";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/django/actions/RunManageTaskAction$ModuleChooser";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getModulesMap";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getModulesMap";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

