/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cython.parser;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.cython.parser.CythonDeclParsing;
import com.jetbrains.cython.parser.CythonParsingContext;
import com.jetbrains.cython.parser.CythonParsingScope;
import com.jetbrains.cython.parser.CythonTokenTypes;
import com.jetbrains.cython.psi.elementTypes.CythonElementTypes;
import com.jetbrains.cython.psi.elementTypes.CythonStubElementTypes;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonProBundle;
import com.jetbrains.python.parsing.ExpressionParsing;
import com.jetbrains.python.parsing.StatementParsing;
import com.jetbrains.python.psi.PyElementType;
import com.jetbrains.python.psi.PyStubElementType;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class CythonStatementParsing
extends StatementParsing {
    protected CythonStatementParsing(CythonParsingContext context, @Nullable StatementParsing.FUTURE futureFlag) {
        super(context, futureFlag);
    }

    @Override
    public CythonParsingContext getParsingContext() {
        return (CythonParsingContext)this.myContext;
    }

    @Override
    protected IElementType getReferenceType() {
        return CythonElementTypes.REFERENCE_EXPRESSION;
    }

    @Override
    public void parseStatement() {
        CythonParsingContext context = this.getParsingContext();
        CythonParsingScope scope = context.getScope();
        boolean isCdef = scope.isCdef();
        PsiBuilder builder = this.myContext.getBuilder();
        PsiBuilder.Marker marker = null;
        if (this.atToken(PyTokenTypes.PASS_KEYWORD) && isCdef) {
            this.parseKeywordStatement(builder, PyElementTypes.PASS_STATEMENT);
            return;
        }
        if (this.atToken(CythonTokenTypes.CTYPEDEF_KEYWORD)) {
            this.parseTypedefStatement();
            return;
        }
        if (this.atToken(CythonTokenTypes.UPPPER_DEF_KEYWORD)) {
            this.parseMacroDefStatement();
            return;
        }
        if (this.atToken(CythonTokenTypes.UPPPER_IF_KEYWORD)) {
            this.parseIfStatement(CythonTokenTypes.UPPPER_IF_KEYWORD, CythonTokenTypes.UPPER_ELIF_KEYWORD, CythonTokenTypes.UPPER_ELSE_KEYWORD, CythonElementTypes.MACRO_IF_STATEMENT);
            return;
        }
        if (this.atToken(CythonTokenTypes.CIMPORT_KEYWORD)) {
            this.parseImportStatement((IElementType)CythonElementTypes.CIMPORT_STATEMENT, (IElementType)CythonElementTypes.CIMPORT_ELEMENT);
            return;
        }
        if (this.atToken(CythonTokenTypes.CDEF_KEYWORD) || this.atToken(CythonTokenTypes.CPDEF_KEYWORD)) {
            isCdef = true;
            marker = builder.mark();
            this.nextToken();
        }
        if (isCdef) {
            if (marker == null) {
                marker = builder.mark();
            }
            this.parseCdefStatement(marker);
        } else if (this.atToken(CythonTokenTypes.INCLUDE_KEYWORD)) {
            this.parseIncludeStatement();
        } else if (this.atToken(PyTokenTypes.IDENTIFIER, "property")) {
            this.parsePropertyDeclaration();
        } else {
            super.parseStatement();
        }
    }

    private void parsePropertyDeclaration() {
        PsiBuilder.Marker marker = this.myBuilder.mark();
        this.nextToken();
        if (this.atToken(PyTokenTypes.IDENTIFIER)) {
            CythonStatementParsing.buildTokenElement(CythonElementTypes.NAME_DECL, this.myBuilder);
        } else {
            this.myBuilder.error(PyPsiBundle.message("PARSE.expected.identifier", new Object[0]));
        }
        this.checkMatches(PyTokenTypes.COLON, PyPsiBundle.message("PARSE.expected.colon", new Object[0]));
        this.parseSuite(marker, CythonElementTypes.PROPERTY_DECLARATION);
    }

    private void parseIncludeStatement() {
        PsiBuilder.Marker marker = this.myBuilder.mark();
        this.nextToken();
        if (!this.getExpressionParser().parseStringLiteralExpression()) {
            this.myBuilder.error(PythonProBundle.message("cython.string.literal.expected"));
        }
        this.checkEndOfStatement();
        marker.done((IElementType)CythonElementTypes.INCLUDE_STATEMENT);
    }

    private void parseTypedefStatement() {
        PsiBuilder builder = this.myContext.getBuilder();
        PsiBuilder.Marker marker = builder.mark();
        this.nextToken();
        CythonParsingContext context = this.getParsingContext();
        CythonDeclParsing parser = context.getDeclParser();
        parser.parseVisibilityDecl();
        parser.parseApiDecl();
        String text2 = builder.getTokenText();
        if (this.atToken(PyTokenTypes.CLASS_KEYWORD)) {
            context.pushScope(context.getScope().withCdef(false));
            this.parseCdefClassDeclaration(builder.mark());
            context.popScope();
        } else if (this.atToken(PyTokenTypes.IDENTIFIER) && ("struct".equals(text2) || "union".equals(text2) || "packed".equals(text2))) {
            this.parseStructOrUnionDeclaration(builder.mark());
        } else if (this.atToken(PyTokenTypes.IDENTIFIER, "enum")) {
            this.parseEnumDeclaration(builder.mark());
        } else if (this.atToken(PyTokenTypes.IDENTIFIER, "fused")) {
            this.parseFusedDeclaration(builder.mark());
        } else {
            parser.parseBaseTypeDecl(true);
            parser.parseNameDecl(false, true, false);
            this.checkEndOfStatement();
        }
        marker.done((IElementType)CythonElementTypes.TYPEDEF_STATEMENT);
    }

    public void parseCdefClassDeclaration(PsiBuilder.Marker endMarker) {
        PsiBuilder.Marker marker;
        this.nextToken();
        PsiBuilder.Marker decl = this.myBuilder.mark();
        this.parseIdentifier();
        while (this.atToken(PyTokenTypes.DOT)) {
            this.nextToken();
            decl.drop();
            decl = this.myBuilder.mark();
            this.parseIdentifier();
        }
        CythonParsingContext context = this.getParsingContext();
        context.getDeclParser().parseCanonicalName();
        decl.done((IElementType)CythonElementTypes.NAME_DECL);
        CythonParsingScope scope = context.getScope();
        if (this.atToken(PyTokenTypes.LBRACKET) && scope.isCdef()) {
            marker = this.myBuilder.mark();
            this.nextToken();
            this.parseIdentifier();
            while (this.atToken(PyTokenTypes.COMMA)) {
                this.nextToken();
                this.parseIdentifier();
            }
            this.checkMatches(PyTokenTypes.RBRACKET, PyPsiBundle.message("PARSE.expected.rbracket", new Object[0]));
            marker.done(PyElementTypes.PARAMETER_LIST);
        }
        if (this.atToken(PyTokenTypes.AS_KEYWORD)) {
            this.nextToken();
            this.parseIdentifier();
        }
        if (this.myBuilder.getTokenType() == PyTokenTypes.LPAR) {
            this.getExpressionParser().parseArgumentList();
        } else {
            marker = this.myBuilder.mark();
            marker.done((IElementType)PyElementTypes.ARGUMENT_LIST);
        }
        if (this.atToken(PyTokenTypes.LBRACKET)) {
            this.parseClassOptions();
        }
        if (this.atToken(PyTokenTypes.COLON)) {
            this.nextToken();
            this.parseSuite();
        } else {
            marker = this.myBuilder.mark();
            marker.done((IElementType)PyElementTypes.STATEMENT_LIST);
            this.checkEndOfStatement();
        }
        endMarker.done(CythonStubElementTypes.CLASS_DECLARATION);
    }

    private void parseClassOptions() {
        this.assertCurrentToken(PyTokenTypes.LBRACKET);
        this.nextToken();
        while (this.atToken(PyTokenTypes.IDENTIFIER)) {
            String text2 = this.myBuilder.getTokenText();
            if ("object".equals(text2) || "type".equals(text2)) {
                this.nextToken();
                this.parseIdentifier();
            }
            if (!this.atToken(PyTokenTypes.COMMA)) break;
            this.nextToken();
        }
        this.checkMatches(PyTokenTypes.RBRACKET, PythonProBundle.message("cython.expected.symbols", "'object'", "'type'"));
    }

    @Override
    protected StatementParsing.ImportTypes checkFromImportKeyword() {
        PsiBuilder builder = this.myContext.getBuilder();
        IElementType tokenType = builder.getTokenType();
        PyStubElementType statementType = PyElementTypes.FROM_IMPORT_STATEMENT;
        PyStubElementType elementType = PyElementTypes.IMPORT_ELEMENT;
        Object starElementType = PyElementTypes.STAR_IMPORT_ELEMENT;
        if (tokenType == PyTokenTypes.IMPORT_KEYWORD) {
            this.nextToken();
        } else if (tokenType == CythonTokenTypes.CIMPORT_KEYWORD) {
            this.nextToken();
            statementType = CythonElementTypes.FROM_CIMPORT_STATEMENT;
            elementType = CythonElementTypes.CIMPORT_ELEMENT;
            starElementType = CythonElementTypes.STAR_CIMPORT_ELEMENT;
        } else {
            builder.error(PythonProBundle.message("cython.expected.symbols", "'import'", "'cimport'"));
        }
        return new StatementParsing.ImportTypes((IElementType)statementType, (IElementType)elementType, (IElementType)starElementType);
    }

    @Override
    protected void parseForPart() {
        PsiBuilder.Marker forPart = this.myBuilder.mark();
        ExpressionParsing parser = this.getExpressionParser();
        PyElementType elementType = PyElementTypes.FOR_PART;
        this.myBuilder.advanceLexer();
        parser.parseExpression(true, true);
        if (this.atToken(PyTokenTypes.IN_KEYWORD)) {
            this.nextToken();
            parser.parseExpression();
        } else if (this.atToken(PyTokenTypes.FROM_KEYWORD)) {
            elementType = CythonElementTypes.FOR_PART;
            this.nextToken();
            parser.parseExpression();
            if (this.atToken(CythonTokenTypes.BY_KEYWORD)) {
                this.nextToken();
                parser.parseExpression();
            }
        } else {
            this.myBuilder.error(PythonProBundle.message("cython.expected.symbols", "'in'", "'from'"));
        }
        this.checkMatches(PyTokenTypes.COLON, PyPsiBundle.message("PARSE.expected.colon", new Object[0]));
        this.parseSuite();
        forPart.done((IElementType)elementType);
    }

    private void parseMacroDefStatement() {
        this.assertCurrentToken(CythonTokenTypes.UPPPER_DEF_KEYWORD);
        PsiBuilder builder = this.myContext.getBuilder();
        PsiBuilder.Marker marker = builder.mark();
        this.nextToken();
        PsiBuilder.Marker target = builder.mark();
        this.parseIdentifier();
        target.done(PyElementTypes.TARGET_EXPRESSION);
        this.checkMatches(PyTokenTypes.EQ, PythonProBundle.message("cython.eq.expected"));
        this.getExpressionParser().parseExpression();
        this.checkEndOfStatement();
        marker.done((IElementType)CythonElementTypes.MACRO_DEF_STATEMENT);
    }

    protected void parseCdefStatement(PsiBuilder.Marker endMarker) {
        PsiBuilder builder = this.myContext.getBuilder();
        CythonParsingContext context = this.getParsingContext();
        CythonParsingScope scope = context.getScope();
        CythonDeclParsing parser = context.getDeclParser();
        List<String> visibilityDecl = parser.parseVisibilityDecl();
        parser.parseApiDecl();
        String text2 = builder.getTokenText();
        if (visibilityDecl.contains("extern") && this.atToken(PyTokenTypes.FROM_KEYWORD)) {
            this.parseCdefExternBlock(endMarker);
        } else if (this.atToken(PyTokenTypes.IMPORT_KEYWORD)) {
            this.nextToken();
            this.parseCdefExternBlock(endMarker);
        } else if (this.atToken(PyTokenTypes.COLON)) {
            this.nextToken();
            context.pushScope(scope.withCdef(true));
            this.parseSuite(endMarker, CythonElementTypes.CDEF_BLOCK);
            context.popScope();
        } else if (this.atToken(PyTokenTypes.CLASS_KEYWORD)) {
            context.pushScope(scope.withCdef(false));
            this.parseCdefClassDeclaration(endMarker);
            context.popScope();
        } else if (this.atToken(PyTokenTypes.IDENTIFIER) && ("struct".equals(text2) || "union".equals(text2) || "packed".equals(text2))) {
            this.parseStructOrUnionDeclaration(endMarker);
        } else if (this.atToken(PyTokenTypes.IDENTIFIER, "enum")) {
            this.parseEnumDeclaration(endMarker);
        } else if (this.atToken(PyTokenTypes.IDENTIFIER, "fused")) {
            this.parseFusedDeclaration(endMarker);
        } else if (this.atToken(PyTokenTypes.IDENTIFIER, "cppclass")) {
            context.pushScope(scope.withCdef(true));
            this.parseCdefClassDeclaration(endMarker);
            context.popScope();
        } else {
            this.parseCdefFunctionOrVariable(endMarker);
        }
    }

    private void parseEnumDeclaration(PsiBuilder.Marker endMarker) {
        PsiBuilder builder = this.myContext.getBuilder();
        this.nextToken();
        if (this.atToken(PyTokenTypes.IDENTIFIER)) {
            CythonStatementParsing.buildTokenElement(CythonElementTypes.NAME_DECL, builder);
            this.getParsingContext().getDeclParser().parseCanonicalName();
        }
        if (this.checkMatches(PyTokenTypes.COLON, PyPsiBundle.message("PARSE.expected.colon", new Object[0]))) {
            if (this.atToken(PyTokenTypes.STATEMENT_BREAK)) {
                this.nextToken();
                PsiBuilder.Marker marker = this.myBuilder.mark();
                if (this.checkMatches(PyTokenTypes.INDENT, PyPsiBundle.message("indent.expected", new Object[0]))) {
                    while (!builder.eof() && !this.atToken(PyTokenTypes.DEDENT)) {
                        this.parseEnumLine();
                    }
                    marker.done((IElementType)PyElementTypes.STATEMENT_LIST);
                    if (!builder.eof()) {
                        this.checkMatches(PyTokenTypes.DEDENT, PyPsiBundle.message("dedent.expected", new Object[0]));
                    }
                } else {
                    marker.drop();
                }
            } else {
                this.parseEnumLine();
            }
        }
        endMarker.done((IElementType)CythonElementTypes.ENUM_DECLARATION);
    }

    private void parseEnumLine() {
        if (this.atToken(PyTokenTypes.PASS_KEYWORD)) {
            this.parseKeywordStatement(this.myBuilder, PyElementTypes.PASS_STATEMENT);
        } else {
            PsiBuilder.Marker marker = this.myBuilder.mark();
            this.parseEnumItem();
            while (this.atToken(PyTokenTypes.COMMA)) {
                this.nextToken();
                if (this.myBuilder.eof() || this.atToken(PyTokenTypes.STATEMENT_BREAK)) break;
                this.parseEnumItem();
            }
            marker.done((IElementType)CythonElementTypes.VARIABLE_LIST);
            if (!this.myBuilder.eof()) {
                this.checkMatches(PyTokenTypes.STATEMENT_BREAK, PythonProBundle.message("cython.newline.expected"));
            }
        }
    }

    private void parseEnumItem() {
        PsiBuilder builder = this.myContext.getBuilder();
        if (this.atToken(PyTokenTypes.IDENTIFIER)) {
            PsiBuilder.Marker variable = builder.mark();
            PsiBuilder.Marker nameDecl = builder.mark();
            PsiBuilder.Marker assignment = builder.mark();
            PsiBuilder.Marker target = builder.mark();
            this.nextToken();
            this.getParsingContext().getDeclParser().parseCanonicalName();
            if (this.atToken(PyTokenTypes.EQ)) {
                target.done(PyElementTypes.TARGET_EXPRESSION);
                this.nextToken();
                this.getExpressionParser().parseSingleExpression(false);
                assignment.done((IElementType)PyElementTypes.ASSIGNMENT_STATEMENT);
            } else {
                target.drop();
                assignment.drop();
            }
            nameDecl.done((IElementType)CythonElementTypes.NAME_DECL);
            variable.done((IElementType)CythonElementTypes.VARIABLE);
        } else {
            builder.error(PyPsiBundle.message("PARSE.expected.identifier", new Object[0]));
            this.nextToken();
        }
    }

    private void parseFusedDeclaration(PsiBuilder.Marker endMarker) {
        this.nextToken();
        if (this.atToken(PyTokenTypes.IDENTIFIER)) {
            CythonStatementParsing.buildTokenElement(CythonElementTypes.NAME_DECL, this.myBuilder);
        }
        if (this.checkMatches(PyTokenTypes.COLON, PyPsiBundle.message("PARSE.expected.colon", new Object[0])) && this.checkMatches(PyTokenTypes.STATEMENT_BREAK, PythonProBundle.message("cython.newline.expected"))) {
            PsiBuilder.Marker marker = this.myBuilder.mark();
            if (this.checkMatches(PyTokenTypes.INDENT, PyPsiBundle.message("indent.expected", new Object[0]))) {
                CythonDeclParsing declParser = this.getParsingContext().getDeclParser();
                while (!this.myBuilder.eof() && !this.atToken(PyTokenTypes.DEDENT)) {
                    if (this.atToken(PyTokenTypes.PASS_KEYWORD)) {
                        this.parseKeywordStatement(this.myBuilder, PyElementTypes.PASS_STATEMENT);
                        continue;
                    }
                    declParser.parseBaseTypeDecl(false);
                    this.checkEndOfStatement();
                }
                marker.done((IElementType)PyElementTypes.STATEMENT_LIST);
                if (!this.myBuilder.eof()) {
                    this.checkMatches(PyTokenTypes.DEDENT, PyPsiBundle.message("dedent.expected", new Object[0]));
                }
            } else {
                marker.drop();
            }
        }
        endMarker.done((IElementType)CythonElementTypes.FUSED_TYPE_DECLARATION);
    }

    private void parseStructOrUnionDeclaration(PsiBuilder.Marker endMarker) {
        PsiBuilder builder = this.myContext.getBuilder();
        if ("packed".equals(builder.getTokenText())) {
            this.nextToken();
            if (!this.atToken(PyTokenTypes.IDENTIFIER) || !"struct".equals(builder.getTokenText())) {
                builder.error(PythonProBundle.message("cython.expected.symbol", "'struct'"));
            }
        }
        this.nextToken();
        if (this.atToken(PyTokenTypes.IDENTIFIER)) {
            CythonStatementParsing.buildTokenElement(CythonElementTypes.NAME_DECL, builder);
        } else {
            builder.error(PyPsiBundle.message("PARSE.expected.identifier", new Object[0]));
        }
        this.getParsingContext().getDeclParser().parseCanonicalName();
        if (this.atToken(PyTokenTypes.COLON)) {
            this.nextToken();
            if (this.checkMatches(PyTokenTypes.STATEMENT_BREAK, PythonProBundle.message("cython.newline.expected"))) {
                PsiBuilder.Marker marker = this.myBuilder.mark();
                if (this.checkMatches(PyTokenTypes.INDENT, PyPsiBundle.message("indent.expected", new Object[0]))) {
                    while (!builder.eof() && !this.atToken(PyTokenTypes.DEDENT)) {
                        if (this.atToken(PyTokenTypes.PASS_KEYWORD)) {
                            this.parseKeywordStatement(builder, PyElementTypes.PASS_STATEMENT);
                            continue;
                        }
                        PsiBuilder.Marker field = builder.mark();
                        this.parseCdefFunctionOrVariable(field);
                    }
                    marker.done((IElementType)PyElementTypes.STATEMENT_LIST);
                    if (!builder.eof()) {
                        this.checkMatches(PyTokenTypes.DEDENT, PyPsiBundle.message("dedent.expected", new Object[0]));
                    }
                } else {
                    marker.drop();
                }
            }
        } else if (this.atToken(PyTokenTypes.STATEMENT_BREAK)) {
            this.nextToken();
        } else {
            builder.error(PythonProBundle.message("cython.expected.symbols", "':'", "newline"));
        }
        endMarker.done((IElementType)CythonElementTypes.STRUCT_OR_UNION_DECLARATION);
    }

    private void parseCdefExternBlock(PsiBuilder.Marker endMarker) {
        this.checkMatches(PyTokenTypes.FROM_KEYWORD, PythonProBundle.message("cython.from.expected"));
        PsiBuilder builder = this.myContext.getBuilder();
        if (this.atToken(PyTokenTypes.MULT)) {
            this.nextToken();
        } else if (!this.getExpressionParser().parseStringLiteralExpression()) {
            builder.error(PythonProBundle.message("cython.expected.symbols", PythonProBundle.message("cython.string.literal"), "'*'"));
        }
        if (this.atToken(PyTokenTypes.IDENTIFIER, "namespace")) {
            this.nextToken();
            if (!this.getExpressionParser().parseStringLiteralExpression()) {
                builder.error(PythonProBundle.message("cython.string.literal.expected"));
            }
        }
        this.getParsingContext().getDeclParser().parseNoGilDecl();
        this.checkMatches(PyTokenTypes.COLON, PyPsiBundle.message("PARSE.expected.colon", new Object[0]));
        this.myContext.pushScope(this.getParsingContext().getScope().withCdef(true));
        this.parseSuite(endMarker, CythonElementTypes.CDEF_BLOCK);
        this.myContext.popScope();
    }

    private void parseCdefFunctionOrVariable(PsiBuilder.Marker endMarker) {
        CythonParsingContext context = this.getParsingContext();
        CythonParsingScope scope = context.getScope();
        PsiBuilder builder = this.myContext.getBuilder();
        CythonDeclParsing declParser = context.getDeclParser();
        declParser.parseInlineDecl();
        declParser.parseBaseTypeDecl(true);
        PsiBuilder.Marker variable = builder.mark();
        CythonDeclParsing.DeclaratorType declaratorType = declParser.parseNameDecl(false, true, true);
        if (this.atToken(PyTokenTypes.IDENTIFIER, "const") && scope.isCdef()) {
            this.nextToken();
        }
        if (this.atToken(PyTokenTypes.COLON)) {
            Object blockType;
            variable.drop();
            if (declaratorType != CythonDeclParsing.DeclaratorType.FUNCTION) {
                blockType = CythonElementTypes.CDEF_BLOCK;
                builder.error(PythonProBundle.message("cython.expected.symbol", "'('"));
            } else {
                blockType = CythonStubElementTypes.FUNCTION_DECLARATION;
            }
            this.nextToken();
            context.pushScope(scope.withCdef(false));
            this.parseSuite(endMarker, (IElementType)blockType);
            context.popScope();
        } else if (declaratorType == CythonDeclParsing.DeclaratorType.FUNCTION) {
            variable.drop();
            this.myBuilder.mark().done((IElementType)PyElementTypes.STATEMENT_LIST);
            this.checkEndOfStatement();
            endMarker.done(CythonStubElementTypes.FUNCTION_DECLARATION);
        } else {
            variable.done((IElementType)CythonElementTypes.VARIABLE);
            while (this.atToken(PyTokenTypes.COMMA)) {
                this.nextToken();
                if (PyTokenTypes.END_OF_STATEMENT.contains(builder.getTokenType())) break;
                PsiBuilder.Marker next2 = builder.mark();
                declParser.parseNameDecl(false, true, true);
                next2.done((IElementType)CythonElementTypes.VARIABLE);
            }
            this.checkEndOfStatement();
            endMarker.done((IElementType)CythonElementTypes.VARIABLE_LIST);
        }
    }

    private boolean parseIdentifier() {
        return this.checkMatches(PyTokenTypes.IDENTIFIER, PyPsiBundle.message("PARSE.expected.identifier", new Object[0]));
    }

    @Override
    protected boolean hasPrintStatement() {
        return true;
    }

    @Override
    protected boolean hasWithStatement() {
        return true;
    }

    @Override
    protected void parseSimpleStatement() {
        super.parseSimpleStatement(false);
    }

    @Override
    public IElementType filter(IElementType source2, int start, int end, CharSequence text2) {
        return super.filter(source2, start, end, text2, false);
    }
}

