/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cython.parser;

import com.google.common.collect.ImmutableSet;
import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.cython.CythonNames;
import com.jetbrains.cython.parser.CythonTokenTypes;
import com.jetbrains.cython.psi.elementTypes.CythonElementTypes;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonProBundle;
import com.jetbrains.python.parsing.ExpressionParsing;
import com.jetbrains.python.parsing.FunctionParsing;
import com.jetbrains.python.parsing.Parsing;
import com.jetbrains.python.parsing.ParsingContext;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class CythonDeclParsing
extends Parsing {
    protected CythonDeclParsing(ParsingContext context) {
        super(context);
    }

    @Override
    protected IElementType getReferenceType() {
        return CythonElementTypes.REFERENCE_EXPRESSION;
    }

    protected List<String> parseVisibilityDecl() {
        String s;
        ArrayList<String> toks = new ArrayList<String>();
        if (this.atToken(PyTokenTypes.IDENTIFIER) && CythonNames.VISIBILITY_MODIFIERS.contains((Object)(s = this.myContext.getBuilder().getTokenText()))) {
            toks.add(s);
            this.nextToken();
        }
        return toks;
    }

    protected boolean parseApiDecl() {
        if (this.atToken(PyTokenTypes.IDENTIFIER, "api")) {
            this.nextToken();
            return true;
        }
        return false;
    }

    protected void parseInlineDecl() {
        if (this.atToken(PyTokenTypes.IDENTIFIER, "inline")) {
            this.nextToken();
        }
    }

    protected DeclaratorType parseNameDecl(boolean requireEmpty, boolean requireNonEmpty, boolean assignable) {
        PsiBuilder builder = this.myContext.getBuilder();
        PsiBuilder.Marker marker = builder.mark();
        DeclaratorType type = DeclaratorType.EMPTY;
        DeclaratorType simpleType = DeclaratorType.EMPTY;
        if (this.atToken(PyTokenTypes.LPAR)) {
            PsiBuilder.Marker paramList = builder.mark();
            this.nextToken();
            if (this.atToken(PyTokenTypes.RPAR) || this.atToken(PyTokenTypes.IDENTIFIER) && !CythonNames.CALLING_CONVENTIONS.contains((Object)builder.getTokenText())) {
                paramList.rollbackTo();
                this.parseCdefFunctionParameters();
                type = DeclaratorType.FUNCTION;
            } else {
                paramList.drop();
                this.parseNameDecl(requireEmpty, requireNonEmpty, assignable);
                this.checkMatches(PyTokenTypes.RPAR, PyPsiBundle.message("PARSE.expected.rpar", new Object[0]));
                type = DeclaratorType.VARIABLE;
            }
        } else {
            simpleType = this.parseSimpleNameDecl(requireEmpty, requireNonEmpty, assignable);
            if (simpleType == DeclaratorType.EMPTY) {
                marker.drop();
                return simpleType;
            }
        }
        while (this.atAnyOfTokens(PyTokenTypes.LBRACKET, PyTokenTypes.LPAR)) {
            if (this.atToken(PyTokenTypes.LBRACKET)) {
                this.parseArrayDecl();
                if (type != DeclaratorType.EMPTY) continue;
                type = DeclaratorType.VARIABLE;
                continue;
            }
            this.parseCdefFunctionParameters();
            if (type != DeclaratorType.EMPTY) continue;
            type = DeclaratorType.FUNCTION;
        }
        marker.done((IElementType)CythonElementTypes.NAME_DECL);
        return type != DeclaratorType.EMPTY ? type : simpleType;
    }

    private void parseCdefFunctionParameters() {
        FunctionParsing parser = this.getFunctionParser();
        parser.parseParameterList();
        parser.parseReturnTypeAnnotation();
        PsiBuilder builder = this.myContext.getBuilder();
        this.parseNoGilDecl();
        this.parseExceptionDecl();
        if (this.atToken(PyTokenTypes.WITH_KEYWORD)) {
            this.nextToken();
            if (this.atToken(PyTokenTypes.IDENTIFIER, "gil")) {
                this.nextToken();
            } else {
                builder.error(PythonProBundle.message("cython.expected.symbol", "'gil'"));
            }
        }
    }

    protected boolean parseNoGilDecl() {
        if (this.atToken(PyTokenTypes.IDENTIFIER, "nogil")) {
            this.nextToken();
            return true;
        }
        return false;
    }

    private void parseArrayDecl() {
        this.assertCurrentToken(PyTokenTypes.LBRACKET);
        PsiBuilder builder = this.myContext.getBuilder();
        PsiBuilder.Marker marker = builder.mark();
        this.nextToken();
        if (!this.atToken(PyTokenTypes.RBRACKET)) {
            this.getExpressionParser().parseExpression();
        }
        this.checkMatches(PyTokenTypes.RBRACKET, PyPsiBundle.message("PARSE.expected.rbracket", new Object[0]));
        marker.done((IElementType)CythonElementTypes.ARRAY_DECL);
    }

    private void parseExceptionDecl() {
        if (this.atToken(PyTokenTypes.EXCEPT_KEYWORD)) {
            PsiBuilder builder = this.myContext.getBuilder();
            PsiBuilder.Marker marker = builder.mark();
            this.nextToken();
            if (this.atToken(PyTokenTypes.MULT)) {
                this.nextToken();
            } else if (this.atToken(PyTokenTypes.PLUS)) {
                this.nextToken();
                if (this.atToken(PyTokenTypes.IDENTIFIER)) {
                    this.getParsingContext().getExpressionParser().parseExpression();
                }
            } else {
                if (this.atToken(CythonTokenTypes.QUESTION)) {
                    this.nextToken();
                }
                this.getExpressionParser().parseSingleExpression(false);
            }
            marker.done((IElementType)CythonElementTypes.EXCEPTION_DECL);
        }
    }

    private DeclaratorType parseSimpleNameDecl(boolean requireEmpty, boolean requireNonEmpty, boolean assignable) {
        this.parseCallingConventionDecl();
        if (this.atAnyOfTokens(PyTokenTypes.MULT, PyTokenTypes.EXP)) {
            this.nextToken();
            DeclaratorType type = this.parseNameDecl(requireEmpty, requireNonEmpty, assignable);
            return type != DeclaratorType.EMPTY ? type : DeclaratorType.VARIABLE;
        }
        if (this.atToken(PyTokenTypes.AND)) {
            this.nextToken();
            return this.parseNameDecl(requireEmpty, requireNonEmpty, assignable);
        }
        PsiBuilder builder = this.myContext.getBuilder();
        PsiBuilder.Marker assignment = builder.mark();
        PsiBuilder.Marker target = builder.mark();
        if (this.atToken(PyTokenTypes.IDENTIFIER)) {
            if (requireEmpty) {
                builder.error(PythonProBundle.message("cython.declarator.should.be.empty"));
            }
            if ("operator".equals(builder.getTokenText()) && requireNonEmpty) {
                this.nextToken();
                String firstTokenText = builder.getTokenText();
                ImmutableSet firstOpChars = ImmutableSet.of((Object)"+", (Object)"-", (Object)"*", (Object)"/", (Object)"<", (Object)"=", (Object[])new String[]{">", "!", "%", "&", "|", "(", "[", "^", "~", ",", "+=", "-=", "*=", "/=", "<=", "==", ">=", "!=", "%=", "&=", "|=", "^="});
                if (firstOpChars.contains((Object)firstTokenText)) {
                    this.nextToken();
                    String secondTokenText = builder.getTokenText();
                    if ("(".equals(firstTokenText)) {
                        this.checkMatches(")", PyPsiBundle.message("PARSE.expected.rpar", new Object[0]));
                    } else if ("[".equals(firstTokenText)) {
                        this.checkMatches("]", PyPsiBundle.message("PARSE.expected.rbracket", new Object[0]));
                    } else if (ImmutableSet.of((Object)"+", (Object)"-", (Object)"|", (Object)"&").contains((Object)firstTokenText) && firstTokenText != null && firstTokenText.equals(secondTokenText)) {
                        this.nextToken();
                    } else if ("=".equals(secondTokenText) && "~".equals(firstTokenText)) {
                        this.nextToken();
                    }
                }
                target.drop();
                assignment.drop();
                return DeclaratorType.VARIABLE;
            }
            this.nextToken();
            this.parseCanonicalName();
            if (this.atToken(PyTokenTypes.EQ) && assignable) {
                target.done(PyElementTypes.TARGET_EXPRESSION);
                this.nextToken();
                this.getExpressionParser().parseSingleExpression(false);
                assignment.done((IElementType)PyElementTypes.ASSIGNMENT_STATEMENT);
            } else {
                target.drop();
                assignment.drop();
            }
            return DeclaratorType.VARIABLE;
        }
        target.drop();
        assignment.drop();
        if (requireNonEmpty) {
            builder.error(PyPsiBundle.message("PARSE.expected.identifier", new Object[0]));
        }
        return DeclaratorType.EMPTY;
    }

    private void parseCallingConventionDecl() {
        if (this.atToken(PyTokenTypes.IDENTIFIER) && CythonNames.CALLING_CONVENTIONS.contains((Object)this.myBuilder.getTokenText())) {
            CythonDeclParsing.buildTokenElement(CythonElementTypes.CALLING_CONVENTION_DECL, this.myBuilder);
        }
    }

    protected void parseCanonicalName() {
        this.getExpressionParser().parseStringLiteralExpression();
    }

    protected void parseBaseTypeDecl(boolean requireNonEmpty) {
        if (this.atToken(PyTokenTypes.IDENTIFIER, "const") && this.myContext.getBuilder().lookAhead(1) == PyTokenTypes.LPAR) {
            this.nextToken();
        }
        if (this.atToken(PyTokenTypes.LPAR)) {
            this.parseComplexBaseTypeDecl();
        } else {
            this.parseSimpleBaseTypeDecl(requireNonEmpty);
        }
    }

    private void parseComplexBaseTypeDecl() {
        PsiBuilder builder = this.myContext.getBuilder();
        PsiBuilder.Marker marker = builder.mark();
        this.nextToken();
        this.parseBaseTypeDecl(false);
        PsiBuilder.Marker afterType = builder.mark();
        this.parseNameDecl(true, false, false);
        if (this.atToken(PyTokenTypes.COMMA)) {
            afterType.rollbackTo();
            while (this.atAnyOfTokens(PyTokenTypes.MULT, PyTokenTypes.EXP)) {
                this.nextToken();
            }
            while (this.atToken(PyTokenTypes.COMMA)) {
                this.nextToken();
                if (this.atToken(PyTokenTypes.RPAR)) {
                    this.nextToken();
                    marker.done((IElementType)CythonElementTypes.COMPLEX_BASE_TYPE_DECL);
                    return;
                }
                this.parseBaseTypeDecl(false);
                while (this.atAnyOfTokens(PyTokenTypes.MULT, PyTokenTypes.EXP)) {
                    this.nextToken();
                }
            }
        } else {
            afterType.drop();
        }
        this.checkMatches(PyTokenTypes.RPAR, PyPsiBundle.message("PARSE.expected.rpar", new Object[0]));
        marker.done((IElementType)CythonElementTypes.COMPLEX_BASE_TYPE_DECL);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void parseSimpleBaseTypeDecl(boolean requireNonEmpty) {
        PsiBuilder.Marker marker;
        block21: {
            PsiBuilder builder;
            block22: {
                builder = this.myContext.getBuilder();
                if (this.atToken(PyTokenTypes.IDENTIFIER, "const")) {
                    this.nextToken();
                }
                marker = builder.mark();
                if (!this.atToken(PyTokenTypes.IDENTIFIER)) {
                    builder.error(PyPsiBundle.message("PARSE.expected.identifier", new Object[0]));
                    this.nextToken();
                    marker.drop();
                    return;
                }
                if (this.atToken(PyTokenTypes.IDENTIFIER, "const")) {
                    this.nextToken();
                }
                if (!this.atBaseTypeToken()) break block22;
                if (CythonNames.BASE_CYTHON_TYPES.contains((Object)builder.getTokenText())) {
                    this.nextToken();
                    break block21;
                } else {
                    while (this.atToken(PyTokenTypes.IDENTIFIER) && CythonNames.BASE_TYPE_MODIFIERS.contains((Object)builder.getTokenText())) {
                        this.nextToken();
                    }
                    if (this.atToken(PyTokenTypes.IDENTIFIER) && CythonNames.BASE_C_TYPES.contains((Object)builder.getTokenText())) {
                        this.nextToken();
                    }
                    if (this.atToken(PyTokenTypes.IDENTIFIER, "complex")) {
                        this.nextToken();
                    }
                }
                break block21;
            }
            if (this.atDottedName()) {
                this.parseDottedName();
            } else {
                PsiBuilder.Marker ref = builder.mark();
                this.nextToken();
                if (requireNonEmpty && !this.atToken(PyTokenTypes.IDENTIFIER)) {
                    if (this.atToken(PyTokenTypes.LPAR)) {
                        PsiBuilder.Marker atLeftParen = builder.mark();
                        this.nextToken();
                        if (!this.atAnyOfTokens(PyTokenTypes.MULT, PyTokenTypes.EXP, PyTokenTypes.AND)) {
                            ref.drop();
                            atLeftParen.drop();
                            marker.rollbackTo();
                            return;
                        }
                        ref.drop();
                        atLeftParen.rollbackTo();
                    } else {
                        if (!this.atAnyOfTokens(PyTokenTypes.MULT, PyTokenTypes.EXP, PyTokenTypes.LBRACKET, PyTokenTypes.AND)) {
                            ref.drop();
                            marker.rollbackTo();
                            return;
                        }
                        ref.done(this.getReferenceType());
                    }
                } else {
                    ref.done(this.getReferenceType());
                }
            }
        }
        if (this.atToken(PyTokenTypes.LBRACKET)) {
            if (this.atMemoryView()) {
                this.parseMemoryView();
            } else {
                while (this.atToken(PyTokenTypes.LBRACKET)) {
                    this.parseTypeParametersDecl();
                }
            }
        }
        if (this.atToken(PyTokenTypes.DOT)) {
            this.nextToken();
            this.parseIdentifier();
        }
        marker.done((IElementType)CythonElementTypes.SIMPLE_BASE_TYPE_DECL);
    }

    private void parseMemoryView() {
        PsiBuilder.Marker exprStart = this.myBuilder.mark();
        this.nextToken();
        PsiBuilder.Marker sliceItemStart = this.myBuilder.mark();
        ExpressionParsing parser = this.getParsingContext().getExpressionParser();
        parser.parseSliceEnd(exprStart, sliceItemStart);
    }

    private boolean atMemoryView() {
        boolean result = false;
        PsiBuilder.Marker marker = this.myContext.getBuilder().mark();
        this.nextToken();
        if (this.atToken(PyTokenTypes.INTEGER_LITERAL)) {
            this.nextToken();
        }
        if (this.atToken(PyTokenTypes.COLON)) {
            result = true;
        }
        marker.rollbackTo();
        return result;
    }

    private void parseTypeParametersDecl() {
        PsiBuilder.Marker marker = this.myBuilder.mark();
        this.nextToken();
        this.parsePositionalAndKeywordArgs();
        this.checkMatches(PyTokenTypes.RBRACKET, PyPsiBundle.message("PARSE.expected.rbracket", new Object[0]));
        marker.done(PyElementTypes.PARAMETER_LIST);
    }

    private void parsePositionalAndKeywordArgs() {
        while (!this.atToken(PyTokenTypes.RBRACKET)) {
            PsiBuilder.Marker namedParameter = this.myBuilder.mark();
            PsiBuilder.Marker marker = this.myBuilder.mark();
            if (this.atToken(PyTokenTypes.IDENTIFIER)) {
                this.nextToken();
                if (this.atToken(PyTokenTypes.EQ)) {
                    this.nextToken();
                    marker.drop();
                } else {
                    marker.rollbackTo();
                }
            } else {
                marker.rollbackTo();
            }
            if (this.atExpression()) {
                this.getExpressionParser().parseSingleExpression(false);
            } else {
                PsiBuilder.Marker typeDecl = this.myBuilder.mark();
                this.parseBaseTypeDecl(true);
                this.parseNameDecl(true, false, false);
                typeDecl.done((IElementType)CythonElementTypes.COMPLEX_BASE_TYPE_DECL);
            }
            namedParameter.done((IElementType)CythonElementTypes.NAMED_PARAMETER);
            if (!this.atToken(PyTokenTypes.COMMA)) {
                if (this.atToken(PyTokenTypes.RBRACKET)) break;
                this.myBuilder.error(PythonProBundle.message("cython.expected.symbols", "','", "']'"));
                break;
            }
            this.nextToken();
        }
    }

    private void parseDottedName() {
        PsiBuilder builder = this.myContext.getBuilder();
        PsiBuilder.Marker expr = builder.mark();
        this.assertCurrentToken(PyTokenTypes.IDENTIFIER);
        CythonDeclParsing.buildTokenElement(this.getReferenceType(), builder);
        while (this.atToken(PyTokenTypes.DOT)) {
            this.nextToken();
            this.parseIdentifier();
            expr.done(this.getReferenceType());
            expr = expr.precede();
        }
        expr.drop();
    }

    protected boolean atExpression() {
        if (this.atBaseTypeToken()) {
            return false;
        }
        if (this.atToken(PyTokenTypes.IDENTIFIER)) {
            boolean isType = false;
            PsiBuilder.Marker marker = this.myBuilder.mark();
            this.nextToken();
            while (this.atToken(PyTokenTypes.DOT)) {
                this.nextToken();
                this.parseIdentifier();
            }
            if (this.atToken(PyTokenTypes.IDENTIFIER)) {
                isType = true;
            } else if (this.atAnyOfTokens(PyTokenTypes.MULT, PyTokenTypes.EXP)) {
                this.nextToken();
                isType = this.atAnyOfTokens(PyTokenTypes.RPAR, PyTokenTypes.RBRACKET);
            } else if (this.atToken(PyTokenTypes.LPAR)) {
                this.nextToken();
                isType = this.atToken(PyTokenTypes.MULT);
            } else if (this.atToken(PyTokenTypes.LBRACKET)) {
                this.nextToken();
                isType = this.atToken(PyTokenTypes.RBRACKET);
            }
            marker.rollbackTo();
            return !isType;
        }
        return true;
    }

    private boolean atDottedName() {
        boolean result = false;
        PsiBuilder.Marker marker = this.myContext.getBuilder().mark();
        if (this.atToken(PyTokenTypes.IDENTIFIER)) {
            this.nextToken();
            result = this.atToken(PyTokenTypes.DOT);
        }
        marker.rollbackTo();
        return result;
    }

    private boolean atBaseTypeToken() {
        String s = this.myContext.getBuilder().getTokenText();
        return CythonNames.BASE_C_TYPES.contains((Object)s) || CythonNames.BASE_CYTHON_TYPES.contains((Object)s) || CythonNames.BASE_TYPE_MODIFIERS.contains((Object)s);
    }

    private boolean parseIdentifier() {
        return this.checkMatches(PyTokenTypes.IDENTIFIER, PyPsiBundle.message("PARSE.expected.identifier", new Object[0]));
    }

    protected boolean checkMatches(@NotNull String text2, @Nls @NotNull String message) {
        if (text2 == null) {
            CythonDeclParsing.$$$reportNull$$$0(0);
        }
        if (message == null) {
            CythonDeclParsing.$$$reportNull$$$0(1);
        }
        if (text2.equals(this.myBuilder.getTokenText())) {
            this.myBuilder.advanceLexer();
            return true;
        }
        this.myBuilder.error(message);
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "text";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "message";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/cython/parser/CythonDeclParsing";
        objectArray[2] = "checkMatches";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum DeclaratorType {
        EMPTY,
        VARIABLE,
        FUNCTION;

    }
}

