/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.appengine.util;

import com.intellij.facet.ui.ValidationResult;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.text.VersionComparatorUtil;
import com.jetbrains.appengine.facet.AppEngineFacet;
import com.jetbrains.appengine.facet.AppEngineFacetConfiguration;
import com.jetbrains.appengine.model.ModelManager;
import com.jetbrains.appengine.ui.AppEngineBundle;
import com.jetbrains.appengine.util.AppEnginePythonUtil;
import com.jetbrains.appengine.util.YamlUtil;
import com.jetbrains.django.util.VirtualFileUtil;
import com.jetbrains.python.facet.FacetLibraryConfigurator;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLUtil;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLSequenceItem;
import org.jetbrains.yaml.psi.YAMLValue;

public class AppEngineUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.appengine.util.AppEngineUtil");
    public static final String INDEX_YAML = "index.yaml";
    public static final String DEV_APPSERVER = "dev_appserver.py";
    public static final String APP_SETTING_APPLICATION = "application";
    private static final String MODEL_METHOD_GQL = "gql";
    public static final String PYTHON_RUNTIME_25 = "python";
    public static final String PYTHON_RUNTIME_27 = "python27";
    private static final String COMPONENTS_FOLDER = "platform";
    private static final String APP_ENGINE_COMPONENT = "google_appengine";
    private static final String[] VERSIONED_LIBRARY_NAMES = new String[]{"django", "webapp2", "webob", "yaml"};
    private static final String[] DJANGO_PATHS = new String[]{"django-1.5", "django-1.4", "django_1_3", "django_1_2", "django"};

    private AppEngineUtil() {
    }

    @Nullable
    public static String findRoot(Module module) {
        for (VirtualFile file2 : ModuleRootManager.getInstance((Module)module).getContentRoots()) {
            ConfigFileFinder finder = new ConfigFileFinder();
            VfsUtilCore.processFilesRecursively((VirtualFile)file2, (Processor)finder);
            VirtualFile configFile = finder.myConfigFile;
            if (configFile == null) continue;
            return configFile.getParent().getPresentableUrl();
        }
        return null;
    }

    public static boolean isGql(PyStringLiteralExpression value2) {
        return AppEngineUtil.isGqlQuery(value2) || AppEngineUtil.isEntityGql(value2);
    }

    public static boolean isStandaloneAppEgineSdkFolder(@Nullable String path) {
        return !StringUtil.isEmptyOrSpaces((String)path) && new File(path, DEV_APPSERVER).exists() && new File(path, "google").exists();
    }

    public static boolean isGoogleCloudSdkFolder(@Nullable String path) {
        return !StringUtil.isEmptyOrSpaces((String)path) && AppEngineUtil.isStandaloneAppEgineSdkFolder(FileUtil.join((String[])new String[]{path, COMPONENTS_FOLDER, APP_ENGINE_COMPONENT}));
    }

    public static String getAppEngineComponent(@NotNull String sdkPath) {
        if (sdkPath == null) {
            AppEngineUtil.$$$reportNull$$$0(0);
        }
        return FileUtil.join((String[])new String[]{sdkPath, COMPONENTS_FOLDER, APP_ENGINE_COMPONENT});
    }

    public static boolean isPython27Runtime(YAMLFile file2) {
        Pair value2 = YAMLUtil.getValue((YAMLFile)file2, (String[])new String[]{"runtime"});
        return value2 != null && ((String)value2.second).equals(PYTHON_RUNTIME_27);
    }

    public static ValidationResult validateSdk(@NotNull String path) {
        if (path == null) {
            AppEngineUtil.$$$reportNull$$$0(1);
        }
        if (AppEngineUtil.isStandaloneAppEgineSdkFolder(path) || AppEngineUtil.isGoogleCloudSdkFolder(path)) {
            return ValidationResult.OK;
        }
        if (new File(FileUtil.join((String[])new String[]{path, "bin", DEV_APPSERVER})).exists()) {
            return new ValidationResult(AppEngineBundle.message("facet-wizard-error.no-python-extensions-sdk", new Object[0]));
        }
        return new ValidationResult(AppEngineBundle.message("facet-wizard-error.no-appengine-sdk", new Object[0]));
    }

    @Nullable
    public static YAMLFile getAppYaml(Project project, String projectRoot) {
        VirtualFile configFile;
        VirtualFile root = VirtualFileUtil.findFile(projectRoot);
        if (root != null && (configFile = root.findChild("app.yaml")) != null) {
            return (YAMLFile)ObjectUtils.tryCast((Object)PsiManager.getInstance((Project)project).findFile(configFile), YAMLFile.class);
        }
        return null;
    }

    @Nullable
    public static String getSetting(Project project, String projectRoot, String setting) {
        YAMLFile yaml = AppEngineUtil.getAppYaml(project, projectRoot);
        if (yaml == null) {
            return null;
        }
        Pair val = YAMLUtil.getValue((YAMLFile)yaml, (String[])new String[]{setting});
        return (String)Pair.getSecond((Pair)val);
    }

    private static List<String> getAppEngineLibraryPaths(String appEngineSdkPath, Project project, String projectRoot) {
        boolean python27Runtime = false;
        YAMLFile yamlFile = AppEngineUtil.getAppYaml(project, projectRoot);
        if (yamlFile != null) {
            python27Runtime = AppEngineUtil.isPython27Runtime(yamlFile);
        }
        ArrayList<String> result = new ArrayList<String>();
        HashMap<String, VersionedLibrary> versionedLibraryMap = new HashMap<String, VersionedLibrary>();
        if (appEngineSdkPath != null) {
            result.add(appEngineSdkPath);
            File lib = new File(appEngineSdkPath, "lib");
            File[] libDirs = lib.listFiles();
            if (libDirs != null) {
                for (File libDir : libDirs) {
                    String name = libDir.getName();
                    if (name.startsWith("webob") && python27Runtime ^ (name.startsWith("webob_1") || name.startsWith("webob-1")) || python27Runtime && AppEngineUtil.processVersionedLibrary(libDir, versionedLibraryMap)) continue;
                    result.add(libDir.getPath());
                }
            }
        }
        if (python27Runtime) {
            AppEngineUtil.addVersionedLibraries(yamlFile, versionedLibraryMap, result);
        } else {
            String django12Path;
            VersionedLibrary map2 = (VersionedLibrary)versionedLibraryMap.get("django");
            if (map2 != null && (django12Path = map2.getPathForVersion("1.2")) != null) {
                result.add(django12Path);
            }
        }
        return result;
    }

    private static void addVersionedLibraries(YAMLFile yamlFile, Map<String, VersionedLibrary> versionedLibraryMap, List<String> result) {
        for (String libraryName : VERSIONED_LIBRARY_NAMES) {
            String path;
            String version = AppEngineUtil.getLibraryVersion(yamlFile, libraryName);
            VersionedLibrary library = versionedLibraryMap.get(libraryName);
            if (library == null || (path = library.getPathForVersion(version)) == null) continue;
            result.add(path);
        }
    }

    private static boolean processVersionedLibrary(File libDirectory, Map<String, VersionedLibrary> versionedLibraryMap) {
        for (String libraryName : VERSIONED_LIBRARY_NAMES) {
            if (!libDirectory.getName().startsWith(libraryName)) continue;
            VersionedLibrary library = versionedLibraryMap.get(libraryName);
            if (library == null) {
                library = new VersionedLibrary(libraryName);
                versionedLibraryMap.put(libraryName, library);
            }
            library.addPath(libDirectory);
            return true;
        }
        return false;
    }

    private static String getLibraryVersion(YAMLFile yamlFile, String name) {
        YAMLKeyValue libraries = YAMLUtil.getQualifiedKeyInFile((YAMLFile)yamlFile, (String[])new String[]{"libraries"});
        if (libraries != null) {
            List<YAMLSequenceItem> librariesSequence = YamlUtil.getSequenceValue(libraries);
            for (YAMLSequenceItem sequenceItem : librariesSequence) {
                YAMLKeyValue versionKeyValue;
                YAMLKeyValue nameKeyValue = YAMLUtil.findKeyInProbablyMapping((YAMLValue)sequenceItem.getValue(), (String)"name");
                if (nameKeyValue == null || !nameKeyValue.getValueText().equals(name) || (versionKeyValue = YAMLUtil.findKeyInProbablyMapping((YAMLValue)sequenceItem.getValue(), (String)"version")) == null) continue;
                return versionKeyValue.getValueText();
            }
        }
        return null;
    }

    public static void initAppEngineModuleLibrary(Module module, @Nullable ModifiableRootModel existingModel, String appEngineSdkFolder, String projectRoot) {
        List<String> paths = AppEngineUtil.getAppEngineLibraryPaths(appEngineSdkFolder, module.getProject(), projectRoot);
        FacetLibraryConfigurator.attachPythonLibrary(module, existingModel, AppEngineUtil.getAppengineLibraryName(), paths);
    }

    public static void detachAppEngineModuleLibrary(Module module) {
        FacetLibraryConfigurator.detachPythonLibrary(module, AppEngineUtil.getAppengineLibraryName());
    }

    @Nullable
    public static VirtualFile getDjangoBinFolder(String appEnginePath) {
        VirtualFile djangoVFile;
        File djangoFolder;
        if (!StringUtil.isEmpty((String)appEnginePath) && (djangoFolder = AppEngineUtil.getDjangoFolder(appEnginePath)) != null && (djangoVFile = LocalFileSystem.getInstance().findFileByIoFile(djangoFolder)) != null) {
            djangoVFile.refresh(false, true);
            return djangoVFile.findFileByRelativePath("django/bin");
        }
        return null;
    }

    @Nullable
    public static File getDjangoFolder(String appEngineFolder) {
        if (appEngineFolder == null) {
            return null;
        }
        for (String s : DJANGO_PATHS) {
            File result = new File(appEngineFolder, "lib/" + s);
            if (!result.exists()) continue;
            return result;
        }
        return null;
    }

    @Nullable
    public static YAMLFile getIndex(@NotNull Module module, boolean createIfNotFound) {
        VirtualFile root;
        if (module == null) {
            AppEngineUtil.$$$reportNull$$$0(2);
        }
        if ((root = AppEngineUtil.getProjectRootFile(module)) != null) {
            PsiFile psiFile;
            VirtualFile indexFile = null;
            try {
                indexFile = createIfNotFound ? root.findOrCreateChildData((Object)module, INDEX_YAML) : root.findChild(INDEX_YAML);
            }
            catch (IOException e) {
                LOG.error("Failed to create index.yaml", (Throwable)e);
            }
            if (indexFile != null && (psiFile = PsiManager.getInstance((Project)module.getProject()).findFile(indexFile)) instanceof YAMLFile) {
                return (YAMLFile)psiFile;
            }
        }
        return null;
    }

    @Nullable
    public static VirtualFile getProjectRootFile(@NotNull Module module) {
        AppEngineFacetConfiguration config;
        if (module == null) {
            AppEngineUtil.$$$reportNull$$$0(3);
        }
        if ((config = AppEngineFacet.getConfig(module)) == null) {
            return null;
        }
        VirtualFile root = config.getProjectRootFolderFile();
        if (root == null) {
            return null;
        }
        return root;
    }

    public static boolean isGqlQuery(PyStringLiteralExpression str) {
        if (str != null) {
            PyCallExpression call = (PyCallExpression)PsiTreeUtil.getParentOfType((PsiElement)str, PyCallExpression.class);
            return call != null && call.isCalleeText("GqlQuery") && AppEngineUtil.isArgument(call, str, 0);
        }
        return false;
    }

    public static boolean isEntityGql(PyStringLiteralExpression str) {
        return AppEngineUtil.getEntityClass(str) != null;
    }

    @Nullable
    public static PyClass getEntityClass(PyStringLiteralExpression query) {
        PyCallExpression call;
        if (query != null && (call = (PyCallExpression)PsiTreeUtil.getParentOfType((PsiElement)query, PyCallExpression.class)) != null && call.isCalleeText(MODEL_METHOD_GQL) && AppEngineUtil.isArgument(call, query, 0)) {
            return AppEngineUtil.getEntityClass(call);
        }
        return null;
    }

    private static boolean isArgument(PyCallExpression call, PyExpression expr, int pos) {
        PyArgumentList argList = call.getArgumentList();
        if (argList != null) {
            PyExpression[] arguments = argList.getArguments();
            return arguments.length > pos && expr.equals(arguments[pos]);
        }
        return false;
    }

    @Nullable
    private static PyClass getEntityClass(PyCallExpression call) {
        Module module;
        PyClass pyClass = AppEnginePythonUtil.getStaticMethodClass(call);
        if (pyClass != null && (module = ModuleUtilCore.findModuleForPsiElement((PsiElement)pyClass)) != null && ModelManager.getInstance(module).isModel(pyClass)) {
            return pyClass;
        }
        return null;
    }

    @Nullable
    public static String getAppEngineSdkVersion(String path) {
        File f = new File(path, "VERSION");
        if (!f.exists()) {
            return null;
        }
        try {
            String content2 = FileUtil.loadFile((File)f);
            String[] lines = StringUtil.splitByLines((String)content2);
            String prefix = "release:";
            for (String line2 : lines) {
                if (!line2.startsWith("release:")) continue;
                return StringUtil.stripQuotesAroundValue((String)line2.substring("release:".length()).trim());
            }
        }
        catch (IOException e) {
            LOG.info("Failed to load content from App Engine VERSION file", (Throwable)e);
        }
        return null;
    }

    @Nullable
    public static Module getAppEngineModule(@NotNull Project project) {
        if (project == null) {
            AppEngineUtil.$$$reportNull$$$0(4);
        }
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            if (!AppEngineFacet.isPresent(module)) continue;
            return module;
        }
        return null;
    }

    public static Map<String, String> getProperties(@NotNull PyClass pyClass) {
        if (pyClass == null) {
            AppEngineUtil.$$$reportNull$$$0(5);
        }
        HashMap<String, String> result = new HashMap<String, String>();
        List<PyTargetExpression> classAttributes = pyClass.getClassAttributes();
        for (PyTargetExpression expression : classAttributes) {
            String fieldName = expression.getName();
            QualifiedName calleeName = expression.getCalleeName();
            if (fieldName == null || calleeName == null || !calleeName.toString().endsWith("Property") || calleeName.endsWith("SelfReferenceProperty") || calleeName.endsWith("ReferenceProperty")) continue;
            String typeName = calleeName.getLastComponent();
            result.put(fieldName, typeName);
        }
        return result;
    }

    @Nullable
    public static Module getModule(@NotNull AnActionEvent e) {
        Module module;
        if (e == null) {
            AppEngineUtil.$$$reportNull$$$0(6);
        }
        if ((module = (Module)e.getData(LangDataKeys.MODULE)) != null) {
            return module;
        }
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return null;
        }
        Module[] modules = ModuleManager.getInstance((Project)project).getModules();
        if (modules.length == 0) {
            return null;
        }
        return modules[0];
    }

    public static String getAppengineLibraryName() {
        return AppEngineBundle.message("app-engine-sdk", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkPath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyClass";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/appengine/util/AppEngineUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getAppEngineComponent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "validateSdk";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getIndex";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getProjectRootFile";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getAppEngineModule";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getProperties";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getModule";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class VersionedLibrary {
        final String myName;
        final TreeMap<String, File> myVersionPaths = new TreeMap(VersionComparatorUtil.COMPARATOR);

        VersionedLibrary(String name) {
            this.myName = name;
        }

        public void addPath(File directory2) {
            String version = directory2.getName().substring(this.myName.length());
            if (version.startsWith("-") || version.startsWith("_")) {
                version = version.substring(1);
            }
            this.myVersionPaths.put(version.replace("_", "."), directory2);
        }

        public String getPathForVersion(String version) {
            if (this.myVersionPaths.isEmpty()) {
                return null;
            }
            if (version == null || version.equalsIgnoreCase("latest")) {
                return this.myVersionPaths.get(this.myVersionPaths.lastKey()).getPath();
            }
            File file2 = this.myVersionPaths.get(version);
            return file2 != null ? file2.getPath() : null;
        }
    }

    private static class ConfigFileFinder
    implements Processor<VirtualFile> {
        private VirtualFile myConfigFile;

        private ConfigFileFinder() {
        }

        public boolean process(VirtualFile file2) {
            if (!file2.isDirectory() && "app.yaml".equals(file2.getName())) {
                this.myConfigFile = file2;
                return false;
            }
            return true;
        }
    }
}

