/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.appengine.util;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.jetbrains.django.util.DjangoPythonUtil;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDictLiteralExpression;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AppEnginePythonUtil
extends DjangoPythonUtil {
    @Nullable
    public static PyClass getConstructorClass(PyCallExpression call) {
        ResolveResult[] targets;
        PyExpression callee = call.getCallee();
        if (callee == null) {
            return null;
        }
        PsiReference psiReference = callee.getReference();
        if (psiReference instanceof PsiPolyVariantReference && (targets = ((PsiPolyVariantReference)psiReference).multiResolve(false)).length > 0) {
            PsiElement target = targets[0].getElement();
            if (target instanceof PyClass) {
                return (PyClass)target;
            }
            return PyUtil.turnConstructorIntoClass(PyUtil.as(target, PyFunction.class));
        }
        return null;
    }

    @Nullable
    public static String getPythonModule(PyElement elem) {
        PsiFile psiFile = elem.getContainingFile();
        if (psiFile instanceof PyFile) {
            ArrayList<String> names = new ArrayList<String>();
            String name = psiFile.getName();
            if (!name.endsWith(".py")) {
                return null;
            }
            name = name.substring(0, name.length() - ".py".length());
            if (!"__init__".equals(name)) {
                names.add(name);
            }
            for (PsiDirectory dir = psiFile.getContainingDirectory(); dir != null && AppEnginePythonUtil.isPythonModule(dir); dir = dir.getParentDirectory()) {
                names.add(dir.getName());
            }
            Collections.reverse(names);
            return StringUtil.join(names, (String)".");
        }
        return null;
    }

    private static boolean isPythonModule(PsiDirectory dir) {
        return dir != null && dir.findFile("__init__.py") != null;
    }

    public static Set<String> getKeyNames(PyDictLiteralExpression dict) {
        HashSet<String> result = new HashSet<String>();
        Set<LookupElement> keys = AppEnginePythonUtil.getKeys(dict);
        if (keys != null) {
            for (LookupElement key : keys) {
                result.add(key.getLookupString());
            }
        }
        return result;
    }

    public static Set<String> getArgumentNames(PyExpression[] args2, int offset) {
        HashSet<String> result = new HashSet<String>();
        for (int i = offset; i < args2.length; ++i) {
            PyExpression arg = args2[i];
            if (!(arg instanceof PyKeywordArgument)) continue;
            PyKeywordArgument keywordArgument = (PyKeywordArgument)arg;
            result.add(keywordArgument.getKeyword());
        }
        return result;
    }

    @Nullable
    public static PyClass getStaticMethodClass(@NotNull PyCallExpression call) {
        PsiElement target;
        PyExpression qualifier;
        PyExpression callee;
        if (call == null) {
            AppEnginePythonUtil.$$$reportNull$$$0(0);
        }
        if ((callee = call.getCallee()) instanceof PyReferenceExpression && (qualifier = ((PyReferenceExpression)callee).getQualifier()) instanceof PyReferenceExpression && (target = ((PyReferenceExpression)qualifier).getReference().resolve()) instanceof PyClass) {
            return (PyClass)target;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/jetbrains/appengine/util/AppEnginePythonUtil", "getStaticMethodClass"));
    }
}

