/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.appengine.util;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.appengine.facet.AppEngineWizardSettingsHolder;
import com.jetbrains.appengine.ui.AppEngineBundle;
import com.jetbrains.django.util.VirtualFileUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class AppEngineProjectCreator {
    @NonNls
    private static final String MAIN_PY = "main.py";
    @NonNls
    private static final String CONFIG = "appengine_config.py";
    @NonNls
    private static final String PLACEHOLDER_PROJECT_NAME_MAIN_PY = "${project_name}";
    @NonNls
    private static final String PLACEHOLDER_PROJECT_NAME_APP_YAML = "new-project-template";
    @NonNls
    private static final Map<String, String> libToMain = new ContainerUtil.ImmutableMapBuilder().put((Object)"Django", (Object)"main.py").put((Object)"Flask", (Object)"main-flask.py").build();
    @NonNls
    private static final Map<String, String> libToYaml = new ContainerUtil.ImmutableMapBuilder().put((Object)"Django", (Object)"app27-django.yaml").put((Object)"Flask", (Object)"app-flask.yaml").build();

    private static String loadTemplate(String name) throws IOException {
        Package aPackage = AppEngineBundle.class.getPackage();
        String resourceName = "/" + aPackage.getName().replace(".", "/") + "/" + name + ".txt";
        InputStream in = AppEngineBundle.class.getResourceAsStream(resourceName);
        return FileUtil.loadTextAndClose((InputStream)in);
    }

    public static void createProject(@NotNull VirtualFile contentRoot, @NotNull AppEngineWizardSettingsHolder settings) throws IOException {
        String appEngineSdkPath;
        VirtualFile appEngineSdkFolder;
        if (contentRoot == null) {
            AppEngineProjectCreator.$$$reportNull$$$0(0);
        }
        if (settings == null) {
            AppEngineProjectCreator.$$$reportNull$$$0(1);
        }
        if ((appEngineSdkFolder = VirtualFileUtil.findFile(appEngineSdkPath = settings.getAppEngineSdkFolder())) == null) {
            return;
        }
        VirtualFile appEngineTemplatesFolder = appEngineSdkFolder.findChild("new_project_template");
        if (appEngineTemplatesFolder != null) {
            AppEngineProjectCreator.generateMainPy(contentRoot, appEngineTemplatesFolder, settings);
            AppEngineProjectCreator.generateAppYaml(contentRoot, appEngineTemplatesFolder, settings);
            AppEngineProjectCreator.generateConfig(contentRoot, settings);
            contentRoot.refresh(false, true);
        }
    }

    private static void generateConfig(@NotNull VirtualFile contentRoot, @NotNull AppEngineWizardSettingsHolder settings) throws IOException {
        String lib;
        if (contentRoot == null) {
            AppEngineProjectCreator.$$$reportNull$$$0(2);
        }
        if (settings == null) {
            AppEngineProjectCreator.$$$reportNull$$$0(3);
        }
        if ("Flask".equals(lib = settings.getThirdPartyLib())) {
            File configFile = new File(contentRoot.getPath(), CONFIG);
            if (configFile.exists()) {
                return;
            }
            String text2 = AppEngineProjectCreator.loadTemplate(CONFIG);
            FileUtil.writeToFile((File)configFile, (byte[])text2.getBytes(StandardCharsets.UTF_8));
        }
    }

    private static void generateAppYaml(@NotNull VirtualFile contentRoot, @NotNull VirtualFile appEngineTemplatesFolder, @NotNull AppEngineWizardSettingsHolder settings) throws IOException {
        String text2;
        File appYaml;
        if (contentRoot == null) {
            AppEngineProjectCreator.$$$reportNull$$$0(4);
        }
        if (appEngineTemplatesFolder == null) {
            AppEngineProjectCreator.$$$reportNull$$$0(5);
        }
        if (settings == null) {
            AppEngineProjectCreator.$$$reportNull$$$0(6);
        }
        if ((appYaml = new File(contentRoot.getPath(), "app.yaml")).exists()) {
            return;
        }
        String applicationId = settings.getApplicationId();
        String thirdPartyLib = settings.getThirdPartyLib();
        if (thirdPartyLib != null) {
            String templateFile = libToYaml.get(thirdPartyLib);
            text2 = AppEngineProjectCreator.loadTemplate(templateFile);
        } else {
            File yamlTemplate = new File(appEngineTemplatesFolder.getPath(), "app.yaml");
            if (!yamlTemplate.exists()) {
                return;
            }
            text2 = FileUtil.loadFile((File)yamlTemplate);
        }
        text2 = text2.replace(PLACEHOLDER_PROJECT_NAME_APP_YAML, applicationId);
        FileUtil.writeToFile((File)appYaml, (byte[])text2.getBytes(StandardCharsets.UTF_8));
    }

    private static void generateMainPy(@NotNull VirtualFile contentRoot, @NotNull VirtualFile appEngineTemplatesFolder, @NotNull AppEngineWizardSettingsHolder settings) throws IOException {
        File mainPy;
        if (contentRoot == null) {
            AppEngineProjectCreator.$$$reportNull$$$0(7);
        }
        if (appEngineTemplatesFolder == null) {
            AppEngineProjectCreator.$$$reportNull$$$0(8);
        }
        if (settings == null) {
            AppEngineProjectCreator.$$$reportNull$$$0(9);
        }
        if ((mainPy = new File(contentRoot.getPath(), MAIN_PY)).exists()) {
            return;
        }
        String lib = settings.getThirdPartyLib();
        if (lib != null) {
            String djangoProjectName = settings.getProjectName();
            String templateMain = libToMain.get(lib);
            String mainTemplateDjango = AppEngineProjectCreator.loadTemplate(templateMain);
            if (djangoProjectName != null) {
                mainTemplateDjango = mainTemplateDjango.replace(PLACEHOLDER_PROJECT_NAME_MAIN_PY, djangoProjectName);
            }
            FileUtil.writeToFile((File)mainPy, (String)mainTemplateDjango);
        } else {
            VirtualFile mainTemplateWebapp = appEngineTemplatesFolder.findChild(MAIN_PY);
            if (mainTemplateWebapp != null) {
                FileUtil.copy((File)new File(mainTemplateWebapp.getPath()), (File)mainPy);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentRoot";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appEngineTemplatesFolder";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/appengine/util/AppEngineProjectCreator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createProject";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "generateConfig";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "generateAppYaml";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "generateMainPy";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

