/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.appengine.run;

import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PlatformUtils;
import com.jetbrains.appengine.facet.AppEngineFacet;
import com.jetbrains.appengine.facet.AppEngineFacetConfiguration;
import com.jetbrains.appengine.facet.AppEngineFacetType;
import com.jetbrains.appengine.run.AppEngineServerRunCommandLineState;
import com.jetbrains.appengine.run.AppEngineServerRunConfigurationEditor;
import com.jetbrains.appengine.ui.AppEngineBundle;
import com.jetbrains.appengine.util.AppEngineUtil;
import com.jetbrains.python.run.AbstractServerPythonRunConfiguration;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class AppEngineServerRunConfiguration
extends AbstractServerPythonRunConfiguration<AppEngineServerRunConfiguration> {
    private Integer myPort;
    private String myHost = "127.0.0.1";
    private String myBrowserUrl = null;
    private String myAdditionalOptions = "";
    private static final String ATTR_PORT = "port";
    private static final String ATTR_HOST = "host";
    private static final String ATTR_BROWSER_URL = "browserUrl";
    private static final String ATTR_ADDITIONAL_OPTIONS = "additionalOptions";

    public AppEngineServerRunConfiguration(Project project, ConfigurationFactory configurationFactory) {
        super(project, configurationFactory);
    }

    @Override
    public List<Module> getValidModules() {
        ArrayList<Module> result = new ArrayList<Module>();
        for (Module module : super.getValidModules()) {
            if (!AppEngineFacet.isPresent(module)) continue;
            result.add(module);
        }
        return result;
    }

    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) {
        if (executor == null) {
            AppEngineServerRunConfiguration.$$$reportNull$$$0(0);
        }
        if (env == null) {
            AppEngineServerRunConfiguration.$$$reportNull$$$0(1);
        }
        return new AppEngineServerRunCommandLineState(this, env);
    }

    public String getHost() {
        return this.myHost;
    }

    public void setHost(String host) {
        this.myHost = host;
    }

    public Integer getPort() {
        return this.myPort;
    }

    public void setPort(Integer port) {
        this.myPort = port;
    }

    public String getBrowserUrl() {
        return this.myBrowserUrl;
    }

    public void setBrowserUrl(String browserUrl) {
        this.myBrowserUrl = browserUrl;
    }

    public String getAdditionalOptions() {
        return this.myAdditionalOptions;
    }

    public void setAdditionalOptions(String additionalOptions) {
        this.myAdditionalOptions = additionalOptions;
    }

    protected AppEngineServerRunConfigurationEditor createConfigurationEditor() {
        return new AppEngineServerRunConfigurationEditor(this);
    }

    @Override
    public void checkConfiguration() throws RuntimeConfigurationException {
        AppEngineFacet facet;
        super.checkConfiguration();
        Module module = this.getModule();
        AppEngineFacet appEngineFacet = facet = module == null ? null : AppEngineFacet.getInstance(module);
        if (facet == null) {
            if (PlatformUtils.isPyCharm()) {
                RuntimeConfigurationError exc = new RuntimeConfigurationError("Please enable App Engine support for the project");
                exc.setQuickFix((Runnable)new EditAppEngineSettingsFix());
                throw exc;
            }
            throw new RuntimeConfigurationError("Please configure the App Engine facet for the module");
        }
        String sdkFolder = ((AppEngineFacetConfiguration)facet.getConfiguration()).getSdkFolder();
        if (!AppEngineUtil.isStandaloneAppEgineSdkFolder(sdkFolder)) {
            RuntimeConfigurationError exc = new RuntimeConfigurationError("Please specify a valid App Engine SDK folder");
            if (PlatformUtils.isPyCharm()) {
                exc.setQuickFix((Runnable)new EditAppEngineSettingsFix());
            }
            throw exc;
        }
    }

    @Override
    public void readExternal(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            AppEngineServerRunConfiguration.$$$reportNull$$$0(2);
        }
        super.readExternal(element);
        this.myHost = JDOMExternalizerUtil.readField((Element)element, (String)ATTR_HOST);
        String s = JDOMExternalizerUtil.readField((Element)element, (String)ATTR_PORT);
        this.myPort = !StringUtil.isEmpty((String)s) ? Integer.valueOf(Integer.parseInt(s)) : null;
        String url = JDOMExternalizerUtil.readField((Element)element, (String)ATTR_BROWSER_URL);
        this.myBrowserUrl = url != null && url.length() > 0 ? url : null;
        this.myAdditionalOptions = JDOMExternalizerUtil.readField((Element)element, (String)ATTR_ADDITIONAL_OPTIONS);
    }

    @Override
    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            AppEngineServerRunConfiguration.$$$reportNull$$$0(3);
        }
        super.writeExternal(element);
        JDOMExternalizerUtil.writeField((Element)element, (String)ATTR_HOST, (String)this.myHost);
        if (this.myPort != null) {
            JDOMExternalizerUtil.writeField((Element)element, (String)ATTR_PORT, (String)Integer.toString(this.myPort));
        }
        JDOMExternalizerUtil.writeField((Element)element, (String)ATTR_BROWSER_URL, (String)this.myBrowserUrl);
        JDOMExternalizerUtil.writeField((Element)element, (String)ATTR_ADDITIONAL_OPTIONS, (String)this.myAdditionalOptions);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/appengine/run/AppEngineServerRunConfiguration";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getState";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "readExternal";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "writeExternal";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class EditAppEngineSettingsFix
    implements Runnable {
        private EditAppEngineSettingsFix() {
        }

        @Override
        public void run() {
            FileChooserDescriptor descriptor2 = FileChooserDescriptorFactory.createSingleFolderDescriptor();
            String title = AppEngineBundle.message("select-sdk-folder-title", new Object[0]);
            String desc = AppEngineBundle.message("select-sdk-folder-desc", new Object[0]);
            descriptor2.setTitle(title);
            descriptor2.setDescription(desc);
            VirtualFile file2 = FileChooser.chooseFile((FileChooserDescriptor)descriptor2, (Project)AppEngineServerRunConfiguration.this.getProject(), null);
            Module module = AppEngineServerRunConfiguration.this.getModule();
            if (module == null) {
                return;
            }
            AppEngineFacet facet = AppEngineFacet.getInstance(module);
            if (facet == null) {
                AppEngineFacetConfiguration configuration = AppEngineFacetType.getDefaultConfiguration(AppEngineServerRunConfiguration.this.getProject());
                AppEngineFacetType.createAppEngineFacet(module, configuration);
            }
            if ((facet = AppEngineFacet.getInstance(module)) != null && file2 != null) {
                String path = file2.getCanonicalPath();
                if (path != null && AppEngineUtil.isGoogleCloudSdkFolder(path)) {
                    path = AppEngineUtil.getAppEngineComponent(path);
                }
                ((AppEngineFacetConfiguration)facet.getConfiguration()).setSdkFolder(path);
            }
        }
    }
}

