/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.appengine.run;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.appengine.facet.AppEngineFacet;
import com.jetbrains.appengine.facet.AppEngineFacetConfiguration;
import com.jetbrains.appengine.run.AppEngineServerRunConfiguration;
import com.jetbrains.appengine.util.AppEngineUtil;
import com.jetbrains.django.run.DjangoServerRunCommandLineState;
import com.jetbrains.django.util.VirtualFileUtil;
import com.jetbrains.python.run.CommandLinePatcher;
import com.jetbrains.python.run.PythonCommandLineState;
import com.jetbrains.python.run.PythonProcessRunner;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AppEngineServerRunCommandLineState
extends PythonCommandLineState {
    private final AppEngineServerRunConfiguration myConfig;

    public AppEngineServerRunCommandLineState(AppEngineServerRunConfiguration runConfiguration, ExecutionEnvironment env) {
        super(runConfiguration, env);
        this.myConfig = runConfiguration;
    }

    @Override
    protected void buildCommandLineParameters(GeneralCommandLine commandLine) {
        String host;
        Module module = this.myConfig.getModule();
        if (module == null) {
            return;
        }
        AppEngineFacetConfiguration facetConfig = AppEngineFacet.getConfig(module);
        if (facetConfig == null) {
            return;
        }
        String workDir = this.myConfig.getWorkingDirectory();
        if (!StringUtil.isEmpty((String)workDir)) {
            commandLine.setWorkDirectory(workDir);
        } else {
            commandLine.setWorkDirectory(facetConfig.getProjectRoot());
        }
        ParametersList params = commandLine.getParametersList();
        ParametersList parametersList = commandLine.getParametersList();
        ParamsGroup exe_options = parametersList.getParamsGroup("Exe Options");
        assert (exe_options != null);
        exe_options.addParametersString(this.myConfig.getInterpreterOptions());
        ParamsGroup group2 = params.getParamsGroup("Script");
        assert (group2 != null);
        group2.addParameter(AppEngineServerRunCommandLineState.getDevAppServerPath(facetConfig));
        Integer port = this.myConfig.getPort();
        if (port != null) {
            group2.addParameter("--port");
            group2.addParameter(Integer.toString(port));
        }
        if ((host = this.myConfig.getHost()) != null && !StringUtil.isEmptyOrSpaces((String)host)) {
            group2.addParameter("--host");
            group2.addParameter(host);
        }
        String additionalOptions = this.myConfig.getAdditionalOptions();
        boolean addDotParam = true;
        if (!StringUtil.isEmptyOrSpaces((String)additionalOptions)) {
            String[] options;
            for (String option : options = ParametersList.parse((String)additionalOptions)) {
                if (option.startsWith("--") && !".".equals(option)) continue;
                addDotParam = false;
                break;
            }
            group2.addParametersString(additionalOptions);
        }
        if (addDotParam) {
            group2.addParameter(".");
        }
    }

    @NotNull
    private static String getDevAppServerPath(@NotNull AppEngineFacetConfiguration facetConfig) {
        String sdkFolder;
        String googleCloudSdkRoot;
        if (facetConfig == null) {
            AppEngineServerRunCommandLineState.$$$reportNull$$$0(0);
        }
        if ((googleCloudSdkRoot = AppEngineServerRunCommandLineState.getGoogleCloudSdkRoot(sdkFolder = facetConfig.getSdkFolder())) != null) {
            String string = VirtualFileUtil.buildSystemIndependentPath(FileUtil.join((String[])new String[]{googleCloudSdkRoot, "bin"}), "dev_appserver.py");
            if (string == null) {
                AppEngineServerRunCommandLineState.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = VirtualFileUtil.buildSystemIndependentPath(sdkFolder, "dev_appserver.py");
        if (string == null) {
            AppEngineServerRunCommandLineState.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    private static String getGoogleCloudSdkRoot(String sdkFolder) {
        File platformFolderCandidate = new File(sdkFolder).getParentFile();
        if (platformFolderCandidate == null) {
            return null;
        }
        String googleCloudSdkRoot = platformFolderCandidate.getParent();
        boolean isGoogleCloudSdkRoot = googleCloudSdkRoot != null && AppEngineUtil.isGoogleCloudSdkFolder(googleCloudSdkRoot);
        return !isGoogleCloudSdkRoot ? null : googleCloudSdkRoot;
    }

    @Override
    protected ProcessHandler doCreateProcess(GeneralCommandLine commandLine) throws ExecutionException {
        return PythonProcessRunner.createProcessHandlingCtrlC(commandLine);
    }

    @Override
    @NotNull
    protected ProcessHandler startProcess(PythonCommandLineState.PythonProcessStarter processStarter, CommandLinePatcher ... patchers2) throws ExecutionException {
        ProcessHandler processHandler2 = super.startProcess(processStarter, patchers2);
        DjangoServerRunCommandLineState.addRunBrowserListener(processHandler2, this.myConfig.getBrowserUrl(), "starting module", (RunConfiguration)this.myConfig, this.myConfig.isLaunchJavascriptDebugger());
        ProcessHandler processHandler3 = processHandler2;
        if (processHandler3 == null) {
            AppEngineServerRunCommandLineState.$$$reportNull$$$0(3);
        }
        return processHandler3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facetConfig";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/appengine/run/AppEngineServerRunCommandLineState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/appengine/run/AppEngineServerRunCommandLineState";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDevAppServerPath";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "startProcess";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDevAppServerPath";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

