/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.appengine.ref;

import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.CachingReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.appengine.ref.AppEngineLazyHandlerReferenceSet;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.psi.resolve.ResolveImportUtil;
import com.jetbrains.python.psi.search.PyClassInheritorsSearch;
import com.jetbrains.python.psi.stubs.PyClassNameIndex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AppEngineItemReference
implements PsiReference {
    private final String myText;
    private final PyStringLiteralExpression myElement;
    private final AppEngineLazyHandlerReferenceSet myReferenceSet;
    private final int myIndex;
    private TextRange myRangeInElement;

    public AppEngineItemReference(@NotNull PyStringLiteralExpression element, String text2, TextRange rangeInElement, AppEngineLazyHandlerReferenceSet referenceSet, int index) {
        if (element == null) {
            AppEngineItemReference.$$$reportNull$$$0(0);
        }
        this.myElement = element;
        this.myText = text2;
        this.myRangeInElement = rangeInElement;
        this.myReferenceSet = referenceSet;
        this.myIndex = index;
    }

    @NotNull
    public PsiElement getElement() {
        PyStringLiteralExpression pyStringLiteralExpression = this.myElement;
        if (pyStringLiteralExpression == null) {
            AppEngineItemReference.$$$reportNull$$$0(1);
        }
        return pyStringLiteralExpression;
    }

    @NotNull
    public TextRange getRangeInElement() {
        TextRange textRange = this.myRangeInElement;
        if (textRange == null) {
            AppEngineItemReference.$$$reportNull$$$0(2);
        }
        return textRange;
    }

    @Nullable
    public PsiElement resolve() {
        int parentIndex;
        if (this.myIndex == 0) {
            return AppEngineItemReference.resolveInContext(this.myElement, this.myText);
        }
        int n = parentIndex = this.myIndex - 1 >= 0 ? this.myIndex - 1 : this.myIndex;
        if (parentIndex >= this.myReferenceSet.getItemReferences().size()) {
            return null;
        }
        AppEngineItemReference parent = this.myReferenceSet.getItemReferences().get(parentIndex);
        PsiElement parentElement = parent.resolve();
        if (parentElement == null) {
            return null;
        }
        return ResolveImportUtil.resolveChild(parentElement, this.myText, null, false, false, false);
    }

    private static PsiElement resolveInContext(PyStringLiteralExpression element, String text2) {
        PsiDirectory parent;
        PsiFile file2 = element.getContainingFile();
        ArrayList<Object> context = new ArrayList<Object>();
        if (file2 == null) {
            return null;
        }
        context.add(file2);
        for (parent = file2.getParent(); parent != null && !parent.getVirtualFile().getPath().equals(element.getProject().getBasePath()); parent = parent.getParent()) {
            context.add(parent);
        }
        context.add(parent);
        for (PsiElement psiElement : context) {
            PsiElement res = ResolveImportUtil.resolveChild(psiElement, text2, null, false, false, false);
            if (res == null || !AppEngineItemReference.isAllowedAsResolveResult(res)) continue;
            return res;
        }
        return null;
    }

    private static boolean isAllowedAsResolveResult(PsiElement res) {
        return res instanceof PsiDirectory || res instanceof PsiFile || res instanceof PyClass;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.myText;
        if (string == null) {
            AppEngineItemReference.$$$reportNull$$$0(3);
        }
        return string;
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        if (newElementName == null) {
            AppEngineItemReference.$$$reportNull$$$0(4);
        }
        ElementManipulator manipulator = CachingReference.getManipulator((PsiElement)this.getElement());
        String newName = FileUtilRt.getNameWithoutExtension((String)newElementName);
        manipulator.handleContentChange((PsiElement)this.myElement, this.myRangeInElement, newName);
        this.myRangeInElement = new TextRange(this.getRangeInElement().getStartOffset(), this.getRangeInElement().getStartOffset() + newName.length());
        return this.myElement;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            AppEngineItemReference.$$$reportNull$$$0(5);
        }
        if (element.equals(this.myElement)) {
            return element;
        }
        if (element instanceof PyClass) {
            PyClass cls = (PyClass)element;
            QualifiedName qname = QualifiedNameFinder.findCanonicalImportPath((PsiElement)cls, element);
            if (qname != null) {
                qname = qname.append(cls.getName());
                return ElementManipulators.handleContentChange((PsiElement)this.myElement, (String)qname.toString());
            }
        } else {
            PyClass requestClass = PyClassNameIndex.findClass("webapp2.RequestHandler", this.getElement().getProject());
            if (requestClass == null) {
                return null;
            }
            Collection pyClasses = PsiTreeUtil.findChildrenOfType((PsiElement)element, PyClass.class);
            for (PyClass pyClass : pyClasses) {
                List<PyClass> classes = pyClass.getAncestorClasses(null);
                if (!classes.contains(requestClass)) continue;
                String newQualifiedName = pyClass.getQualifiedName();
                String movedClassName = pyClass.getName();
                String referenceClassName = this.myReferenceSet.getClassName();
                if (movedClassName == null || newQualifiedName == null || !movedClassName.equals(referenceClassName)) continue;
                return ElementManipulators.handleContentChange((PsiElement)this.myElement, (String)newQualifiedName);
            }
        }
        return null;
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        String name;
        if (element == null) {
            AppEngineItemReference.$$$reportNull$$$0(6);
        }
        if (element instanceof PsiNamedElement && ((name = ((PsiNamedElement)element).getName()) == null || !name.equals(this.myText) && !name.equals("__init__.py") && !name.equals(this.myText + ".py"))) {
            return false;
        }
        return element == this.resolve();
    }

    public Object @NotNull [] getVariants() {
        ArrayList result = new ArrayList();
        String currentPath = StringUtil.join(this.myReferenceSet.getItemReferences(), reference -> reference.getCanonicalText(), (String)".");
        PyClass requestClass = PyClassNameIndex.findClass("webapp2.RequestHandler", this.getElement().getProject());
        if (requestClass != null) {
            PyClassInheritorsSearch.search(requestClass, false).forEach(pyClass -> {
                String qualifiedName;
                if (PsiSearchScopeUtil.isInScope((GlobalSearchScope)GlobalSearchScope.projectScope((Project)pyClass.getProject()), (PsiElement)pyClass) && (qualifiedName = pyClass.getQualifiedName()) != null) {
                    if (currentPath.isEmpty()) {
                        result.add(LookupElementBuilder.create((String)qualifiedName));
                    } else if (qualifiedName.startsWith(currentPath)) {
                        String name = qualifiedName.substring(currentPath.length() + 1);
                        result.add(LookupElementBuilder.create((String)name));
                    }
                }
                return true;
            });
        }
        Object[] objectArray = result.toArray();
        if (objectArray == null) {
            AppEngineItemReference.$$$reportNull$$$0(7);
        }
        return objectArray;
    }

    public boolean isSoft() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/appengine/ref/AppEngineItemReference";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/appengine/ref/AppEngineItemReference";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

