/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.appengine.model;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.appengine.util.AppEnginePythonUtil;
import com.jetbrains.django.util.DjangoPythonUtil;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.stubs.PyClassNameIndex;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModelManager {
    private static final String FIELD_TYPE_SUFFIX = "Property";
    private final Module myModule;

    public ModelManager(@NotNull Module module) {
        if (module == null) {
            ModelManager.$$$reportNull$$$0(0);
        }
        this.myModule = module;
    }

    public Set<PyClass> getModels() {
        HashSet<PyClass> result = new HashSet<PyClass>();
        Collection<String> classes = PyClassNameIndex.allKeys(this.getProject());
        PyClass baseClass = this.getModelBaseClass();
        for (String className : classes) {
            for (PyClass projectClass : this.findClasses(className, false)) {
                if (projectClass == baseClass || !ModelManager.isModel(projectClass, baseClass)) continue;
                result.add(projectClass);
            }
        }
        return result;
    }

    @Nullable
    public PyClass findModel(String name) {
        Collection<PyClass> classes = this.findClasses(name, false);
        if (!classes.isEmpty()) {
            return classes.iterator().next();
        }
        return null;
    }

    private PyClass getModelBaseClass() {
        return this.findClass("Model", "google.appengine.ext.db", true);
    }

    public boolean isModel(PyClass aClass) {
        return ModelManager.isModel(aClass, this.getModelBaseClass());
    }

    private static boolean isModel(PyClass aClass, PyClass modelClass) {
        return aClass != null && modelClass != null && aClass.isSubclass(modelClass, null);
    }

    public static Set<String> getMappedFields(PyClass model) {
        HashSet<String> result = new HashSet<String>();
        for (PyTargetExpression expr : model.getClassAttributes()) {
            if (!ModelManager.isModelFieldTypeConstructor(expr.findAssignedValue())) continue;
            result.add(expr.getName());
        }
        return result;
    }

    @Nullable
    public static PsiElement findField(PyClass model, String property) {
        for (PyTargetExpression expr : model.getClassAttributes()) {
            if (!property.equals(expr.getName())) continue;
            return expr;
        }
        return null;
    }

    private Collection<PyClass> findClasses(String name, boolean includeNonProjectItems) {
        return PyClassNameIndex.find(name, this.getProject(), includeNonProjectItems);
    }

    @Nullable
    private PyClass findClass(String name, String module, boolean includeNonProjectItems) {
        for (PyClass aClass : this.findClasses(name, includeNonProjectItems)) {
            String packageName = AppEnginePythonUtil.getPythonModule(aClass);
            if (!module.equals(packageName)) continue;
            return aClass;
        }
        return null;
    }

    public static ModelManager getInstance(@NotNull Module module) {
        if (module == null) {
            ModelManager.$$$reportNull$$$0(1);
        }
        return new ModelManager(module);
    }

    private Project getProject() {
        return this.myModule.getProject();
    }

    private static boolean isModelFieldTypeConstructor(@Nullable PyExpression expr) {
        PyCallExpression call;
        String name;
        return expr instanceof PyCallExpression && (name = DjangoPythonUtil.getCallName(call = (PyCallExpression)expr)) != null && name.endsWith(FIELD_TYPE_SUFFIX) && ContainerUtil.exists(call.multiResolveCalleeFunction(PyResolveContext.defaultContext()), callable -> "google.appengine.ext.db".equals(AppEnginePythonUtil.getPythonModule(callable)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "module";
        objectArray2[1] = "com/jetbrains/appengine/model/ModelManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstance";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

