/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.appengine.lang.gql.ref;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtilRt;
import com.jetbrains.appengine.lang.gql.psi.GqlProperty;
import com.jetbrains.appengine.lang.gql.psi.GqlQuery;
import com.jetbrains.appengine.lang.gql.ref.GqlReferenceBase;
import com.jetbrains.appengine.model.ModelManager;
import com.jetbrains.appengine.util.AppEngineUtil;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GqlPropertyReference
extends GqlReferenceBase {
    public GqlPropertyReference(GqlProperty element) {
        super(element);
    }

    public PsiElement resolve() {
        PyClass entityClass;
        String kind = this.getKind();
        String property = ((GqlProperty)this.myElement).getPropertyName();
        if (!StringUtil.isEmpty((String)kind) && !StringUtil.isEmpty((String)property) && (entityClass = this.getManager().findModel(kind)) != null) {
            return ModelManager.findField(entityClass, property);
        }
        return null;
    }

    public Object @NotNull [] getVariants() {
        PyClass entityClass;
        String kind = this.getKind();
        if (!StringUtil.isEmpty((String)kind) && (entityClass = this.getManager().findModel(kind)) != null) {
            Set<String> fields = ModelManager.getMappedFields(entityClass);
            Object[] objectArray = fields.toArray();
            if (objectArray == null) {
                GqlPropertyReference.$$$reportNull$$$0(0);
            }
            return objectArray;
        }
        if (ArrayUtilRt.EMPTY_OBJECT_ARRAY == null) {
            GqlPropertyReference.$$$reportNull$$$0(1);
        }
        return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
    }

    @Nullable
    private String getKind() {
        GqlQuery query = (GqlQuery)PsiTreeUtil.getParentOfType((PsiElement)this.myElement, GqlQuery.class);
        if (query != null) {
            String kind = query.getKind();
            if (kind != null) {
                return kind;
            }
            PsiLanguageInjectionHost host = InjectedLanguageManager.getInstance((Project)this.myElement.getProject()).getInjectionHost(this.myElement);
            if (host instanceof PyStringLiteralExpression) {
                PyStringLiteralExpression str = (PyStringLiteralExpression)host;
                PyClass entityClass = AppEngineUtil.getEntityClass(str);
                return entityClass != null ? entityClass.getName() : null;
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/appengine/lang/gql/ref/GqlPropertyReference", "getVariants"));
    }
}

