/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.appengine.lang.gql.parsing.parser;

import com.intellij.lang.ASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiParser;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.appengine.lang.gql.parsing.GqlTokenTypes;
import com.jetbrains.appengine.lang.gql.parsing.parser.Parsing;
import com.jetbrains.appengine.lang.gql.psi.GqlElementTypes;
import com.jetbrains.appengine.ui.AppEngineBundle;
import org.jetbrains.annotations.NotNull;

public class GqlParser
implements PsiParser,
GqlTokenTypes {
    @NotNull
    public ASTNode parse(IElementType iElementType, PsiBuilder builder) {
        builder.enforceCommentTokens(TokenSet.EMPTY);
        PsiBuilder.Marker file2 = builder.mark();
        GqlParsing parsing = new GqlParsing(builder);
        parsing.parse();
        file2.done((IElementType)GqlElementTypes.GQL_FILE);
        ASTNode aSTNode = builder.getTreeBuilt();
        if (aSTNode == null) {
            GqlParser.$$$reportNull$$$0(0);
        }
        return aSTNode;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/appengine/lang/gql/parsing/parser/GqlParser", "parse"));
    }

    public static class GqlParsing
    extends Parsing {
        public GqlParsing(PsiBuilder psiBuilder) {
            super(psiBuilder);
        }

        public void parse() {
            PsiBuilder.Marker query = this.mark();
            this.parseSelect();
            this.parseFrom();
            this.parseWhere();
            this.parseOrderBy();
            this.parseLimit();
            this.parseOffset();
            this.consumeErrors();
            query.done(GqlElementTypes.QUERY);
        }

        private void consumeErrors() {
            while (!this.eof()) {
                this.errorToken("Unexpected token");
            }
        }

        private void parseSelect() {
            if (this.hasTokenType(GqlTokenTypes.SELECT, new IElementType[0])) {
                PsiBuilder.Marker expr = this.mark();
                this.advance();
                if (this.hasTokenType(GqlTokenTypes.STAR, GqlTokenTypes.ID)) {
                    if (this.hasTokenType(GqlTokenTypes.ID, new IElementType[0]) && !"__key__".equals(this.getTokenText())) {
                        this.error("* or __key__ expected");
                    }
                    this.createTokenElement(GqlElementTypes.SELECT_FIELDS);
                } else {
                    this.error("* or __key__ expected");
                }
                expr.done(GqlElementTypes.SELECT);
            }
        }

        private void parseFrom() {
            if (this.hasTokenType(GqlTokenTypes.FROM, new IElementType[0])) {
                PsiBuilder.Marker expr = this.mark();
                this.advance();
                if (this.hasTokenType(GqlTokenTypes.ID, new IElementType[0])) {
                    this.createTokenElement(GqlElementTypes.CLASS_NAME);
                } else {
                    this.error("ID expected");
                }
                expr.done(GqlElementTypes.FROM);
            }
        }

        private boolean parseWhere() {
            if (this.hasTokenType(GqlTokenTypes.WHERE, new IElementType[0])) {
                PsiBuilder.Marker expr = this.mark();
                this.advance();
                if (!this.parseConditions()) {
                    return false;
                }
                expr.done(GqlElementTypes.WHERE);
                return true;
            }
            return true;
        }

        private boolean parseConditions() {
            PsiBuilder.Marker expr = this.mark();
            if (!this.parseCondition()) {
                expr.drop();
                return false;
            }
            while (this.hasTokenType(GqlTokenTypes.AND, new IElementType[0])) {
                this.advance();
                if (!this.parseCondition()) {
                    this.error("Expression expected");
                }
                expr.done(GqlElementTypes.AND);
                expr = expr.precede();
            }
            expr.drop();
            return true;
        }

        private boolean parseCondition() {
            if (this.hasTokenType(GqlTokenTypes.ID, new IElementType[0])) {
                PsiBuilder.Marker expr = this.mark();
                this.createTokenElement(GqlElementTypes.PROPERTY);
                if (this.hasTokenType(GqlTokenTypes.LT, GqlTokenTypes.GT, GqlTokenTypes.LTE, GqlTokenTypes.GTE, GqlTokenTypes.EQ, GqlTokenTypes.NEQ)) {
                    this.createTokenElement(this.hasTokenType(GqlTokenTypes.EQ, new IElementType[0]) ? GqlElementTypes.EQ : GqlElementTypes.NEQ);
                    if (this.hasTokenType(GqlTokenTypes.COLON, new IElementType[0])) {
                        this.parseBinding();
                    } else {
                        this.parseLiteral(true);
                    }
                    expr.done(GqlElementTypes.COMPARE);
                } else if (this.hasTokenType(GqlTokenTypes.IN, new IElementType[0])) {
                    this.createTokenElement(GqlElementTypes.EQ);
                    if (this.hasTokenType(GqlTokenTypes.COLON, new IElementType[0])) {
                        this.parseBinding();
                    } else {
                        this.parseList();
                    }
                    expr.done(GqlElementTypes.IN);
                } else {
                    this.error(AppEngineBundle.message("parser-error.operation-expected", new Object[0]));
                    expr.drop();
                }
            } else if (this.hasTokenType(GqlTokenTypes.ANCESTOR, new IElementType[0])) {
                PsiBuilder.Marker expr = this.mark();
                this.advance();
                if (this.hasTokenType(GqlTokenTypes.IS, new IElementType[0])) {
                    this.advance();
                } else {
                    this.error("IS expected");
                }
                if (this.hasTokenType(GqlTokenTypes.COLON, new IElementType[0])) {
                    this.parseBinding();
                } else if (this.hasTokenType(GqlTokenTypes.ID, new IElementType[0])) {
                    boolean key = "KEY".equalsIgnoreCase(this.getTokenText());
                    this.createTokenElement(GqlElementTypes.PROPERTY);
                    if (key) {
                        this.parseList();
                    }
                } else {
                    this.error("ID or key expected");
                }
                expr.done(GqlElementTypes.ANCESTOR);
            }
            return true;
        }

        private boolean parseLiteral(boolean acceptObjectLiteral) {
            if (this.hasTokenType(GqlTokenTypes.INT_LITERAL, new IElementType[0])) {
                this.createTokenElement(GqlElementTypes.INT_LITERAL);
            } else if (this.hasTokenType(GqlTokenTypes.FLOAT_LITERAL, new IElementType[0])) {
                this.createTokenElement(GqlElementTypes.FLOAT_LITERAL);
            } else if (this.hasTokenType(GqlTokenTypes.STRING_LITERAL, new IElementType[0])) {
                this.createTokenElement(GqlElementTypes.STRING_LITERAL);
            } else if (this.hasTokenType(GqlTokenTypes.TRUE, GqlTokenTypes.FALSE)) {
                this.createTokenElement(GqlElementTypes.BOOLEAN_LITERAL);
            } else if (this.hasTokenType(GqlTokenTypes.NULL, new IElementType[0])) {
                this.createTokenElement(GqlElementTypes.NULL_LITERAL);
            } else if (this.hasTokenType(GqlTokenTypes.ID, new IElementType[0]) && acceptObjectLiteral) {
                this.parseObjectLiteral();
            } else {
                this.error("Literal expected");
                return false;
            }
            return true;
        }

        private void parseObjectLiteral() {
            PsiBuilder.Marker expr = this.mark();
            this.createTokenElement(GqlElementTypes.OBJECT_LITERAL_TYPE);
            this.parseList();
            expr.done(GqlElementTypes.OBJECT_LITERAL);
        }

        private void parseList() {
            if (this.hasTokenType(GqlTokenTypes.LPAREN, new IElementType[0])) {
                this.advance();
            } else {
                this.error("( expected");
            }
            if (!this.parseListElement()) {
                return;
            }
            while (this.hasTokenType(GqlTokenTypes.COMMA, new IElementType[0])) {
                this.advance();
                if (this.parseListElement()) continue;
                return;
            }
            if (this.hasTokenType(GqlTokenTypes.RPAREN, new IElementType[0])) {
                this.advance();
            } else {
                this.error(") expected");
            }
        }

        private boolean parseListElement() {
            if (this.hasTokenType(GqlTokenTypes.COLON, new IElementType[0])) {
                this.parseBinding();
                return true;
            }
            return this.parseLiteral(false);
        }

        private void parseOrderBy() {
            if (this.hasTokenType(GqlTokenTypes.ORDER, new IElementType[0])) {
                PsiBuilder.Marker expr = this.mark();
                this.advance();
                if (this.hasTokenType(GqlTokenTypes.BY, new IElementType[0])) {
                    this.advance();
                } else {
                    this.error("BY expected");
                }
                this.parseOrderProperty();
                while (this.hasTokenType(GqlTokenTypes.COMMA, new IElementType[0])) {
                    this.advance();
                    this.parseOrderProperty();
                }
                expr.done(GqlElementTypes.ORDER);
            }
        }

        private void parseOrderProperty() {
            if (this.hasTokenType(GqlTokenTypes.ID, new IElementType[0])) {
                PsiBuilder.Marker expr = this.mark();
                this.advance();
                if (this.hasTokenType(GqlTokenTypes.ASC, new IElementType[0])) {
                    this.createTokenElement(GqlElementTypes.ASC);
                } else if (this.hasTokenType(GqlTokenTypes.DESC, new IElementType[0])) {
                    this.createTokenElement(GqlElementTypes.DESC);
                }
                expr.done(GqlElementTypes.PROPERTY);
            }
        }

        private void parseBinding() {
            PsiBuilder.Marker expr = this.mark();
            this.advance();
            if (this.hasTokenType(GqlTokenTypes.INT_LITERAL, new IElementType[0])) {
                this.createTokenElement(GqlElementTypes.INT_LITERAL);
            } else if (this.hasTokenType(GqlTokenTypes.ID, new IElementType[0])) {
                this.createTokenElement(GqlElementTypes.PARAM_NAME);
            } else {
                this.error("int or name expected");
            }
            expr.done(GqlElementTypes.BINDING);
        }

        private void parseLimit() {
            if (this.hasTokenType(GqlTokenTypes.LIMIT, new IElementType[0])) {
                PsiBuilder.Marker expr = this.mark();
                this.advance();
                if (this.hasTokenType(GqlTokenTypes.INT_LITERAL, new IElementType[0])) {
                    this.createTokenElement(GqlElementTypes.INT_LITERAL);
                } else {
                    this.error("int expected");
                }
                if (this.hasTokenType(GqlTokenTypes.COMMA, new IElementType[0])) {
                    this.advance();
                    if (this.hasTokenType(GqlTokenTypes.INT_LITERAL, new IElementType[0])) {
                        this.createTokenElement(GqlElementTypes.INT_LITERAL);
                    } else {
                        this.error("int expected");
                    }
                }
                expr.done(GqlElementTypes.LIMIT);
            }
        }

        private void parseOffset() {
            if (this.hasTokenType(GqlTokenTypes.OFFSET, new IElementType[0])) {
                PsiBuilder.Marker expr = this.mark();
                this.advance();
                if (this.hasTokenType(GqlTokenTypes.INT_LITERAL, new IElementType[0])) {
                    this.createTokenElement(GqlElementTypes.INT_LITERAL);
                } else {
                    this.error("int expected");
                }
                expr.done(GqlElementTypes.OFFSET);
            }
        }
    }
}

