/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.appengine.lang.gql.parsing;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.appengine.lang.gql.parsing.GqlElementType;
import com.jetbrains.appengine.lang.gql.parsing.GqlTokenTypes;
import java.util.HashMap;
import java.util.Map;

public class KeywordsHelper
implements GqlTokenTypes {
    private static final Map<String, GqlElementType> KEYWORDS = new HashMap<String, GqlElementType>();

    public static IElementType token(CharSequence text2) {
        String name = text2.toString();
        GqlElementType type = KEYWORDS.get(StringUtil.toLowerCase((String)name));
        if (type != null) {
            return type;
        }
        return ID;
    }

    private static void add(IElementType type) {
        GqlElementType gqlType = (GqlElementType)type;
        String keyword = StringUtil.toLowerCase((String)gqlType.getName());
        KEYWORDS.put(keyword, gqlType);
    }

    static {
        KeywordsHelper.add(SELECT);
        KeywordsHelper.add(FROM);
        KeywordsHelper.add(WHERE);
        KeywordsHelper.add(AND);
        KeywordsHelper.add(ANCESTOR);
        KeywordsHelper.add(IS);
        KeywordsHelper.add(IN);
        KeywordsHelper.add(TRUE);
        KeywordsHelper.add(FALSE);
        KeywordsHelper.add(NULL);
        KeywordsHelper.add(ORDER);
        KeywordsHelper.add(BY);
        KeywordsHelper.add(ASC);
        KeywordsHelper.add(DESC);
        KeywordsHelper.add(LIMIT);
        KeywordsHelper.add(OFFSET);
    }
}

