/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.appengine.lang.gql.highlighting;

import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.appengine.lang.gql.highlighting.GqlHighlighterColors;
import com.jetbrains.appengine.lang.gql.parsing.GqlTokenTypes;
import com.jetbrains.appengine.lang.gql.parsing.lexer.GqlLexer;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class GqlHighlighter
extends SyntaxHighlighterBase {
    private static final Map<IElementType, TextAttributesKey> ATTRIBUTES = new HashMap<IElementType, TextAttributesKey>();

    @NotNull
    public Lexer getHighlightingLexer() {
        return new GqlLexer();
    }

    public TextAttributesKey @NotNull [] getTokenHighlights(IElementType tokenType) {
        TextAttributesKey[] textAttributesKeyArray = GqlHighlighter.pack((TextAttributesKey)ATTRIBUTES.get(tokenType));
        if (textAttributesKeyArray == null) {
            GqlHighlighter.$$$reportNull$$$0(0);
        }
        return textAttributesKeyArray;
    }

    private static void register(IElementType type, TextAttributesKey attributes) {
        ATTRIBUTES.put(type, attributes);
    }

    static {
        GqlHighlighter.register(GqlTokenTypes.SELECT, GqlHighlighterColors.GQL_KEYWORD);
        GqlHighlighter.register(GqlTokenTypes.FROM, GqlHighlighterColors.GQL_KEYWORD);
        GqlHighlighter.register(GqlTokenTypes.WHERE, GqlHighlighterColors.GQL_KEYWORD);
        GqlHighlighter.register(GqlTokenTypes.AND, GqlHighlighterColors.GQL_KEYWORD);
        GqlHighlighter.register(GqlTokenTypes.ORDER, GqlHighlighterColors.GQL_KEYWORD);
        GqlHighlighter.register(GqlTokenTypes.BY, GqlHighlighterColors.GQL_KEYWORD);
        GqlHighlighter.register(GqlTokenTypes.ASC, GqlHighlighterColors.GQL_KEYWORD);
        GqlHighlighter.register(GqlTokenTypes.DESC, GqlHighlighterColors.GQL_KEYWORD);
        GqlHighlighter.register(GqlTokenTypes.LIMIT, GqlHighlighterColors.GQL_KEYWORD);
        GqlHighlighter.register(GqlTokenTypes.OFFSET, GqlHighlighterColors.GQL_KEYWORD);
        GqlHighlighter.register(GqlTokenTypes.NULL, GqlHighlighterColors.GQL_KEYWORD);
        GqlHighlighter.register(GqlTokenTypes.TRUE, GqlHighlighterColors.GQL_KEYWORD);
        GqlHighlighter.register(GqlTokenTypes.FALSE, GqlHighlighterColors.GQL_KEYWORD);
        GqlHighlighter.register(GqlTokenTypes.IN, GqlHighlighterColors.GQL_KEYWORD);
        GqlHighlighter.register(GqlTokenTypes.ANCESTOR, GqlHighlighterColors.GQL_KEYWORD);
        GqlHighlighter.register(GqlTokenTypes.IS, GqlHighlighterColors.GQL_KEYWORD);
        GqlHighlighter.register(GqlTokenTypes.STRING_LITERAL, GqlHighlighterColors.GQL_STRING_LITERAL);
        GqlHighlighter.register(GqlTokenTypes.INT_LITERAL, GqlHighlighterColors.GQL_INT_LITERAL);
        GqlHighlighter.register(GqlTokenTypes.ID, GqlHighlighterColors.GQL_ID);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/appengine/lang/gql/highlighting/GqlHighlighter", "getTokenHighlights"));
    }
}

