/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.appengine.inspection;

import com.google.common.collect.ImmutableSet;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.QualifiedName;
import com.jetbrains.appengine.facet.AppEngineFacet;
import com.jetbrains.appengine.facet.AppEngineFacetConfiguration;
import com.jetbrains.appengine.inspection.AppEngineInspection;
import com.jetbrains.appengine.ui.AppEngineBundle;
import com.jetbrains.appengine.util.AppEngineUtil;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyPossibleClassMember;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import java.util.Objects;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.YAMLUtil;
import org.jetbrains.yaml.psi.YAMLFile;

public class SandboxInspection
extends AppEngineInspection {
    private static final String MODULE_BUILTIN = "__builtin__";
    private static final String MODULE_SOCKET = "socket";
    private static final String MODULE_SUBPROCESS = "subprocess";
    private static final String MODULE_THREADING = "threading";
    private static final String MODULE_THREAD = "thread";
    private static final String FUNC_OPEN = "open";
    private static final String FUNC_SOCKET = "socket";
    private static final String FUNC_SOCKETPAIR = "socketpair";
    private static final String FUNC_CREATE_CONNECTION = "create_connection";
    private static final String FUNC_CALL = "call";
    private static final String FUNC_CHECK_CALL = "check_call";
    private static final String FUNC_POPEN = "Popen";
    private static final String FUNC_START_NEW_THREAD = "start_new_thread";
    private static final String FUNC_START_NEW = "start_new";
    private static final String CLASS_THREAD = "Thread";
    private static final String THREAD_METHOD_START = "start";
    private static final ImmutableSet<String> FORBIDDEN_MODULES_27 = ImmutableSet.of((Object)"ctypes", (Object)"sqlite", (Object)"ssl", (Object)"_ssl", (Object)"fcntl", (Object)"spwd", (Object[])new String[]{"pwd", "grp", "syslog", "select", "_socket"});

    @Override
    @NotNull
    public String getShortName() {
        return "Restricted_Python_calls";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            SandboxInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            SandboxInspection.$$$reportNull$$$0(1);
        }
        return new SandboxPythonCallChecker(holder, session);
    }

    private static String getAppEngineRuntime(Module module) {
        return (String)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> {
            AppEngineFacet engineFacet = AppEngineFacet.getInstance(module);
            if (engineFacet != null) {
                AppEngineFacetConfiguration configuration = (AppEngineFacetConfiguration)engineFacet.getConfiguration();
                YAMLFile yaml = AppEngineUtil.getAppYaml(module.getProject(), configuration.getProjectRoot());
                if (yaml != null) {
                    Pair val = YAMLUtil.getValue((YAMLFile)yaml, (String[])new String[]{"runtime"});
                    if (val != null) {
                        return CachedValueProvider.Result.create((Object)val.getSecond(), (Object[])new Object[]{yaml});
                    }
                    return CachedValueProvider.Result.create((Object)"python", (Object[])new Object[]{yaml});
                }
            }
            return CachedValueProvider.Result.create((Object)"python", (Object[])new Object[]{VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS, ProjectRootManager.getInstance((Project)module.getProject())});
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/appengine/inspection/SandboxInspection";
        objectArray[2] = "buildVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class SandboxPythonCallChecker
    extends PyInspectionVisitor {
        private SandboxPythonCallChecker(ProblemsHolder holder, LocalInspectionToolSession session) {
            super(holder, session);
        }

        @Override
        public void visitPyCallExpression(PyCallExpression node) {
            String version;
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)node);
            if (module != null && AppEngineFacet.isPresent(module) && this.isSystemCall(node, version = SandboxInspection.getAppEngineRuntime(module))) {
                this.registerProblem((PsiElement)node, AppEngineBundle.message("sandbox-inspection-msg", new Object[0]));
            }
        }

        @Override
        public void visitPyImportElement(PyImportElement node) {
            this.checkForbiddenImport((PsiElement)node, node.getImportedQName());
        }

        @Override
        public void visitPyFromImportStatement(PyFromImportStatement node) {
            this.checkForbiddenImport((PsiElement)node, node.getImportSourceQName());
        }

        private void checkForbiddenImport(PsiElement node, QualifiedName qName) {
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)node);
            if (module != null && AppEngineFacet.isPresent(module) && qName != null && FORBIDDEN_MODULES_27.contains((Object)qName.toString()) && SandboxInspection.getAppEngineRuntime(module).equals("python27")) {
                this.registerProblem(node, "This C module is not available in the Python 2.7 App Engine runtime");
            }
        }

        private boolean isSystemCall(PyCallExpression call, String version) {
            if (this.isWriteFile(call) || this.isOpenSocket(call) || this.isCreateProcess(call)) {
                return true;
            }
            return version.equals("python") && (this.isCreateThread(call) || this.isStartThread(call));
        }

        private boolean isWriteFile(@NotNull PyCallExpression call) {
            PyExpression modeArg;
            PyExpression[] args2;
            if (call == null) {
                SandboxPythonCallChecker.$$$reportNull$$$0(0);
            }
            if (call.isCalleeText(SandboxInspection.FUNC_OPEN) && this.isCalleeLocatedIn(call, SandboxInspection.MODULE_BUILTIN) && (args2 = call.getArguments()).length >= 2 && (modeArg = args2[1]) instanceof PyStringLiteralExpression) {
                String mode = ((PyStringLiteralExpression)modeArg).getStringValue();
                return SandboxPythonCallChecker.isWriteMode(mode);
            }
            return false;
        }

        private boolean isOpenSocket(@NotNull PyCallExpression call) {
            if (call == null) {
                SandboxPythonCallChecker.$$$reportNull$$$0(1);
            }
            return call.isCalleeText("socket", SandboxInspection.FUNC_SOCKETPAIR, SandboxInspection.FUNC_CREATE_CONNECTION) && this.isCalleeLocatedIn(call, "socket");
        }

        private boolean isCalleeLocatedIn(@NotNull PyCallExpression call, @NotNull String moduleName) {
            if (call == null) {
                SandboxPythonCallChecker.$$$reportNull$$$0(2);
            }
            if (moduleName == null) {
                SandboxPythonCallChecker.$$$reportNull$$$0(3);
            }
            return call.multiResolveCalleeFunction(this.getResolveContext()).stream().map(callable -> QualifiedNameFinder.findShortestImportableName((PsiElement)call, callable.getContainingFile().getVirtualFile())).anyMatch(moduleName::equals);
        }

        private boolean isCreateProcess(@NotNull PyCallExpression call) {
            if (call == null) {
                SandboxPythonCallChecker.$$$reportNull$$$0(4);
            }
            return call.isCalleeText(SandboxInspection.FUNC_CALL, SandboxInspection.FUNC_CHECK_CALL, SandboxInspection.FUNC_POPEN) && this.isCalleeLocatedIn(call, SandboxInspection.MODULE_SUBPROCESS);
        }

        private boolean isCreateThread(@NotNull PyCallExpression call) {
            if (call == null) {
                SandboxPythonCallChecker.$$$reportNull$$$0(5);
            }
            return call.isCalleeText(SandboxInspection.FUNC_START_NEW_THREAD, SandboxInspection.FUNC_START_NEW) && this.isCalleeLocatedIn(call, SandboxInspection.MODULE_THREAD);
        }

        private boolean isStartThread(@NotNull PyCallExpression call) {
            if (call == null) {
                SandboxPythonCallChecker.$$$reportNull$$$0(6);
            }
            if (call.isCalleeText(SandboxInspection.THREAD_METHOD_START)) {
                Predicate<PyClass> threadInThreading = cls -> cls != null && SandboxInspection.CLASS_THREAD.equals(cls.getName()) && SandboxInspection.MODULE_THREADING.equals(QualifiedNameFinder.findShortestImportableName((PsiElement)call, cls.getContainingFile().getVirtualFile()));
                return call.multiResolveCalleeFunction(this.getResolveContext()).stream().map(PyCallable::asMethod).filter(Objects::nonNull).map(PyPossibleClassMember::getContainingClass).anyMatch(threadInThreading);
            }
            return false;
        }

        private static boolean isWriteMode(String mode) {
            if (mode == null) {
                return false;
            }
            return mode.contains("w") || mode.contains("r+");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = SandboxInspection.FUNC_CALL;
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "moduleName";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/appengine/inspection/SandboxInspection$SandboxPythonCallChecker";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isWriteFile";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isOpenSocket";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isCalleeLocatedIn";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isCreateProcess";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isCreateThread";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isStartThread";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

