/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.appengine.inspection;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.appengine.index.GqlQueryIndexManager;
import com.jetbrains.appengine.index.QueryIndex;
import com.jetbrains.appengine.inspection.AppEngineInspection;
import com.jetbrains.appengine.inspection.GenerateIndexQuickFix;
import com.jetbrains.appengine.lang.gql.psi.GqlQuery;
import com.jetbrains.appengine.ui.AppEngineBundle;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class IndexRequiredQueryInspection
extends AppEngineInspection {
    @Override
    @NotNull
    public String getShortName() {
        return "Query_index_required";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            IndexRequiredQueryInspection.$$$reportNull$$$0(0);
        }
        return new GqlQueryChecker(holder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/appengine/inspection/IndexRequiredQueryInspection", "buildVisitor"));
    }

    private static class GqlQueryChecker
    extends PsiElementVisitor {
        private final ProblemsHolder myHolder;
        private final Map<Module, Set<QueryIndex>> myIndexesByModule = new HashMap<Module, Set<QueryIndex>>();

        private GqlQueryChecker(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                GqlQueryChecker.$$$reportNull$$$0(0);
            }
            if (element instanceof GqlQuery) {
                this.checkQuery((GqlQuery)element);
            } else {
                super.visitElement(element);
            }
        }

        private void checkQuery(GqlQuery query) {
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)query);
            if (module == null) {
                return;
            }
            Set<QueryIndex> indexes = this.getIndexes(module);
            QueryIndex index = GqlQueryIndexManager.getIndex(query);
            if (!(index == null || indexes != null && indexes.contains(index))) {
                GenerateIndexQuickFix fix = new GenerateIndexQuickFix(ModuleUtilCore.findModuleForPsiElement((PsiElement)query), index);
                this.myHolder.registerProblem((PsiElement)query, AppEngineBundle.message("query-inspection-error-msg", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{fix});
            }
        }

        private Set<QueryIndex> getIndexes(Module module) {
            Set<QueryIndex> indexes = this.myIndexesByModule.get(module);
            if (indexes == null) {
                indexes = GqlQueryIndexManager.getIndexes(module);
                this.myIndexesByModule.put(module, indexes);
            }
            return indexes;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/appengine/inspection/IndexRequiredQueryInspection$GqlQueryChecker", "visitElement"));
        }
    }
}

