/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.appengine.inspection;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.jetbrains.appengine.facet.AppEngineFacet;
import com.jetbrains.appengine.inspection.AppEngineInspection;
import com.jetbrains.appengine.ui.AppEngineBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.YAMLUtil;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLSequence;
import org.jetbrains.yaml.psi.YAMLSequenceItem;

public class AppEngineThreadsafeCGIHandlerInspection
extends AppEngineInspection {
    @Override
    @NotNull
    public String getShortName() {
        return "AppEngineThreadsafeCGIHandlerInspection";
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            AppEngineThreadsafeCGIHandlerInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            AppEngineThreadsafeCGIHandlerInspection.$$$reportNull$$$0(1);
        }
        return new Visitor(holder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/appengine/inspection/AppEngineThreadsafeCGIHandlerInspection";
        objectArray[2] = "buildVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class Visitor
    extends PsiElementVisitor {
        private final ProblemsHolder myHolder;

        private Visitor(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        public void visitFile(@NotNull PsiFile file2) {
            Module module;
            if (file2 == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file2)) == null || !AppEngineFacet.isPresent(module)) {
                return;
            }
            if (file2 instanceof YAMLFile && "app.yaml".equals(file2.getName())) {
                boolean threadsafeEnabled = false;
                for (YAMLKeyValue keyValue : YAMLUtil.getTopLevelKeys((YAMLFile)((YAMLFile)file2))) {
                    String value2;
                    String keyText = keyValue.getKeyText();
                    if (!"threadsafe".equals(keyText) || !"yes".equals(value2 = keyValue.getValueText().trim())) continue;
                    threadsafeEnabled = true;
                }
                if (!threadsafeEnabled) {
                    return;
                }
                for (YAMLKeyValue keyValue : YAMLUtil.getTopLevelKeys((YAMLFile)((YAMLFile)file2))) {
                    if (!"handlers".equals(keyValue.getKeyText()) || !(keyValue.getValue() instanceof YAMLSequence)) continue;
                    for (YAMLSequenceItem item : ((YAMLSequence)keyValue.getValue()).getItems()) {
                        String scriptValue;
                        YAMLKeyValue scriptEntry;
                        if (!(item.getValue() instanceof YAMLMapping) || (scriptEntry = ((YAMLMapping)item.getValue()).getKeyValueByKey("script")) == null || !(scriptValue = scriptEntry.getValueText().trim()).endsWith(".py") && !scriptValue.contains("/")) continue;
                        this.myHolder.registerProblem((PsiElement)scriptEntry, AppEngineBundle.message("threadsafe-CGI-handler", new Object[0]), new LocalQuickFix[0]);
                    }
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/appengine/inspection/AppEngineThreadsafeCGIHandlerInspection$Visitor", "visitFile"));
        }
    }
}

