/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.appengine.facet;

import com.intellij.DynamicBundle;
import com.intellij.facet.impl.ui.FacetErrorPanel;
import com.intellij.facet.ui.FacetEditorValidator;
import com.intellij.facet.ui.FacetValidatorsManager;
import com.intellij.facet.ui.ValidationResult;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Comparing;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jetbrains.appengine.facet.AppEngineFacetConfiguration;
import com.jetbrains.appengine.facet.AppEngineWizardSettingsHolder;
import com.jetbrains.appengine.ui.AppEngineBundle;
import com.jetbrains.appengine.util.AppEngineUtil;
import com.jetbrains.python.PythonProBundle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class AppEngineSettingsPanel
extends JPanel {
    private TextFieldWithBrowseButton mySdkFolder;
    private JPanel myPanel;
    private JPanel myErrorPanel;

    public AppEngineSettingsPanel() {
        this.$$$setupUI$$$();
        this.setLayout(new BorderLayout());
        this.add(this.myPanel);
        AppEngineSettingsPanel.init(this.mySdkFolder, "select-sdk-folder-title", "select-sdk-folder-desc");
        this.initErrorValidation();
    }

    private FacetErrorPanel initErrorValidation() {
        FacetErrorPanel facetErrorPanel = new FacetErrorPanel();
        this.myErrorPanel.add((Component)facetErrorPanel.getComponent(), "Center");
        FacetValidatorsManager validatorsManager = facetErrorPanel.getValidatorsManager();
        validatorsManager.registerValidator(new FacetEditorValidator(){

            @NotNull
            public ValidationResult check() {
                ValidationResult validationResult = AppEngineSettingsPanel.validateSdkFolder(AppEngineSettingsPanel.this.mySdkFolder.getText());
                if (validationResult == null) {
                    1.$$$reportNull$$$0(0);
                }
                return validationResult;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/appengine/facet/AppEngineSettingsPanel$1", "check"));
            }
        }, new JComponent[]{this.mySdkFolder.getTextField()});
        validatorsManager.validate();
        return facetErrorPanel;
    }

    private static ValidationResult validateSdkFolder(String path) {
        String version;
        ValidationResult sdkValidationResult = AppEngineUtil.validateSdk(path);
        if (ValidationResult.OK != sdkValidationResult) {
            return sdkValidationResult;
        }
        if (AppEngineUtil.isGoogleCloudSdkFolder(path)) {
            path = AppEngineUtil.getAppEngineComponent(path);
        }
        if ((version = AppEngineUtil.getAppEngineSdkVersion(path)) == null) {
            return new ValidationResult(PythonProBundle.message("appengine.sdk.version.validation.error.message"));
        }
        return ValidationResult.OK;
    }

    public String getSdkFolder() {
        return this.mySdkFolder.getText();
    }

    public void setSdkFolder(String folder) {
        this.mySdkFolder.setText(folder != null ? folder : "");
    }

    private static void init(TextFieldWithBrowseButton browse, String titleKey, String descKey) {
        browse.setTextFieldPreferredWidth(50);
        String title = AppEngineBundle.message(titleKey, new Object[0]);
        String desc = AppEngineBundle.message(descKey, new Object[0]);
        FileChooserDescriptor descriptor2 = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        browse.addBrowseFolderListener(title, desc, null, descriptor2, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT);
    }

    public void reset(AppEngineFacetConfiguration config) {
        this.setSdkFolder(config.getSdkFolder());
        AppEngineSettingsPanel.validateSdkFolder(this.mySdkFolder.getText());
    }

    public void apply(AppEngineFacetConfiguration config) {
        String sdkFolder = this.getSdkFolder();
        config.setSdkFolder(sdkFolder);
        if (AppEngineUtil.isStandaloneAppEgineSdkFolder(sdkFolder)) {
            AppEngineWizardSettingsHolder.setDefaultAppEngineSdkFolder(sdkFolder);
        }
    }

    public boolean isModified(AppEngineFacetConfiguration config) {
        return !Comparing.equal((String)this.getSdkFolder(), (String)config.getSdkFolder());
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/AppEngineBundle", AppEngineSettingsPanel.class).getString("python.app.engine.settings.sdk.dir"));
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.mySdkFolder = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel2.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myErrorPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

