/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.appengine.appcfg;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.jetbrains.appengine.facet.AppEngineFacet;
import com.jetbrains.appengine.facet.AppEngineFacetConfiguration;
import com.jetbrains.commandInterface.command.CommandExecutor;
import com.jetbrains.django.util.VirtualFileUtil;
import com.jetbrains.python.run.PythonTask;
import com.jetbrains.python.sdk.PythonEnvUtil;
import com.jetbrains.python.sdk.PythonSdkUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AppcfgConsoleExecutor
implements CommandExecutor {
    static final CommandExecutor INSTANCE = new AppcfgConsoleExecutor();
    private static final Logger LOG = Logger.getInstance(AppcfgConsoleExecutor.class);

    private AppcfgConsoleExecutor() {
    }

    @Override
    public void execute(@NotNull String commandName, @NotNull Module module, @NotNull List<String> parameters, @Nullable ConsoleView consoleView) {
        if (commandName == null) {
            AppcfgConsoleExecutor.$$$reportNull$$$0(0);
        }
        if (module == null) {
            AppcfgConsoleExecutor.$$$reportNull$$$0(1);
        }
        if (parameters == null) {
            AppcfgConsoleExecutor.$$$reportNull$$$0(2);
        }
        try {
            ArrayList<String> list = new ArrayList<String>(parameters);
            list.add(0, commandName);
            AppCfgTask task2 = new AppCfgTask(module, "", list);
            task2.run(consoleView);
        }
        catch (ExecutionException e) {
            LOG.error((Throwable)e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "commandName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "module";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "parameters";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/appengine/appcfg/AppcfgConsoleExecutor";
        objectArray[2] = "execute";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class AppCfgTask
    extends PythonTask {
        private final List<String> myParameters;

        AppCfgTask(Module module, String runTabTitle, List<String> parameters) throws ExecutionException {
            super(module, runTabTitle);
            this.myParameters = parameters;
        }

        @Override
        public GeneralCommandLine createCommandLine() {
            Sdk sdk = PythonSdkUtil.findPythonSdk(this.myModule);
            GeneralCommandLine cmd = new GeneralCommandLine();
            AppEngineFacetConfiguration config = AppEngineFacet.getConfig(this.myModule);
            if (config == null || sdk == null) {
                return cmd;
            }
            String path = sdk.getHomePath();
            if (path == null) {
                return cmd;
            }
            cmd.setExePath(path);
            String appEngineSdkPath = config.getSdkFolder();
            String executable = VirtualFileUtil.buildSystemIndependentPath(appEngineSdkPath, "appcfg.py");
            cmd.addParameter(executable);
            cmd.withWorkDirectory(this.myModule.getProject().getBasePath());
            cmd.addParameters(this.myParameters);
            PythonEnvUtil.resetHomePathChanges(path, cmd.getEnvironment());
            return cmd;
        }
    }
}

