/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.appengine.appcfg;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Ref;
import com.jetbrains.appengine.appcfg.AppcfgArgumentsInfo;
import com.jetbrains.appengine.appcfg.AppcfgConsoleExecutor;
import com.jetbrains.appengine.facet.AppEngineFacet;
import com.jetbrains.appengine.facet.AppEngineFacetConfiguration;
import com.jetbrains.appengine.ui.AppEngineBundle;
import com.jetbrains.commandInterface.command.Command;
import com.jetbrains.commandInterface.command.CommandExecutor;
import com.jetbrains.commandInterface.command.Help;
import com.jetbrains.commandInterface.command.Option;
import com.jetbrains.commandInterface.command.SimpleCommand;
import com.jetbrains.django.manage.DjangoCommandsInfo;
import com.jetbrains.python.PythonHelper;
import com.jetbrains.python.XStreamTools;
import com.jetbrains.python.sdk.PySdkUtil;
import com.jetbrains.python.sdk.PythonSdkUtil;
import com.thoughtworks.xstream.XStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class AppcfgConsoleApi {
    private static final Pattern EXPECTED_DOCUMENT = Pattern.compile(".*(<\\?xml version=\"1.0\".*?\\?><!--jb pycharm data start-->.+$)", 32);
    private static final Logger LOG = Logger.getInstance(AppcfgConsoleApi.class);

    @NotNull
    public static CommandExecutor getDefaultExecutor() {
        CommandExecutor commandExecutor = AppcfgConsoleExecutor.INSTANCE;
        if (commandExecutor == null) {
            AppcfgConsoleApi.$$$reportNull$$$0(0);
        }
        return commandExecutor;
    }

    public static Collection<? extends Command> getCommands(final Module module) {
        final Sdk sdk = PythonSdkUtil.findPythonSdk(module);
        if (sdk == null) {
            return Collections.emptyList();
        }
        final AppEngineFacetConfiguration config = AppEngineFacet.getConfig(module);
        if (config == null) {
            return Collections.emptyList();
        }
        final Ref processResult = new Ref();
        ProgressManager.getInstance().run((Task)new Task.Modal(module.getProject(), AppEngineBundle.message("appcfg-fetching", new Object[0]), false){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                GeneralCommandLine cmd = PythonHelper.APPCFG_CONSOLE.newCommandLine(sdk.getHomePath(), Collections.singletonList(config.getSdkFolder()));
                ProcessOutput output = PySdkUtil.getProcessOutput(cmd, module.getProject().getBasePath(), null, 10000);
                processResult.set((Object)output.getStdout());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/appengine/appcfg/AppcfgConsoleApi$1", "run"));
            }
        });
        Matcher matcher = EXPECTED_DOCUMENT.matcher((CharSequence)processResult.get());
        if (!matcher.matches()) {
            LOG.info("appcfg_fetcher.py produced unexpected document");
            return Collections.emptyList();
        }
        XStream stream = XStreamTools.createWithRootClass(AppcfgCommandInfo.class, "commandInfo");
        stream.autodetectAnnotations(true);
        Object unserializedResult = stream.fromXML(matcher.group(1));
        ArrayList<SimpleCommand> commands = new ArrayList<SimpleCommand>();
        for (AppcfgCommandInfo commandsInfo : (AppcfgCommandInfo[])unserializedResult) {
            commandsInfo.setModule(module);
            commands.add(commandsInfo.getCommand());
        }
        return commands;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/appengine/appcfg/AppcfgConsoleApi", "getDefaultExecutor"));
    }

    private static class AppcfgCommandInfo
    extends DjangoCommandsInfo {
        private Module myModule;

        private AppcfgCommandInfo() {
        }

        @Override
        @NotNull
        protected SimpleCommand buildCommand(String name, List<Option> options, String help, String args2) {
            return new SimpleCommand(name, new Help(help), AppcfgArgumentsInfo.parseArguments(this.myModule, args2), AppcfgConsoleApi.getDefaultExecutor(), options);
        }

        public void setModule(@NotNull Module module) {
            if (module == null) {
                AppcfgCommandInfo.$$$reportNull$$$0(0);
            }
            this.myModule = module;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/jetbrains/appengine/appcfg/AppcfgConsoleApi$AppcfgCommandInfo", "setModule"));
        }
    }
}

