/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.appengine;

import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.QualifiedName;
import com.jetbrains.python.documentation.PythonDocumentationLinkProvider;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class AppEngineDocumentationLinkProvider
implements PythonDocumentationLinkProvider {
    @NonNls
    private static final Map<String, String> urlMap = ImmutableMap.builder().put((Object)"google.appengine.ext.db", (Object)"datastore").put((Object)"google.appengine.ext.blobstore", (Object)"blobstore").put((Object)"google.appengine.ext.mapreduce", (Object)"dataprocessing").put((Object)"google.appengine.ext.webapp", (Object)"tools/webapp").put((Object)"google.appengine.api.backends", (Object)"backends").put((Object)"google.appengine.api.capabilities", (Object)"capabilities").put((Object)"google.appengine.api.channel", (Object)"channel").put((Object)"google.appengine.api.files", (Object)"googlestorage").put((Object)"google.appengine.api.images", (Object)"images").put((Object)"google.appengine.api.logservice", (Object)"backends/logserviceapi.html").put((Object)"google.appengine.api.mail", (Object)"mail").put((Object)"google.appengine.api.memcache", (Object)"memcache").put((Object)"google.appengine.api.namespace_manager", (Object)"multitenancy").put((Object)"google.appengine.api.oauth", (Object)"oauth").put((Object)"google.appengine.api.prospective_search", (Object)"prospectivesearch").put((Object)"google.appengine.api.runtime", (Object)"backends/runtimeapi.html").put((Object)"google.appengine.api.taskqueue", (Object)"taskqueue").put((Object)"google.appengine.api.users", (Object)"users").put((Object)"google.appengine.api.xmpp", (Object)"xmpp").build();

    @Override
    public String getExternalDocumentationUrl(PsiElement element, PsiElement originalElement) {
        QualifiedName qName = QualifiedNameFinder.findCanonicalImportPath(element, originalElement);
        if (qName != null && qName.matchesPrefix(QualifiedName.fromComponents((String[])new String[]{"google", "appengine"}))) {
            StringBuilder baseUrl = new StringBuilder("http://code.google.com/appengine/docs/python/");
            for (Map.Entry<String, String> entry : urlMap.entrySet()) {
                if (!qName.matchesPrefix(QualifiedName.fromDottedString((String)entry.getKey()))) continue;
                baseUrl.append(entry.getValue());
                if (!entry.getValue().endsWith(".html")) {
                    baseUrl.append("/");
                }
                PyClass pyClass = AppEngineDocumentationLinkProvider.classOf(element);
                if (entry.getValue().equals("datastore") && pyClass != null && pyClass.getName().endsWith("Property")) {
                    baseUrl.append("typesandpropertyclasses.html#").append(pyClass.getName());
                    continue;
                }
                if (AppEngineDocumentationLinkProvider.appendClassFunction(baseUrl, element, pyClass)) continue;
                return null;
            }
            return baseUrl.toString();
        }
        return null;
    }

    private static boolean appendClassFunction(StringBuilder baseUrl, PsiElement element, PyClass pyClass) {
        if (pyClass != null) {
            if (pyClass.isSubclass("exception", null)) {
                baseUrl.append("exceptions.html");
            } else {
                String className = pyClass.getName();
                if (className == null) {
                    return false;
                }
                baseUrl.append(StringUtil.toLowerCase((String)className)).append("class.html");
                if (element instanceof PyFunction) {
                    baseUrl.append("#").append(className).append("_").append(((PyFunction)element).getName());
                }
            }
        } else if (element instanceof PyFunction) {
            if (!baseUrl.toString().endsWith(".html")) {
                baseUrl.append("functions.html");
            }
            baseUrl.append("#").append(((PyFunction)element).getName());
        }
        return true;
    }

    @Nullable
    private static PyClass classOf(PsiElement element) {
        PyClass pyClass = null;
        if (element instanceof PyClass) {
            pyClass = (PyClass)element;
        } else if (element instanceof PyFunction) {
            pyClass = ((PyFunction)element).getContainingClass();
        }
        return pyClass;
    }
}

