/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains;

import com.intellij.diagram.DiagramVfsResolver;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.jetbrains.ERDummyModelInit;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.stubs.PyClassNameIndex;
import org.jetbrains.annotations.Nullable;

public class ERUmlVfsResolver
implements DiagramVfsResolver<PyClass> {
    @Nullable
    public String getQualifiedName(@Nullable PyClass element) {
        if (element == null) {
            return null;
        }
        if (element instanceof ERDummyModelInit) {
            return "#" + ((ERDummyModelInit)element).getModule().getName();
        }
        return element.getQualifiedName();
    }

    public PyClass resolveElementByFQN(String fqn, Project project) {
        try {
            if (fqn.startsWith("#")) {
                String moduleName = fqn.substring(1);
                Module module = ModuleManager.getInstance((Project)project).findModuleByName(moduleName);
                if (module != null) {
                    return new ERDummyModelInit(module);
                }
            }
            return PyClassNameIndex.findClass(fqn, project);
        }
        catch (IndexNotReadyException e) {
            return null;
        }
    }
}

