/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.rules;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.testFramework.PlatformTestUtil;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.jetbrains.annotations.NotNull;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class TempDirectory
extends TemporaryFolder {
    private String myName;
    private File myRoot;

    @NotNull
    public Statement apply(@NotNull Statement base, @NotNull Description description) {
        if (base == null) {
            TempDirectory.$$$reportNull$$$0(0);
        }
        if (description == null) {
            TempDirectory.$$$reportNull$$$0(1);
        }
        this.myName = PlatformTestUtil.lowercaseFirstLetter(FileUtil.sanitizeFileName((String)description.getMethodName(), (boolean)false), true);
        Statement statement2 = super.apply(base, description);
        if (statement2 == null) {
            TempDirectory.$$$reportNull$$$0(2);
        }
        return statement2;
    }

    protected void before() {
    }

    protected void after() {
        if (this.myRoot != null) {
            FileUtil.delete((File)this.myRoot);
            this.myRoot = null;
            this.myName = null;
        }
    }

    public File getRoot() {
        if (this.myRoot == null) {
            if (this.myName == null) {
                throw new IllegalStateException("apply() was not called");
            }
            try {
                this.myRoot = Files.createTempDirectory("unitTest_" + this.myName + '_', new FileAttribute[0]).toRealPath(new LinkOption[0]).toFile();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return this.myRoot;
    }

    public File newFolder(String directoryName) throws IOException {
        Path dir = Paths.get(this.getRoot().getPath(), directoryName);
        if (dir.toFile().exists()) {
            throw new IOException("Already exists: " + dir);
        }
        Files.createDirectories(dir, new FileAttribute[0]);
        return dir.toFile();
    }

    public File newFile(String fileName) throws IOException {
        Path file2 = Paths.get(this.getRoot().getPath(), fileName);
        if (file2.toFile().exists()) {
            throw new IOException("Already exists: " + file2);
        }
        TempDirectory.makeDirectories(file2.getParent());
        Files.createFile(file2, new FileAttribute[0]);
        return file2.toFile();
    }

    private static void makeDirectories(Path path) throws IOException {
        if (!Files.isDirectory(path, new LinkOption[0])) {
            TempDirectory.makeDirectories(path.getParent());
            Files.createDirectory(path, new FileAttribute[0]);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/rules/TempDirectory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/rules/TempDirectory";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "apply";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

