/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.util.text.StringUtil;
import java.util.function.Function;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;

public class TreeNodeTester {
    private final TreeNode myNode;
    private Function<? super TreeNode, String> myPresenter = Object::toString;

    @Deprecated
    public static TreeNodeTester forTree(JTree tree) {
        return TreeNodeTester.forNode((TreeNode)tree.getModel().getRoot());
    }

    public static TreeNodeTester forNode(TreeNode node) {
        return new TreeNodeTester(node);
    }

    private TreeNodeTester(TreeNode node) {
        this.myNode = node;
    }

    public TreeNodeTester withPresenter(Function<? super TreeNode, String> presenter) {
        this.myPresenter = presenter;
        return this;
    }

    @NotNull
    public String constructTextRepresentation() {
        StringBuilder buffer = new StringBuilder();
        this.printSubTree(this.myNode, 0, buffer);
        String string = buffer.toString();
        if (string == null) {
            TreeNodeTester.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void assertStructureEquals(String expected) {
        Assert.assertEquals((Object)expected, (Object)this.constructTextRepresentation());
    }

    private void printSubTree(TreeNode node, int level, StringBuilder result) {
        result.append(StringUtil.repeat((String)" ", (int)level)).append(this.myPresenter.apply(node)).append("\n");
        for (int i = 0; i < node.getChildCount(); ++i) {
            this.printSubTree(node.getChildAt(i), level + 1, result);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/TreeNodeTester", "constructTextRepresentation"));
    }
}

