/*
 * Decompiled with CFR 0.152.
 */
package git4idea.status;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerGate;
import com.intellij.openapi.vcs.changes.ChangeProvider;
import com.intellij.openapi.vcs.changes.ChangelistBuilder;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.VcsDirtyScope;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.changes.VcsModifiableDirtyScope;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitContentRevision;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.changes.GitChangeUtils;
import git4idea.commands.Git;
import git4idea.repo.GitConflictsHolder;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.status.GitChangesCollector;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class GitChangeProvider
implements ChangeProvider {
    static final Logger LOG = Logger.getInstance((String)"#GitStatus");
    @NotNull
    private final Project project;

    public GitChangeProvider(@NotNull Project project) {
        if (project == null) {
            GitChangeProvider.$$$reportNull$$$0(0);
        }
        this.project = project;
    }

    public void getChanges(@NotNull VcsDirtyScope dirtyScope, @NotNull ChangelistBuilder builder, @NotNull ProgressIndicator progress, @NotNull ChangeListManagerGate addGate) throws VcsException {
        if (dirtyScope == null) {
            GitChangeProvider.$$$reportNull$$$0(1);
        }
        if (builder == null) {
            GitChangeProvider.$$$reportNull$$$0(2);
        }
        if (progress == null) {
            GitChangeProvider.$$$reportNull$$$0(3);
        }
        if (addGate == null) {
            GitChangeProvider.$$$reportNull$$$0(4);
        }
        GitVcs vcs = GitVcs.getInstance(this.project);
        GitRepositoryManager repositoryManager = GitUtil.getRepositoryManager(this.project);
        if (LOG.isDebugEnabled()) {
            LOG.debug("initial dirty scope: " + dirtyScope);
        }
        GitChangeProvider.appendNestedVcsRootsToDirt(dirtyScope, vcs, ProjectLevelVcsManager.getInstance((Project)this.project));
        if (LOG.isDebugEnabled()) {
            LOG.debug("after adding nested vcs roots to dirt: " + dirtyScope);
        }
        Collection affected = dirtyScope.getAffectedContentRoots();
        Set repos = ContainerUtil.map2SetNotNull((Collection)affected, arg_0 -> ((GitRepositoryManager)repositoryManager).getRepositoryForRoot(arg_0));
        ArrayList<FilePath> newDirtyPaths = new ArrayList<FilePath>();
        try {
            MyNonChangedHolder holder = new MyNonChangedHolder(this.project, addGate);
            Map<VirtualFile, List<FilePath>> dirtyPaths = GitChangesCollector.collectDirtyPaths(vcs, dirtyScope, ChangeListManager.getInstance((Project)this.project), ProjectLevelVcsManager.getInstance((Project)this.project));
            for (GitRepository repo : repos) {
                LOG.debug("checking root: " + repo.getRoot().getPath());
                List rootDirtyPaths = ContainerUtil.notNullize(dirtyPaths.get(repo.getRoot()));
                GitChangesCollector collector = GitChangesCollector.collect(this.project, Git.getInstance(), repo, rootDirtyPaths);
                Collection<Change> changes = collector.getChanges();
                holder.changed(changes);
                for (Change file : changes) {
                    LOG.debug("process change: " + ChangesUtil.getFilePath((Change)file).getPath());
                    builder.processChange(file, GitVcs.getKey());
                    if (!file.isMoved() && !file.isRenamed()) continue;
                    FilePath beforePath = Objects.requireNonNull(ChangesUtil.getBeforePath((Change)file));
                    FilePath afterPath = Objects.requireNonNull(ChangesUtil.getAfterPath((Change)file));
                    if (dirtyScope.belongsTo(beforePath) == dirtyScope.belongsTo(afterPath)) continue;
                    newDirtyPaths.add(beforePath);
                    newDirtyPaths.add(afterPath);
                }
                for (FilePath path : collector.getUnversionedFilePaths()) {
                    builder.processUnversionedFile(path);
                    holder.unversioned(path);
                }
                GitConflictsHolder conflictsHolder = repo.getConflictsHolder();
                conflictsHolder.refresh(dirtyScope, collector.getConflicts());
            }
            holder.feedBuilder(builder);
            VcsDirtyScopeManager.getInstance((Project)this.project).filePathsDirty(newDirtyPaths, null);
        }
        catch (ProcessCanceledException pce) {
            if (pce.getCause() != null) {
                throw new VcsException(pce.getCause().getMessage(), pce.getCause());
            }
            throw new VcsException("Cannot get changes from Git", (Throwable)pce);
        }
        catch (VcsException e) {
            LOG.info((Throwable)e);
            throw e;
        }
    }

    private static void appendNestedVcsRootsToDirt(VcsDirtyScope dirtyScope, GitVcs vcs, ProjectLevelVcsManager vcsManager) {
        Set recursivelyDirtyDirectories = dirtyScope.getRecursivelyDirtyDirectories();
        if (recursivelyDirtyDirectories.isEmpty()) {
            return;
        }
        VirtualFile[] rootsUnderGit = vcsManager.getRootsUnderVcs((AbstractVcs)vcs);
        HashSet<VirtualFile> dirtyDirs = new HashSet<VirtualFile>();
        for (FilePath dir : recursivelyDirtyDirectories) {
            VirtualFile vf = VcsUtil.getVirtualFileWithRefresh((File)dir.getIOFile());
            if (vf == null) continue;
            dirtyDirs.add(vf);
        }
        block1: for (VirtualFile root : rootsUnderGit) {
            if (dirtyDirs.contains(root)) continue;
            for (VirtualFile dirtyDir : dirtyDirs) {
                if (!VfsUtilCore.isAncestor((VirtualFile)dirtyDir, (VirtualFile)root, (boolean)false)) continue;
                LOG.debug("adding git root for check. root: " + root.getPath() + ", dir: " + dirtyDir.getPath());
                ((VcsModifiableDirtyScope)dirtyScope).addDirtyDirRecursively(VcsUtil.getFilePath((VirtualFile)root));
                continue block1;
            }
        }
    }

    public boolean isModifiedDocumentTrackingRequired() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirtyScope";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "addGate";
                break;
            }
        }
        objectArray2[1] = "git4idea/status/GitChangeProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getChanges";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyNonChangedHolder {
        private final Project myProject;
        private final Set<FilePath> myProcessedPaths;
        private final ChangeListManagerGate myAddGate;

        private MyNonChangedHolder(Project project, ChangeListManagerGate addGate) {
            this.myProject = project;
            this.myProcessedPaths = new HashSet<FilePath>();
            this.myAddGate = addGate;
        }

        public void changed(Collection<? extends Change> changes) {
            for (Change change : changes) {
                FilePath afterPath;
                FilePath beforePath = ChangesUtil.getBeforePath((Change)change);
                if (beforePath != null) {
                    this.myProcessedPaths.add(beforePath);
                }
                if ((afterPath = ChangesUtil.getAfterPath((Change)change)) == null) continue;
                this.myProcessedPaths.add(afterPath);
            }
        }

        public void unversioned(FilePath path) {
            this.myProcessedPaths.add(path);
        }

        public void feedBuilder(ChangelistBuilder builder) throws VcsException {
            VcsKey gitKey = GitVcs.getKey();
            HashMap<VirtualFile, GitRevisionNumber> baseRevisions = new HashMap<VirtualFile, GitRevisionNumber>();
            FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
            for (Document document : fileDocumentManager.getUnsavedDocuments()) {
                GitRepository repository;
                FilePath filePath;
                VirtualFile vf = fileDocumentManager.getFile(document);
                if (vf == null || !vf.isValid() || this.myAddGate.getStatus(vf) != null || !fileDocumentManager.isFileModified(vf) || this.myProcessedPaths.contains(filePath = VcsUtil.getFilePath((VirtualFile)vf)) || (repository = (GitRepository)GitRepositoryManager.getInstance(this.myProject).getRepositoryForFile(vf)) == null) continue;
                VirtualFile root = repository.getRoot();
                GitRevisionNumber beforeRevisionNumber = (GitRevisionNumber)baseRevisions.get(root);
                if (beforeRevisionNumber == null) {
                    beforeRevisionNumber = GitChangeUtils.resolveReference(this.myProject, root, "HEAD");
                    baseRevisions.put(root, beforeRevisionNumber);
                }
                Change change = new Change(GitContentRevision.createRevision(filePath, (VcsRevisionNumber)beforeRevisionNumber, this.myProject), GitContentRevision.createRevision(filePath, null, this.myProject), FileStatus.MODIFIED);
                LOG.debug("process in-memory change " + change);
                builder.processChange(change, gitKey);
            }
        }
    }
}

